<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<?php wp_head(); ?>
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon.png'; ?>">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png'; ?>" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/manifest.json'; ?>">
<meta name="theme-color" content="#000000">
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">

<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

<div id="site-top" class="site-wrapper">
	<a href="#site-menu" class="screen-reader-text"><span><?php esc_html_e( 'Skip to navigation', 'cdi-base' ); ?></span></a>
	<a href="#site-content" class="screen-reader-text"><span><?php esc_html_e( 'Skip to content', 'cdi-base' ); ?></span></a>
	<a href="#site-search" class="screen-reader-text"><span><?php esc_html_e( 'Skip to search', 'cdi-base' ); ?></span></a>
	<a href="#mm-site-navigation"><span><?php esc_html_e( 'Menu', 'cdiwpchild' ); ?></span></a>

	<header id="site-header" class="site-header" role="banner">
		<div class="switch-lang">
			<ul>
				<?php
					/* @see https://polylang.wordpress.com/documentation/documentation-for-developers/functions-reference/ */
					pll_the_languages( array(
						'display_names_as' => 'slug',
						'hide_current' => 1,
						'hide_if_no_translation'  => 1
					) );
				?>
			</ul>
		</div>

		<p class="site-header_title h1"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo_seraplus.svg'; ?>" class="logo" width="250" height="177" alt="<?php bloginfo( 'name' ); ?>" /></a></p>

		<div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
		<nav id="site-navigation" class="site-navigation" role="navigation">
			<?php wp_nav_menu( array(
				'theme_location' => 'primary',
				'menu_id' => 'primary-menu',
				'container' => false
			) ); ?>
		</nav><!-- #site-navigation -->

		<div class="header-peinture clearfix">
			<div class="titreheader">
				<?php
				$parent_title = get_the_title( $post->post_parent );
				echo $parent_title;
				?>
			</div>	
		</div>
	</header><!-- #site-header -->

	<div id="site-content-wrapper" class="site-content-wrapper clearfix">