<?php
/**
 * ichier partiel pour afficher le contenu des pages
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	Sante_Chablais
 * @since	Sante_Chablais 2.0.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_front_page() ) :
			/* Si on est sur la page d'accueil on affiche un titre de niveau 2… */
			// the_title( '<h2 class="entry-title">', '</h2>' );
		else :
			/* …sinon on affiche un titre de niveau 1 */
			the_title( '<h1 class="entry-title">', '</h1>' );
		endif;
		?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdiwp' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
