<?php
/**
 * Fichier partiel pour afficher le contenu des pages médecins
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Sara Hernandez
 * @author	Luc Poupard
 *
 * @package	Sante_Chablais
 * @since	Sante_Chablais 2.0.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>

		<div class="js-tabs">		
			<?php
				// Menu des onglets
				if( have_rows('medecin') ): $i = 0;
			?>

				<ul class="js-tablist" data-existing-hx="h2">
					<?php while( have_rows('medecin') ): the_row(); $i++;
						$medecin_nom = get_sub_field('medecin-nom');
					?>
						<li class="js-tablist__item">
							<a href="#medecin_<?php echo $i; ?>" id="label_medecin_<?php echo $i; ?>" class="js-tablist__link"><?php echo $medecin_nom; ?></a>
						</li>
					<?php endwhile; ?>
				</ul>

			<?php endif; ?>
		
			<?php
				// Contenu des onglets
				if( have_rows('medecin') ): $i = 0;
			?>
				<div class="js-tabcontainer">
					<?php while( have_rows('medecin') ): the_row(); $i++;
						$medecin_nom = get_sub_field('medecin-nom');
						$medecin_presentation = get_sub_field('medecin-presentation');

						// Image
						// https://www.advancedcustomfields.com/resources/image/
						$medecin_photo = get_sub_field('medecin-photo');
						// vars
						$medecin_photo_url = $medecin_photo['url'];
						$medecin_photo_title = $medecin_photo['title'];
						$medecin_photo_alt = $medecin_photo['alt'];
						$medecin_photo_caption = $medecin_photo['caption'];
						// thumbnail
						$medecin_photo_size = 'medium';
						$medecin_photo_thumb = $medecin_photo['sizes'][ $medecin_photo_size ];
						$medecin_photo_width = $medecin_photo['sizes'][ $medecin_photo_size . '-width' ];
						$medecin_photo_height = $medecin_photo['sizes'][ $medecin_photo_size . '-height' ];
					?>

					<div id="medecin_<?php echo $i; ?>" class="js-tabcontent">
						<div class="thumbnail">
							<!-- <img src="<?php echo $medecin_photo['url']; ?>" alt="" /> -->
							<!-- <img src="<?php echo $medecin_photo_thumb; ?>" alt="<?php echo $medecin_photo_alt; ?>" width="<?php echo $medecin_photo_width; ?>" height="<?php echo $medecin_photo_height; ?>" /> -->
							<img src="<?php echo $medecin_photo_thumb; ?>" alt="" width="<?php echo $medecin_photo_width; ?>" height="<?php echo $medecin_photo_height; ?>" />
						</div>

						<h2 class="nom">
							<?php echo $medecin_nom; ?>
						</h2>

						<div class="presentation">
							<?php echo $medecin_presentation; ?>
						</div>
					</div>

					<?php endwhile; ?>
				</div>

			<?php endif; ?>
		</div>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'cdiwp' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
</article><!-- #post-## -->