<?php
/**
 * Template Name: Page - sous-menu
 * Fichier pour afficher les pages avec un menu contextuel
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Sara Hernandez
 * @author	Luc Poupard
 *
 * @package	Sante_Chablais
 * @since	Sante_Chablais 2.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<aside class="site-aside">
			<?php echo do_shortcode( '[wpb_childpages]' ); ?>
		</aside>

		<main id="main" class="site-main" role="main">

			<?php if ( function_exists('ffeeeedd__ariane') && !is_front_page() ) { ?>
				<div id="breadcrumb" class="site-breadcrumb">
					<?php ffeeeedd__ariane(); ?>
				</div>
			<?php } ?>			

			<?php
			/* Début de la boucle */
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/content', 'page' );

				/**
				 * Si les commentaires sont ouverts ou si on a au moins un commentaire,
				 * on charge le template des commentaires
				 */
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile;
			?>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
