jQuery(function ($) {
  $(document).ready(function () {
    // Par défaut le troisième niveau de menu est affiché
    // On le masque…
    $( ".children" ).hide();
    // …et on ajoute une classe .children-closed sur le lien qui permet de l'ouvrir pour ajouter une icône
    $( ".page_item_has_children > a" ).addClass( "children-closed" );
    
    // Lorsqu'on cliaue sur le lien…
    $( ".page_item_has_children > a" ).click(function( event ) {
      // …on empêche que le lien soit suivi…
      event.preventDefault();

      // …on supprime/ajoute la classe .children-closed…
      $(this).toggleClass( "children-closed" );

      // …et on affiche/masque le sous-menu
      $(this).next( ".children" ).toggle( "slow", function() {
        // Animation complete.
      });
    });
  });
})(jQuery);