/* http://www.informit.com/articles/article.aspx?p=2164575&seqNum=9 */
/* Fonctions pour écrire et récupérer les valeurs des cookies */
function setCookie(name, value, days) {
	var date = new Date();
	date.setTime(date.getTime()+(days*24*60*60*1000));
	var expires = "; expires="+date.toGMTString ();
	document.cookie = name + "=" + value + expires + "; path=/";
}

function getCookie(name) {
	var cArr = document.cookie.split(';');
	for(var i=0;i < cArr.length;i++) {
		var cookie = cArr[i].split("=",2);
		cookie[0] = cookie[0].replace(/^\s+/,"");
		if (cookie[0] == name){
			return cookie;
		}
	}
}

jQuery(function ($) {
	$(document).ready(function () {
		// On définit une variable en récupérant le cookie
		var cookieModale = getCookie('modale');

		// Si variable nulle
		if (cookieModale == null) {
			// On supprime le scroll de la page
			$('body').addClass('no-scroll');
			// On affiche la modale
			$('.modale-home').fadeIn(2000);
			// On donne le focus au bouton de fermeture
			$(this).find('.modale-close').triggerHandler('focus');

			// Et on écrit le cookie
			// Par défaut temps de la session
			// Pour donner une limite de 30 jours : setCookie('modale','modaleViewed',30);
			setCookie('modale','modaleViewed');
		} else {
			// Si variable non nulle on ne fait rien
		}

		// Fermeture de la modale…
		$(document)
		// …au clic dans la page…
		.click(function () {
			$('.modale-home').fadeOut(2000);
			$('body').removeClass('no-scroll');
		})
		// …ou avec la touche Echap
		.on( 'keydown', function(e) { 
			if (e.which == 27) { 
				$('.modale-home').hide();
				$('body').removeClass('no-scroll');
			}
		});
	});
})(jQuery);