<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Sara Hernandez
 * @author	Luc Poupard
 *
 * @package	Sante_Chablais
 * @since	Sante_Chablais 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/apple-touch-icon.png'; ?>">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-32x32.png'; ?>" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/favicon-16x16.png'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/favicons/manifest.json'; ?>">
<meta name="theme-color" content="#ffffff">
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

<div id="site-top" class="site-wrapper">
	<a href="#site-menu" class="screen-reader-text"><?php esc_html_e( 'Skip to navigation', 'cdiwp' ); ?></a>
	<a href="#site-content" class="screen-reader-text"><?php esc_html_e( 'Skip to content', 'cdiwp' ); ?></a>
	<a href="#site-search" class="screen-reader-text"><?php esc_html_e( 'Skip to search', 'cdiwp' ); ?></a>

	<header id="site-header" class="site-header" role="banner">
		<?php
		/* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
		if ( is_front_page() ) : ?>
			<h1 class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.svg'; ?>" width="232" height="63" alt="<?php bloginfo( 'name' ); ?>" /></a></h1>
		<?php
		/* …sinon on affiche un paragraphe */
		else : ?>
			<p class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.svg'; ?>" width="232" height="63" alt="<?php bloginfo( 'name' ); ?>" /></a></p>
		<?php
		endif;

		$description = get_bloginfo( 'description', 'display' );
		if ( $description || is_customize_preview() ) : ?>
			<p class="site-header_description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
		<?php
		endif; ?>

		<!-- <div class="srch clearfix">
			<form method="GET" action="<?php echo get_site_url(); ?>">
				<div class="container cbd"><input max-length="120" autocomplete="off" placeholder="Rechercher..." value="<?php the_search_query(); ?>" name="s" id="q"><button type="submit" title="Rechercher sur le site"><i class="fa fa-search"></i></button></div>
			</form>
		</div> -->

		<div id="site-search" class="site-search">
			<?php get_search_form() ?>
		</div>

		<div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
		<nav id="site-navigation" class="site-navigation" role="navigation">
			<?php wp_nav_menu( array(
				'theme_location' => 'primary',
				'menu_id' => 'primary-menu',
				'container' => false, // On ne crée pas de conteneur autour du menu
				'menu_class' => 'sf-menu' // On ajoute la class pour le menu superfish
			) ); ?>
		</nav><!-- #site-navigation -->
		<a href="#site-navigation"><span><?php esc_html_e( 'Menu', 'cdiwpchild' ); ?></span></a>
	</header><!-- #site-header -->

	<div id="site-content-wrapper" class="site-content-wrapper">
