<?php
/**
 * Santé Chablais : fonctions du thème.
 *
 * @link	https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles du thème
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
*/


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdiwp' )
	 */
	load_child_theme_textdomain( 'cdiwpchild', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
	// ) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On supprime le support des Images à la Une par défaut
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	// remove_theme_support( 'post-thumbnails' );

	/* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On supprime le support les adresses de flux dans <head>
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
// function remove_cdiwpchild_widgets() {
// 	unregister_sidebar( 'sidebar-1' );
// }
// add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */


/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		null,
		'all'
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* == @section Menu contextuel ==================== */
/**
 * @see http://www.wpbeginner.com/wp-tutorials/how-to-display-a-list-of-child-pages-for-a-parent-page-in-wordpress/
 */
function wpb_list_child_pages() {
	global $post; 

	if ( is_page() && $post->post_parent )
		$childpages = wp_list_pages( 'sort_column=menu_order&title_li=&child_of=' . $post->post_parent . '&echo=0' );
	else
		$childpages = wp_list_pages( 'sort_column=menu_order&title_li=&child_of=' . $post->ID . '&echo=0' );
	
	if ( $childpages ) {
		$string = '<ul>' . $childpages . '</ul>';
	}
	return $string;
}
add_shortcode( 'wpb_childpages', 'wpb_list_child_pages' );


/* == @section Sous-menu ==================== */
/**
  * @see https://premium.wpmudev.org/blog/adding-scripts-and-styles-wordpress-enqueueing/
  */
function chablais_scripts() {
	wp_enqueue_script(
		'chablais_sous_menu',
		get_stylesheet_directory_uri() . '/js/init.sous-menu.js',
		array( 'jquery' ), // Dépendant de jQuery
		null, // Version
		true // true = script dans le footer
	);

	wp_enqueue_script(
		'chablais_onglets',
		get_stylesheet_directory_uri() . '/js/van11y-accessible-tab-panel-aria.min.js',
		array(), // Dépendant de jQuery
		null, // Version
		true // true = script dans le footer
	);

	if( is_front_page() ) :
		wp_enqueue_script(
			'chablais_cookie_home',
			get_stylesheet_directory_uri() . '/js/home.cookie.js',
			array(), // Dépendant de jQuery
			null, // Version
			true // true = script dans le footer
		);
	endif;
}
add_action( 'wp_enqueue_scripts', 'chablais_scripts' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}