<?php
/**
 * Notification de mises à jour du thème
 *
 * @author  Luc Poupard
 *
 * Basé sur le code de Xpark Media :
 * @link    https://xparkmedia.com/blog/add-update-notification-selfhosted-premium-themes-plugins/
 * Mais on utilise wp_remote_get() au lieu de curl_init() :
 * @link    https://pippinsplugins.com/using-wp_remote_get-to-parse-json-from-remote-apis/
 *
 * @package ruffieux 3.0.0
 * @since   ruffieux 1.0.0
 */

function cdichild_update_notifier ( $transient ) {
    if( empty( $transient->checked['ruffieux'] ) )
    return $transient;

    $response = wp_remote_get( 'http://wp.cdi.ch/themes/ruffieux2024/update.json' );

    if( is_wp_error( $response ) ) {
        return false;
    }

    $result = wp_remote_retrieve_body( $response );
    $data = json_decode( $result );

    /* On vérifie la version sur le serveur par rapport à la version installée */
    if( ! empty( $data ) ) {
        if( version_compare( $transient->checked['ruffieux'], $data->new_version, '<' ) )
        $transient->response['ruffieux'] = (array) $data;
    }

    return $transient;
}
add_filter ( 'pre_set_site_transient_update_themes', 'cdichild_update_notifier' );
