<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package Ruffieux 3.0.8
 * @since   CDI_Base 2.0.0
 */
?>

    </div><!-- #site-content -->

    <footer id="site-footer" class="site-footer" role="contentinfo">
        <div class="site-footer_info">
            <div class="site-wrapper">
                <div class="footer-columns">
                    <div class="col col1">
                        <div class="footer-logos">
                            <img src="<?= get_stylesheet_directory_uri(); ?>/images/logo-ruffieux-blanc.svg" alt="<?= bloginfo( 'name' ); ?>" title="Logo <?= bloginfo( 'name' ); ?>" class="logo-footer logo-ruffieux-footer" />
                            <hr />
                            <img src="<?= get_stylesheet_directory_uri(); ?>/images/logo-fidubor-blanc.svg" alt="<?= bloginfo( 'name' ); ?>" title="Logo Fidubor" class="logo-footer logo-fidubor-footer" />
                            <hr />
                        </div>
                        <a href="https://ch.linkedin.com/company/fiduciaire-ruffieux-sa" target="_blank">
                            Suivez notre<br />
                            actualité sur<br />
                            <strong>LinkedIn</strong>
                        </a>
                    </div>
                    <div class="col col2" role="complementary">
                        <?php dynamic_sidebar( 'footer_col2' ); ?>
                    </div>
                    <div class="col col3" role="complementary">
                        <?php dynamic_sidebar( 'footer_col3' ); ?>
                    </div>
                    <div class="col col4" role="complementary">
                        <?php dynamic_sidebar( 'footer_col4' ); ?>
                    </div>
                </div>
            </div>
        </div><!-- .site-footer_info -->
        <div class="site-footer_copyright">
            Fiduciaire Ruffieux SA © <?= date( 'Y' ); ?> | Design par <a href="https://www.paradoxe.studio" target="_blank">Paradoxe Studio</a> | Développement par <a href="https://www2.cdi.ch" target="_blank">CDI SA</a>
        </div><!-- .site-footer_copyright -->
    </footer><!-- #site-footer -->
</div><!-- #site-top -->

<?php wp_footer(); ?>

<?php
// Check si la popup est activée
if ( get_field('popup-toggle', 'option') ) : ?>
    <div class="popup-container">
        
        <?php 
        $popupFrequency = get_field( 'popup-frequency', 'option');
        $popupReopen = get_field('popup-reopen', 'option');

        // Récupère la fréquence d'affichage de la popup
        if ( $popupFrequency ): 
            ?>
            <input type="hidden" 
                class="popup-frequency" 
                value="<?php echo esc_attr( $popupFrequency ); ?>">
            <?php 
        endif;

        if ( $popupReopen ):
            ?>
            <input type="hidden"
                class="popup-reopen"
                value="<?php echo esc_attr( $popupReopen ); ?>">
            <?php
        endif;

        if ( $popupReopen ):
            ?>
            <input type="hidden"
                class="popup-reopen-button-text"
                value="<?php echo esc_attr(the_field('popup-reopen-button-text', 'option')); ?>">
            <?php
        endif;
        ?>


        <div class="popup">
            <h3 class="popup-title">
                <?php the_field( 'popup-title', 'option'); // Affiche le titre de la popup ?>
            </h3>
            
            <div class="popup-content">
                <?php the_field( 'popup-content', 'option'); // Affiche le contenu textuel de la popup ?>
            </div>

            <?php
            // Check si le CTA doit être présent
            if (get_field('cta-label', 'option')) : ?>
                <a target="_blank" href="<?php the_field('cta-link', 'option'); // Affiche le label du CTA ?>">
                    <div class="button">
                        <?php the_field('cta-label', 'option'); // Affiche le label du CTA ?>
                    </div>
                </a>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

</body>
</html>
