<?php
/**
 * Fichier partiel pour afficher le header avec les triangles
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	Men_at_Work 1.0.0
 * @since	Men_at_Work 1.0.0
 */
?>

<div class="header-triangles">
	<div class="header-triangles__bg">
		<div class="header-triangles__bg_content">
			<div class="header-triangles__bg_triangle"></div>
		</div>
	</div>

	<div class="header-triangles__text">
		<div class="header-triangles__text_triangle"></div>

		<div class="header-triangles__text_content wrapper-content">
			<?php
				// Si c'est la page d'accueil
				if ( is_front_page() ) :
					if( 'intro_home' ): ?>

						<div class="header_home">
							<div class="header_texte_home">
								<?php
									$header_texte_home = apply_filters( 'the_content', get_post_meta( get_the_ID(), 'intro_home', true ) );
									echo $header_texte_home;
								?>
							</div><!-- .header_texte_home -->
						</div><!-- header_home -->

					<?php endif;
				// Si c'est la page des offres d'emploi (archive)
				elseif ( is_home() && ! is_front_page() ) : ?>

						<h1><?php single_post_title(); ?></h1>

					<?php 
				// Si c'est la page des offres d'emploi (archive)
				elseif ( is_post_type_archive( 'post_type_job' )) :
					if ( have_posts() ) : ?>

						<h1><?php esc_html_e( 'Offres d’emploi', 'cdi-base-child'  ); ?></h1>

					<?php endif;
				// Si c'est la page des candidats (archive)
				elseif ( is_post_type_archive( 'post_type_candidate' )) :
					if ( have_posts() ) : ?>

						<h1><?php esc_html_e( 'Candidats disponibles', 'cdi-base-child'  ); ?></h1>

					<?php endif;
				// Dans tous les autres cas
				else :
					while ( have_posts() ) : the_post(); ?>

						<h1><?php the_title(); ?></h1>

					<?php endwhile;
				endif;
			?>

			<?php
				// Boutons dans l'entête
				if ( ! is_front_page() ) : ?>

					<div class="header_buttons">

						<?php if ( ! is_page( 'metiers-gros-oeuvre' ) ) : ?>
							<a class="btn-metiers" href="/metiers-gros-oeuvre"><?php esc_html_e( 'Métiers gros oeuvre', 'cdi-base-child'  ); ?></a>
						<?php endif; ?>


						<a class="btn-inscription" href="/candidature"><?php esc_html_e( 'Inscription', 'cdi-base-child'  ); ?></a>
						
						<?php if ( ! is_page( 'contact' ) ) : ?>
							<a class="btn-contact" href="/contact"><?php esc_html_e( 'Contact', 'cdi-base-child'  ); ?></a>
						<?php endif; ?>

						
					</div>

				<?php endif;
			?>
		</div><!-- .header-triangles__text_content -->
	</div><!-- .header-triangles__text -->

	<?php if ( is_front_page() ) : ?>

		<div class="header-triangles__home wrapper-content">

			<div class="h2"><?php bloginfo( 'name' ); ?></div>

			<?php while ( have_posts() ) : the_post();

				the_content();

			endwhile; ?>
		</div>
	
	<?php endif; ?>
</div>