<?php
/**
 * Fichier partiel pour afficher le contenu des pages
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.0
 * @since   CDI_Base 2.0.4
 */
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="wrapper-content">
        <div class="man-columns">
            <?php if( have_rows('infos_home') ): ?>

                <div class="home-infos">

                    <?php while( have_rows('infos_home') ): the_row();
                        $home_icon          = get_sub_field('block_home_info_icon');
                        $home_title         = get_sub_field('block_home_info_titre');
                        $home_description   = get_sub_field('block_home_info_descriptif');
                        $home_link          = get_sub_field('block_home_info_lien');
                    ?>

                        <div class="home-infos_item">
                            <div class="home-infos_item-icon">
                                <img src="<?php echo $home_icon['url']; ?>" width="512" height="512" alt="" />
                            </div>

                            <div class="home-infos_item-text">
                                <div class="h3"><?php echo $home_title; ?></div>

                                <p><?php echo $home_description; ?></p>

                                <a href="<?php echo $home_link['url']; ?>" target="<?php echo $home_link['target']; ?>"><?php echo $home_link['title']; ?>
                                </a>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div><!-- .home-blocks -->

            <?php endif; ?>

            <div class="man-jobs">
                <h2><?php esc_html_e( 'Nous recherchons', 'cdi-base-child'  ); ?></h2>

                <?php
                    /* On récupère la liste des jobs */
                    $args_job = array(
                        'post_type' => 'post_type_job',
                        // 'nopaging' => true,
                        'posts_per_page'  => '5'
                    );
                    $loop_job = new WP_Query( $args_job );
                ?>

                <?php if ( $loop_job->have_posts() ) : ?>

                    <ul class="man-jobs_list">
                        <?php while ( $loop_job->have_posts() ) : $loop_job->the_post();
                        /* On récupère les données */
                            $job_date = get_field( 'job_date', false, false );
                            $job_date = new DateTime( $job_date );

                            $job_type = get_field( 'job_type' );

                            $job_location = get_field( 'job_location' );
                        ?>

                            <li>
                                <div>
                                    <h3 class="man-jobs_item-title"><?php the_title(); ?></h3>
                                    <span class="man-jobs_item-date"><?php echo $job_date->format('d.m.Y'); ?></span>
                                </div>

                                <div>
                                    <span class="man-jobs_item-type"><?php echo $job_type; ?></span>
                                    <span class="man-jobs_item-location"><?php echo $job_location; ?></span>
                                    <a href="<?php the_permalink() ?>"><?php esc_html_e( 'Voir l’offre', 'cdi-base-child'  ); ?></a>
                                </div>
                            </li>

                        <?php endwhile; wp_reset_postdata(); ?>
                    </ul>

                    <a href="/offres/"><?php esc_html_e( 'Voir toutes les offres', 'cdi-base-child'  ); ?></a>

                <?php else: ?>

                    <p><?php esc_html_e( 'Il n’y a actuellement aucune offre d’emploi disponible', 'cdi-base-child'  ); ?></p>

                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="actus clearfix">
        <div class="wrapper-content">
            <h2><?php esc_html_e( 'Actualités', 'cdi-base-child'  ); ?></h2>

            <?php
                $args_actu = array(
                    // 'nopaging' => true,
                    'ignore_sticky_posts' => true,
                    'posts_per_page' => '2'
                );
                $loop_actu = new WP_Query( $args_actu );

                if ( $loop_actu->have_posts() ):
            ?>

                <ul class="actus__content">
                    <?php while ( $loop_actu->have_posts() ) : $loop_actu->the_post(); ?>

                    <li>
                        <div class="datepost"><?php the_date("F Y"); ?></div>
                        <h3><?php the_title(); ?></h3>
                        <div><?php the_post_thumbnail(); ?></div>
                        <div><?php the_content(); ?></div>
                    </li>

                    <?php endwhile; wp_reset_postdata(); ?>
                </ul>

            <?php endif; ?>

            <a  href="/actualites/"><?php esc_html_e( 'Voir toutes les actualités', 'cdi-base-child'  ); ?></a>
        </div>

    </div><!-- .actus -->
</div><!-- #post-## -->
