<?php
/**
 * Fichier pour afficher le détail d'une offre d'emploi
 *
 * @link	https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @author	Luc Poupard
 *
 * @package	Men_at_Work 1.0.0
 * @since	Men_at_Work 1.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

			<div class="wrapper-content">
				<?php while ( have_posts() ) : the_post(); ?>

					<div class="man-job-detail">
						<div class="man-job-detail__description">
							<?php the_content(); ?>
						</div>

						<div class="man-job-detail__infos">
							<div>
								<dl>
									<?php
										// Get the custom fields
										$job_ref	= get_field( 'job_reference' );
										$job_rate	= get_field( 'job_activity' );
										$job_type	= get_field( 'job_type' );
										$job_loc	= get_field( 'job_location' );

										$job_date	= get_field( 'job_date', false, false );
										$job_date	= new DateTime( $job_date );

										$job_date_fr	= $job_date->format( 'd/m/Y' );
										$job_date_us	= $job_date->format( 'm/d/Y' );
										$today_date_fr	= date( 'd/m/Y' );
										$today_date_us	= date( 'm/d/Y' );

										$job_date_comp		= strtotime( $job_date_us );
										$today_date_comp	= strtotime( $today_date_us );
									?>

									<?php if( $job_ref ): ?>
										<dt><?php esc_html_e( 'Référence', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $job_ref; ?></dd>
									<?php endif; ?>

									<?php if( $job_rate ):	?>
										<dt><?php esc_html_e( 'Taux d’activité', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $job_rate; ?></dd>
									<?php endif; ?>

									<?php if( $job_type ):	?>
										<dt><?php esc_html_e( 'Type de poste', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $job_type; ?></dd>
									<?php endif; ?>

									<?php if( $job_date ): ?>
										<dt><?php esc_html_e( 'Date de début', 'cdi-base-child'  ); ?></dt>
										<?php if( $job_date_comp <= $today_date_comp ): ?>
											<dd><?php esc_html_e( 'Dès que possible', 'cdi-base-child'  ); ?></dd>
										<?php else: ?>
											<dd><?php echo $job_date_fr; ?></dd>
										<?php endif;
									endif; ?>

									<?php if( $job_loc ):	?>
										<dt><?php esc_html_e( 'Localisation', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $job_loc; ?></dd>
									<?php endif; ?>
								</dl>
							</div>
						</div>
					</div>

				<?php endwhile;	?>

				<!-- <div class="h2"><?php esc_html_e( 'Postuler à l’offre', 'cdi-base-child'  ); ?> <?php the_title(); ?></div> -->

				<h2 class="js-expandmore" data-hideshow-prefix-class="animated"><?php esc_html_e( 'Postuler à l’offre', 'cdi-base-child'  ); ?></h2>
				<div class="js-to_expand">
					<?php gravity_form( 3, false, false, false, '', true ); ?>
				</div>
			</div>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
 