<?php
/**
 * Fichier pour afficher le détail d'un candidat
 *
 * @link	https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @author	Luc Poupard
 *
 * @package	Men_at_Work 1.0.0
 * @since	Men_at_Work 1.0.0
 */
get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

			<div class="wrapper-content">
				<?php while ( have_posts() ) : the_post(); ?>

					<div class="man-job-detail">
						<div class="man-job-detail__description">
							<?php the_content(); ?>
						</div>

						<div class="man-job-detail__infos">
							<div>
								<dl>
									<?php
										// Get the custom fields
										$candidate_expert	= get_field( 'candidate_expertise' );
										$candidate_region	= get_field( 'candidate_region' );

										$candidate_date	= get_field( 'candidate_availability', false, false );
										$candidate_date	= new DateTime( $candidate_date );

										$candidate_date_fr	= $candidate_date->format( 'd/m/Y' );
										$candidate_date_us	= $candidate_date->format( 'm/d/Y' );
										$today_date_fr		= date( 'd/m/Y' );
										$today_date_us		= date( 'm/d/Y' );

										$candidate_date_comp	= strtotime( $candidate_date_us );
										$today_date_comp		= strtotime( $today_date_us );
									?>

									<?php if( $candidate_expert ): ?>
										<dt><?php esc_html_e( 'Expertise', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $candidate_expert ?></dd>
									<?php endif; ?>

									<?php if( $candidate_date ): ?>
										<dt><?php esc_html_e( 'Disponibilité', 'cdi-base-child'  ); ?></dt>
										<?php if( $candidate_date_comp <= $today_date_comp ): ?>
											<dd><?php esc_html_e( 'Immédiate', 'cdi-base-child'  ); ?></dd>
										<?php else: ?>
											<dd><?php echo $candidate_date_fr; ?></dd>
										<?php endif;
									endif; ?>

									<?php if( $candidate_region ):	?>
										<dt><?php esc_html_e( 'Région', 'cdi-base-child'  ); ?></dt>
										<dd><?php echo $candidate_region; ?></dd>
									<?php endif; ?>
								</dl>
							</div>
						</div>
					</div>

				<?php endwhile; ?>
			</div>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
