<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link	https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-113236879-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-113236879-1');
</script>

<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<?php gravity_form_enqueue_scripts( 3, true ); ?>
<?php wp_head(); ?>
<?php if ( is_post_type_archive( 'post_type_candidate' ) || is_singular( 'post_type_candidate' ) ) : ?>
<meta name="robots" content="noindex, nofollow">
<?php endif; ?>
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri() . '/img/apple-touch-icon.png'; ?>">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicon-32x32.png'; ?>" sizes="32x32">
<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri() . '/img/favicon-16x16.png'; ?>" sizes="16x16">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri() . '/img/manifest.json'; ?>">
<meta name="theme-color" content="#000000">
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

<div id="site-top" class="site-wrapper">
	<a href="#site-menu" class="screen-reader-text"><span><?php esc_html_e( 'Skip to navigation', 'cdi-base' ); ?></span></a>
	<a href="#site-content" class="screen-reader-text"><span><?php esc_html_e( 'Skip to content', 'cdi-base' ); ?></span></a>
	<a href="#site-search" class="screen-reader-text"><span><?php esc_html_e( 'Skip to search', 'cdi-base' ); ?></span></a>

	<header id="site-header" class="site-header" role="banner">
		<?php
		/* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
		if ( is_front_page() ) : ?>
			<h1 class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.png'; ?>" class="logo" width="400" height="177" alt="<?php bloginfo( 'name' ); ?>" /></a></h1>
		<?php
		/* …sinon on affiche un paragraphe */
		else : ?>
			<p class="site-header_title h1"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri() . '/img/logo.png'; ?>" class="logo" width="400" height="177" alt="<?php bloginfo( 'name' ); ?>" /></a></p>
		<?php
		endif;

		$description = get_bloginfo( 'description', 'display' );
		if ( $description || is_customize_preview() ) : ?>
			<p class="site-header_description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
		<?php
		endif; ?>

		<a href="#mm-site-navigation"><span><?php esc_html_e( 'Menu', 'cdi-base-child' ); ?></span></a>
		
		<div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
		<nav id="site-navigation" class="site-navigation" role="navigation">
		<?php wp_nav_menu( array(
			'theme_location' => 'primary',
			'menu_id' => 'primary-menu',
			'container' => false
		) ); ?>
	</nav><!-- #site-navigation -->
	</header><!-- #site-header -->
		
	<?php get_template_part( 'template-parts/header', 'triangles' ); ?>

	<div id="site-content-wrapper" class="site-content-wrapper">