<?php
/**
 * Création des types de contenus personnalisés
 *
 * Générateur : https://generatewp.com/post-type/
 *
 * @author	Luc Poupard
 *
 * @package	Men at Work 1.0.0
 * @since	Men at Work 1.0.0
 */

function custom_post_type() {
	/* Candidates */
	$candidate_labels = array(
		'name'                  => _x( 'Candidates', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Candidate', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Candidates', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Candidate', 'cdi-base-child' ),
		'archives'              => __( 'Candidate Archives', 'cdi-base-child' ),
		'attributes'            => __( 'Candidate Attributes', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Candidate Item:', 'cdi-base-child' ),
		'all_items'             => __( 'All Candidates', 'cdi-base-child' ),
		'add_new_item'          => __( 'Add New Candidate', 'cdi-base-child' ),
		'add_new'               => __( 'Add New', 'cdi-base-child' ),
		'new_item'              => __( 'New Candidate', 'cdi-base-child' ),
		'edit_item'             => __( 'Edit Candidate', 'cdi-base-child' ),
		'update_item'           => __( 'Update Candidate', 'cdi-base-child' ),
		'view_item'             => __( 'View Candidate', 'cdi-base-child' ),
		'view_items'            => __( 'View Candidates', 'cdi-base-child' ),
		'search_items'          => __( 'Search Candidate', 'cdi-base-child' ),
		'not_found'             => __( 'Not found', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'cdi-base-child' ),
		'featured_image'        => __( 'Featured Image', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Set featured image', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Remove featured image', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Use as featured image', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Insert into candidate', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Uploaded to this candidate', 'cdi-base-child' ),
		'items_list'            => __( 'Candidates list', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Candidates list navigation', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter candidates list', 'cdi-base-child' ),
	);
	$candidate_rewrite = array(
		'slug'                  => 'candidats',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$candidate_args = array(
		'label'                 => __( 'Candidate', 'cdi-base-child' ),
		'description'           => __( 'Post type for candidates content', 'cdi-base-child' ),
		'labels'                => $candidate_labels,
		'supports'              => array( 'title', 'editor', 'revisions', 'custom-fields', 'page-attributes', ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-groups',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => false,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $candidate_rewrite,
		'capability_type'       => 'page',
	);
	register_post_type( 'post_type_candidate', $candidate_args );


	$job_labels = array(
		'name'                  => _x( 'Jobs', 'Post Type General Name', 'cdi-base-child' ),
		'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'cdi-base-child' ),
		'menu_name'             => __( 'Jobs', 'cdi-base-child' ),
		'name_admin_bar'        => __( 'Job', 'cdi-base-child' ),
		'archives'              => __( 'Job Archives', 'cdi-base-child' ),
		'attributes'            => __( 'Job Attributes', 'cdi-base-child' ),
		'parent_item_colon'     => __( 'Job Item:', 'cdi-base-child' ),
		'all_items'             => __( 'All Jobs', 'cdi-base-child' ),
		'add_new_item'          => __( 'Add New Job', 'cdi-base-child' ),
		'add_new'               => __( 'Add New', 'cdi-base-child' ),
		'new_item'              => __( 'New Job', 'cdi-base-child' ),
		'edit_item'             => __( 'Edit Job', 'cdi-base-child' ),
		'update_item'           => __( 'Update Job', 'cdi-base-child' ),
		'view_item'             => __( 'View Job', 'cdi-base-child' ),
		'view_items'            => __( 'View Jobs', 'cdi-base-child' ),
		'search_items'          => __( 'Search Job', 'cdi-base-child' ),
		'not_found'             => __( 'Not found', 'cdi-base-child' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'cdi-base-child' ),
		'featured_image'        => __( 'Featured Image', 'cdi-base-child' ),
		'set_featured_image'    => __( 'Set featured image', 'cdi-base-child' ),
		'remove_featured_image' => __( 'Remove featured image', 'cdi-base-child' ),
		'use_featured_image'    => __( 'Use as featured image', 'cdi-base-child' ),
		'insert_into_item'      => __( 'Insert into job', 'cdi-base-child' ),
		'uploaded_to_this_item' => __( 'Uploaded to this job', 'cdi-base-child' ),
		'items_list'            => __( 'Jobs list', 'cdi-base-child' ),
		'items_list_navigation' => __( 'Jobs list navigation', 'cdi-base-child' ),
		'filter_items_list'     => __( 'Filter jobs list', 'cdi-base-child' ),
	);
	$job_rewrite = array(
		'slug'                  => 'offres',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	$job_args = array(
		'label'                 => __( 'Job', 'cdi-base-child' ),
		'description'           => __( 'Post type for jobs content', 'cdi-base-child' ),
		'labels'                => $job_labels,
		'supports'              => array( 'title', 'editor', 'revisions', 'custom-fields', 'page-attributes', ),
		// 'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-megaphone',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => false,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $job_rewrite,
		'capability_type'       => 'page',
	);
	register_post_type( 'post_type_job', $job_args );

}
add_action( 'init', 'custom_post_type', 0 );