<?php
/**
 * CDI Base Child : fonctions du thème.
 *
 * @link    https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base_Child 2.1.0
 * @since   CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Fonctions WordPress
        -- Traductions
        -- Menus de navigation
        -- Images à la Une
        -- Flux RSS
    == Widgets
    == Ajout des styles du thème
    == Fonctions externalisées
        -- Global
        -- Front
        -- Administration
*/


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
    /* -- @subsection Traductions -------------------- */
    /**
     * Préparer le thème pour traduction.
     * Les traductions sont placées dans le répertoire /languages/
     * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
     */
    load_child_theme_textdomain( 'cdi-base-child', get_stylesheet_directory() . '/languages' );


    /* -- @subsection Menus de navigation -------------------- */
    /**
     * Déclaration du menu de navigation principal.
     */
    // register_nav_menus( array(
    //  'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
    // ) );


    /* -- @subsection Images à la Une -------------------- */
    /**
     * On supprime le support des Images à la Une par défaut
     * Pour conserver le support, commenter la ligne suivante.
     */
    remove_theme_support( 'post-thumbnails' );

    /* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
    // set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


    /* -- @subsection Flux RSS -------------------- */
    /**
     * On supprime le support les adresses de flux dans <head>
     * Pour conserver le support, commenter la ligne suivante.
     */
    remove_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
// function remove_cdiwpchild_widgets() {
//  unregister_sidebar( 'sidebar-1' );
// }
// add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

// function themename_widgets_init() {
//     register_sidebar( array(
//         'name'          => __( 'Footer', 'cdi-base-child' ),
//         'id'            => 'pied_de_page',
//         'before_widget' => '<aside id="%1$s" class="widget %2$s">',
//         'after_widget'  => '</aside>',
//         'before_title'  => '<h1 class="widget-title">',
//         'after_title'   => '</h1>',
//     ) );
// }
// add_action( 'widgets_init', 'themename_widgets_init' );


/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
    wp_register_style(
        'all',
        get_stylesheet_directory_uri() . '/css/styles.css',
        false,
        '20190502',
        'all'
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );

    if ( is_singular( 'post_type_job' ) ) {
        wp_register_script(
            'job_hideshow',
            get_stylesheet_directory_uri() . '/js/van11y-accessible-hide-show-aria.min.js',
            false,
            null,
            true
        );

        wp_enqueue_script( 'job_hideshow' );
    }
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


// /* On désactive Superfish */
// function menatwork_dequeue_script() {
//  wp_deregister_script( 'superfish' );
// }
// add_action( 'wp_print_scripts', 'menatwork_dequeue_script', 100 );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';

/* Création des types de contenus personnalisés */
require get_stylesheet_directory() . '/functions/front_custom-post-types.php';

/* Modification du texte (suite)
 * https://codex.wordpress.org/Customizing_the_Read_More
 */
function modify_read_more_link() {
    return '<div><a class="more-link" href="' . get_permalink() . '#more-' . get_the_ID() . '"><span aria-label="' . __( 'Lire la suite de ', 'cdi-base-child' ) . get_the_title() . '">' . __( 'Lire la suite', 'cdi-base-child' ) . '</span></a></div>';
}
add_filter( 'the_content_more_link', 'modify_read_more_link' );


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
    /* Notification de mises à jour du thème */
    require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

    /* Ajouter des droits à des utilisateurs */
    // require get_stylesheet_directory() . '/functions/admin_capabilities.php';

    /* Cacher des items du menu aux non administrateurs */
    // require get_stylesheet_directory() . '/functions/admin_menu.php';

    /* Cacher les widgets du dashboard */
    // require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}
