<?php
/**
 * Template Name: Equipe
 *
 * Fichier pour afficher les pages
 *
 * @author	Luc Poupard
 *
 * @note	Inspiré d'un tutoriel :
 * @author	Rémi Corson
 * @link	http://www.remicorson.com/create-a-simple-wordpress-sitemap/
 *
 * @package	CDI_Base 2.1.1
 * @since	CDI_Base 2.0.0
 */
get_header(); ?>
	
	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">
			<?php
			/* Début de la boucle */
			while ( have_posts() ) : the_post(); ?>
				<div class="wrapper-content">
					<?php the_content();?>
					<h2><?php esc_html_e( 'L’équipe Men at Work', 'cdi-base-child'  ); ?></h2>	
					
					<div class="equipe">

						<?php if( have_rows('equipe') ): ?>

							<div class="list-equipe">
							    <?php while( have_rows('equipe') ): the_row(); 
								    $equipe_repeteur_photo		= get_sub_field('equipe_repeteur_photo');
									$equipe_repeteur_nom_prenom	= get_sub_field('equipe_repeteur_nom_prenom');
									$equipe_repeteur_fonction	= get_sub_field('equipe_repeteur_fonction');
									$equipe_repeteur_num_de_tel	= get_sub_field('equipe_repeteur_num_de_tel');									
									$equipe_repeteur_mail		= get_sub_field('equipe_repeteur_mail');
							    ?>

							        <div class="infos_equipe">
								        <div class="photo_equipe">
									        <img src="<?php echo $equipe_repeteur_photo['url']; ?>" alt="" />
								        </div>

							            <div class="infos">
							            	<h3><?php echo $equipe_repeteur_nom_prenom; ?></h3>
								            <h4><?php echo $equipe_repeteur_fonction; ?></h4>						
								            <p><?php echo $equipe_repeteur_num_de_tel; ?></p>
								            <a href="mailto:<?php echo $equipe_repeteur_mail; ?>?body=<?php echo $body; ?>"><?php echo $equipe_repeteur_mail; ?>
								            </a>

								            
							            </div>
							        </div>

							    <?php endwhile; ?>
							</div>

						<?php endif; ?>
					</div>
				</div><!-- .entry-content -->
				
			<?php endwhile;	?>
		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
