<?php
/**
 * The template for displaying Jobs pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link 	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	Men_at_Work 1.0.0
 * @since	Men_at_Work 1.0.0
 */

get_header(); ?>

	<div id="site-content" class="site-content">
		<main id="main" class="site-main" role="main">

			<div class="wrapper-content">
				<div class="man-columns">
					<div class="man-jobs">
						<h2><?php esc_html_e( 'Nous recherchons', 'cdi-base-child'  ); ?></h2>

						<?php
							/* On récupère la liste des jobs */
							$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
							$args = array(
								'post_type' => 'post_type_job',
								'nopaging' => false,
								'posts_per_page'  => '10',
								'paged' => $paged
							);
							$loop = new WP_Query( $args );
						?>

						<?php if ( $loop->have_posts() ) : ?>
							
							<?php while ( $loop->have_posts() ) : $loop->the_post();
							/* On récupère les données */
								$job_date = get_field( 'job_date', false, false );
								$job_date = new DateTime( $job_date );

								$job_type = get_field( 'job_type' );

								$job_location = get_field( 'job_location' );
							?>

								<ul class="man-jobs_list">
									<li>
										<div>
											<h3 class="man-jobs_item-title"><?php the_title(); ?></h3>
											<span class="man-jobs_item-date"><?php echo $job_date->format('d.m.Y'); ?></span>
										</div>

										<div>
											<span class="man-jobs_item-type"><?php echo $job_type; ?></span>
											<span class="man-jobs_item-location"><?php echo $job_location; ?></span>
											<a href="<?php the_permalink() ?>"><?php esc_html_e( 'Voir l’offre', 'cdi-base-child'  ); ?></a>
										</div>
									</li>
								</ul>

							<?php endwhile; ?>

							<div class="pagination clearfix" style="margin-top: .5em;">
								<?php
									//https://codex.wordpress.org/Function_Reference/paginate_links#Example_With_a_Custom_Query
									$big = 999999999; // need an unlikely integer

									echo paginate_links( array(
										'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
										'format' => '?page/%#%',
										'current' => max( 1, get_query_var('paged') ),
										'total' => $loop->max_num_pages
									) );
								?>
							</div>

						<?php else: ?>

							<p><?php esc_html_e( 'Il n’y a actuellement aucune offre d’emploi disponible', 'cdi-base-child'  ); ?></p>

						<?php endif; ?>
					</div>

					<div>
						<div class="candidates-access">
							<h2><?php esc_html_e( 'Nos candidats disponibles', 'cdi-base-child'  ); ?></h2>
							<p><?php esc_html_e( 'Pour accéder à la liste des candidats disponibles, veuillez rentrer votre mot de passe&nbsp;:', 'cdi-base-child'  ); ?></p>
							<a href="/acces-candidats/"><?php esc_html_e( 'Connexion', 'cdi-base-child'  ); ?></a>
						</div>
					</div>
				</div>
			</div>

		</main><!-- #main -->
	</div><!-- #site-content -->

<?php
get_sidebar();
get_footer();