<?php
    global $avia_config;

	$lightbox_option = avia_get_option( 'lightbox_active' );
	$avia_config['use_standard_lightbox'] = empty( $lightbox_option ) || ( 'lightbox_active' == $lightbox_option ) ? 'lightbox_active' : 'disabled';
	/**
	 * Allow to overwrite the option setting for using the standard lightbox
	 * Make sure to return 'disabled' to deactivate the standard lightbox - all checks are done against this string
	 *
	 * @added_by Günter
	 * @since 4.2.6
	 * @param string $use_standard_lightbox				'lightbox_active' | 'disabled'
	 * @return string									'lightbox_active' | 'disabled'
	 */
	$avia_config['use_standard_lightbox'] = apply_filters( 'avf_use_standard_lightbox', $avia_config['use_standard_lightbox'] );

    $style          = $avia_config['box_class'];
    $responsive     = avia_get_option('responsive_active') != "disabled" ? "responsive" : "fixed_layout";
    $blank          = isset($avia_config['template']) ? $avia_config['template'] : "";
    $av_lightbox    = $avia_config['use_standard_lightbox'] != "disabled" ? 'av-default-lightbox' : 'av-custom-lightbox';
	$preloader      = avia_get_option('preloader') == "preloader" ? 'av-preloader-active av-preloader-enabled' : 'av-preloader-disabled';
    $sidebar_styling 		= avia_get_option('sidebar_styling');
	$filterable_classes 	= avia_header_class_filter( avia_header_class_string() );
	$av_classes_manually	= "av-no-preview"; /*required for live previews*/

    // Import helper main menu
    $headerS        = avia_header_setting();
    $social_args    = array('outside'=>'ul', 'inside'=>'li', 'append' => '');
    $icons          = !empty($headerS['header_social']) ? avia_social_media_icons($social_args, false) : "";

    if(isset($headerS['disabled'])) return;
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="<?php echo " html_{$style} ".$responsive." ".$preloader." ".$av_lightbox." ".avia_header_class_string();?> ">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php if( function_exists( 'avia_set_title_tag' ) ) { echo avia_set_title_tag(); } ?></title>
<!-- page title, displayed in your browser bar -->
<?php
    /*
     * outputs a rel=follow or nofollow tag to circumvent google duplicate content for archives
     * located in framework/php/function-set-avia-frontend.php
     */
     if (function_exists('avia_set_follow')) { echo avia_set_follow(); }

     /*
     * outputs a favicon if defined
     */
     if (function_exists('avia_favicon'))    { echo avia_favicon(avia_get_option('favicon')); }
?>
<!-- added by ell- cdi -->
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_directory'); ?>/css/print.css" media="print" />
<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Walter+Turncoat">
<!-- mobile setting -->
<?php
if( strpos($responsive, 'responsive') !== false ) echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">';
?>

<?php
    /* Always have wp_head() just before the closing </head>
     * tag of your theme, or you will break many plugins, which
     * generally use this hook to add elements to <head> such
     * as styles, scripts, and meta tags.
     */
    wp_head();
?>
</head>

<body id="top" <?php body_class($style." ".$avia_config['font_stack']." ".$blank); avia_markup_helper(array('context' => 'body')); ?>>
    <?php
        if("av-preloader-active av-preloader-enabled" === $preloader) {
            echo avia_preload_screen();
        }
    ?>

    <div id="wrap_all" class="gruyere">

    <?php if(!$blank) { ?>

        <header id="header" class="header_color <?php avia_is_dark_bg('header_color'); echo ' '.$headerS['header_class']; ?>" <?php avia_markup_helper(array('context' => 'header','post_type'=>'forum'));?>>

        <?php
        if($responsive) {
            echo '<a id="advanced_menu_toggle" href="#" '.av_icon_string('mobile_menu').'></a>';
            echo '<a id="advanced_menu_hide" href="#"   '.av_icon_string('close').'></a>';
        }

        //subheader, only display when the user chooses a social header
        if($headerS['header_topbar'] == true) {
        ?>
            <div id="header_meta" class="container_wrap container_wrap_meta <?php echo avia_header_class_string(array('header_social', 'header_secondary_menu', 'header_phone_active'), 'av_'); ?>">

                <div class="container">
                <?php
                    /*
                    *   display the themes social media icons, defined in the wordpress backend
                    *   the avia_social_media_icons function is located in includes/helper-social-media-php
                    */
                    $nav = "";

                    //display icons
                    // On cache l'appel des icônes sociales
                    //if(strpos( $headerS['header_social'], 'extra_header_active') !== false) echo $icons;
                    // FIN On cache l'appel des icônes sociales

                    //display navigation
                    if(strpos( $headerS['header_secondary_menu'], 'extra_header_active') !== false ) {
                        //display the small submenu
                        $avia_theme_location = 'avia2';
                        $avia_menu_class = $avia_theme_location . '-menu';
                        $args = array(
                            'theme_location'=>$avia_theme_location,
                            'menu_id' =>$avia_menu_class,
                            'container_class' =>$avia_menu_class,
                            'fallback_cb' => '',
                            'container'=>'',
                            'echo' =>false
                        );

                        $nav = wp_nav_menu($args);
                    }

                    if(!empty($nav) || apply_filters('avf_execute_avia_meta_header', false)) {
                        echo "<nav class='sub_menu' ".avia_markup_helper(array('context' => 'nav', 'echo' => false)).">";
                        echo $nav;
                        do_action('avia_meta_header'); // Hook that can be used for plugins and theme extensions (currently: the wpml language selector)
                        echo '</nav>';
                    }

                    //phone/info text
                    $phone          = $headerS['header_phone_active'] != "" ? $headerS['phone'] : "";
                    $phone_class    = !empty($nav) ? "with_nav" : "";
                    if($phone)      { echo "<div class='phone-info {$phone_class}'><span>".do_shortcode($phone)."</span></div>"; }
                ?>
                </div>
            </div>

        <?php } ?>

            <div  id="header_main" class="container_wrap container_wrap_logo">
            <?php
                /*
                * Hook that can be used for plugins and theme extensions (currently:  the woocommerce shopping cart)
                */
                do_action('ava_main_header');
                if($headerS['header_position'] != "header_top") do_action('ava_main_header_sidebar');
            ?>
                     <div class="container">
                        <!--
                        On cache inner-content
                        <div class="inner-container">
                        -->
                            <?php
                            /*
                            *   display the theme logo by checking if the default logo was overwritten in the backend.
                            *   the function is located at framework/php/function-set-avia-frontend-functions.php in case you need to edit the output
                            */

                            // Affichage logo Maison du Gruyere par langue
                            
                            $addition = false;
                            if( !empty($headerS['header_transparency']) && !empty($headerS['header_replacement_logo']) ) {
                                $addition = "<img src='".$headerS['header_replacement_logo']."' class='alternate' alt='' />";
                            }
                            /*
                            echo avia_logo(AVIA_BASE_URL.'images/layout/logo.png', $addition, 'strong', true);
                            */
                            // Utilisation de Polylang pour différencier les langues
                            if ( pll_current_language() === "de" ) {
                                echo avia_logo( get_bloginfo( 'stylesheet_directory' ) . '/images/maison-gruyere-schaukaserei.png', $addition, 'span', "height='192' width='208'" );
                            } else if ( pll_current_language() === "en" ){
                                echo avia_logo( get_bloginfo( 'stylesheet_directory' ) . '/images/maison-gruyere-demonstration-cheese-dairy.png', $addition, 'span', "height='192' width='208'" );
                            } else {
                                echo avia_logo( get_bloginfo( 'stylesheet_directory' ) . '/images/maison-gruyere-fromagerie-demonstration.png', $addition, 'span', "height='192' width='208'" );
                            }

                            // FIN Affichage logo Maison du Gruyere par langue

                            /* On affiche la description en h1 si on est sur page d'accueil */
                            $description = get_bloginfo( 'description', 'display' );

                            if ( $description || is_customize_preview() ) :
                                if ( is_front_page() ) : ?>
                                    <h1 class="visually-hidden"><?php echo $description; /* WPCS: xss ok. */ ?></h1>
                                <?php
                                endif;
                            endif;

                            if(!empty($headerS['bottom_menu'])) do_action('ava_before_bottom_main_menu');
                            if($headerS['header_social'] == 'icon_active_main' && !empty($headerS['bottom_menu'])) echo $icons;

                            /*
                            *   display the main navigation menu
                            *   modify the output in your wordpress admin backend at appearance->menus
                            */
                                $extraOpen = $extraClose = $icon_beside = "";
                                if($headerS['header_social'] == 'icon_active_main' && empty($headerS['bottom_menu'])){$icon_beside = " av_menu_icon_beside"; }
                                if($headerS['bottom_menu']){ $extraClose = "</div></div><div id='header_main_alternate' class='container_wrap'><div class='container'>";  }

                                echo $extraClose;

                                // Ajout logo Gruyere AOP
                                echo '<a href="http://www.gruyere.com" target="_blank" class="tablet desktop"><img src="' . get_bloginfo( 'stylesheet_directory' ) . '/images/logoGruyereAOP.jpg" style="float:right; margin-top:20px;" alt="Le Gruyère AOP" /></a><br />';
                                // FIN ajout logo Gruyere AOP

                                echo "<nav class='main_menu' data-selectname='".__('Select a page','avia_framework')."' ".avia_markup_helper(array('context' => 'nav', 'echo' => false)).">";
                                    $avia_theme_location = 'avia';
                                    $avia_menu_class = $avia_theme_location . '-menu';
                                    $args = array(
                                        'theme_location'    => $avia_theme_location,
                                        'menu_id'           => $avia_menu_class,
                                        'menu_class'        => 'menu av-main-nav',
                                        'container_class'   => $avia_menu_class.' av-main-nav-wrap'.$icon_beside,
                                        'fallback_cb'       => 'avia_fallback_menu',
                                        'walker'            => new avia_responsive_mega_menu()
                                    );

                                    wp_nav_menu($args);

                                /*
                                * Hook that can be used for plugins and theme extensions
                                */
                                do_action('ava_inside_main_menu');

                                if($icon_beside) echo $icons;

                                echo '</nav>';

                                /*
                                * Hook that can be used for plugins and theme extensions
                                */
                                do_action('ava_after_main_menu');
                            ?>

                        <!--</div> end inner-container-->
                    </div><!-- end container-->
                </div><!-- end container_wrap-->

            <div class="header_bg"></div>
        <!-- end header -->
        </header>

    <?php } // if(!blank) ?>

    <div id="main" data-scroll-offset="<?php echo avia_header_setting( 'header_scroll_offset' ); ?>">

    <?php do_action( 'ava_after_main_container' ); ?>
