<?php
/**
 * Fonction pour cacher des items du menu aux non-administrateurs
 *
 * @author 	Luc Poupard
 *
 * @link 	http://codex.wordpress.org/Function_Reference/remove_menu_page 
 *			http://codex.wordpress.org/Function_Reference/remove_submenu_page
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Tous les utilisateurs
		-- Menu
		-- Sous-menu
		-- Extensions
	== Tous les utilisateurs sauf admin
		-- Menu
		-- Sous-menu
		-- Extensions
	== Tous les admins sauf admins CDI
		-- Menu
		-- Sous-menu
		-- Extensions
	== Tous les utilisateurs sauf admin et M.Chassot
	== Page Personnaliser
 */


/**
 * On peut masquer chaque item du menu indépendamment.
 * Il suffit de commenter ou décommenter la ligne correspondante.
 */
function cdiwp_delete_menu_items() {
	/* == @section Tous les utilisateurs ==================== */
	/* -- @subsection Menu -------------------- */
	/* @note Syntaxe : remove_menu_page( $menu_slug ) */

	/* Dashboard */
	// remove_menu_page( 'index.php' );

	/* Posts */
	// remove_menu_page( 'edit.php' );

	/* Media */
	// remove_menu_page( 'upload.php' );

	/* Links */
	// remove_menu_page( 'link-manager.php' );

	/* Pages */
	// remove_menu_page( 'edit.php?post_type=page' );

    /* Custom Post Types */
    // remove_menu_page( 'edit.php?post_type=slug-cpt' );
    // remove_menu_page( 'edit.php?post_type=portfolio' );
    // remove_menu_page( 'admin.php?page=avia' );
    // remove_menu_page( 'avia' );

	/* Comments */
	// remove_menu_page( 'edit-comments.php' );

	/* Appearance */
	// remove_menu_page( 'themes.php' );

	/* Plugins */
	// remove_menu_page( 'plugins.php' );

	/* Users */
	// remove_menu_page( 'users.php' );

	/* Tools */
	// remove_menu_page( 'tools.php' );

	/* Settings */
	// remove_menu_page( 'options-general.php' );


	/* -- @subsection Sous-menu -------------------- */
	/* @note Syntaxe : remove_submenu_page( $menu_slug, $submenu_slug ) */

	/* Edit > Tags */
	// remove_submenu_page( 'edit.php', 'edit-tags.php?taxonomy=post_tag' );
	

	/* -- @subsection Extensions -------------------- */
	/* @note Se référer à la documentation des extensions si disponible */

	/* Contact Form 7 */
	// remove_menu_page( 'wpcf7' );

    /* Ninja Forms 3 */    
    // remove_menu_page( 'ninja-forms' );

	/* MainWP */
	// remove_menu_page( 'mainwp_child_tab' );

	/* All in One WP Security */
	// remove_menu_page( 'aiowpsec' );

	/* ACF */
	// remove_menu_page( 'edit.php?post_type=acf-field-group' );

	/* ACF - Options */
	// remove_menu_page( 'acf-options' );

	/* Event Espresso */
	// remove_menu_page( 'event_espresso' );

	/* Meta Slider */
	// remove_menu_page( 'metaslider' );


	/* == @section Tous les utilisateurs sauf admin ==================== */
	/**
	 * Si des utilisateurs autres que les admins CDI ont aussi les droits d'admin,
	 * se reporter à la section 'Tous les admins sauf admins CDI' juste en-dessous.
	 */
	if( ! current_user_can( 'add_users' ) ) {
		/* Dashboard */
		remove_menu_page( 'index.php' );

		/* Links */
		remove_menu_page( 'link-manager.php' );

		/* Custom Post Types */
		// remove_menu_page( 'edit.php?post_type=slug-cpt' );
		remove_menu_page( 'edit.php?post_type=portfolio' );
		// remove_menu_page( 'admin.php?page=avia' );
		remove_menu_page( 'avia' );

		/* Comments */
		remove_menu_page( 'edit-comments.php' );

		/* Appearance */
		remove_menu_page( 'themes.php' );

		/* Plugins */
		remove_menu_page( 'plugins.php' );

		/* Users */
		remove_menu_page( 'users.php' );

		/* Tools */
		remove_menu_page( 'tools.php' );

		/* Settings */
		remove_menu_page( 'options-general.php' );


		/* -- @subsection Extensions -------------------- */
		/* @note Se référer à la documentation des extensions si disponible */

		/* Contact Form 7 */
		// remove_menu_page( 'wpcf7' );

		/* MainWP */
		remove_menu_page( 'mainwp_child_tab' );

		/* All in One WP Security */
		remove_menu_page( 'aiowpsec' );

		/* Ninja Forms (3) */    
		// remove_menu_page( 'ninja-forms' );

		/* Event Espresso */
		// remove_menu_page( 'event_espresso' );

		/* ACF */
		// remove_menu_page( 'edit.php?post_type=acf-field-group' );

		/* ACF - Options */
		// remove_menu_page( 'acf-options' );

		/* Meta Slider */
		// remove_menu_page( 'metaslider' );
	}

	/* == @section Tous les utilisateurs sauf admin et M.Chassot ==================== */
	$user = get_user_by( 'login', 'lmdgadm_web_cha' );


	/* -- @subsection Extensions -------------------- */
	if( ! $user && ! current_user_can( 'add_users' ) ) {
		/* Ninja Forms (3) */    
		remove_menu_page( 'ninja-forms' );
	}
}
add_action( 'admin_menu', 'cdiwp_delete_menu_items', 9999 ); // 9999 permet d'outrepasser les paramètres d'extensions


/* == @section Page Personnaliser ==================== */
function cdiwp_customize_page() {
  global $submenu;
  unset( $submenu['themes.php'][6] );
}
add_action( 'admin_menu', 'cdiwp_customize_page' );