<?php
/*
* Add your own functions here. You can also copy some of the theme functions into this file.
* Wordpress will use those functions instead of the original functions then.
*/


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Ajax Search
    == Ajout des styles du thème
    == Fonctions externalisées
        -- Global
        -- Front
        -- Administration
*/


/* == @section Ajax Search ==================== */
if(!function_exists('avia_append_search_nav'))
{
    //first append search item to main menu
    add_filter( 'wp_nav_menu_items', 'avia_append_search_nav', 10, 2 );
    add_filter( 'avf_fallback_menu_items', 'avia_append_search_nav', 10, 2 );

    function avia_append_search_nav ( $items, $args )
    {
        if(avia_get_option('header_searchicon','header_searchicon') != "header_searchicon") return $items;
        if(avia_get_option('header_position',  'header_top') != "header_top") return $items;

    // Changement destination d'avia vers avia2
    // http://www.kriesi.at/support/topic/move-search-icon-to-secondary-menu/
        if ((is_object($args) && $args->theme_location == 'avia2') || (is_string($args) && $args = "fallback_menu"))
        {
            global $avia_config;
            ob_start();
            get_search_form();
            $form =  htmlspecialchars(ob_get_clean()) ;

            $items .= '<li id="menu-item-search" class="noMobile menu-item menu-item-search-dropdown">
                            <a href="?s=" rel="nofollow" data-avia-search-tooltip="'.$form.'" '.av_icon_string('search').'><span class="avia_hidden_link_text">'.__('Search','avia_framework').'</span></a>
                       </li>';
        }
        return $items;
    }
}


/**
 * Remove bloginfo from title
 * From enfold/framework/php/function-set-avia-frontend.php
 */
function avia_set_title_tag() {
    $title = ( is_front_page() ) ? get_bloginfo( 'description' ) : wp_title( '', false );

    $title = apply_filters( 'avf_title_tag', $title, wp_title( '', false ) );

    return $title;
}


/* == @section Ajout des styles du thème ==================== */
add_action( 'wp_enqueue_scripts', 'enqueue_parent_styles' );
    function enqueue_parent_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri().'/style.css' );
}

add_action( 'wp_enqueue_scripts', 'enqueue_custom_styles', 9999999 ); // Add custom style for homepage to avoid div conflict and use of !important in styles
    function enqueue_custom_styles() {
    if( is_front_page() )
        wp_enqueue_style( 'homepage-style', get_stylesheet_directory_uri().'/css/homepage.css' );
}

add_action( 'wp_enqueue_scripts', 'enqueue_custom_script' );
    function enqueue_custom_script() {
    wp_enqueue_script( 'mdg-script', get_stylesheet_directory_uri().'/js/mdg.js', array( 'jquery' ), null, false );
}


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Cacher des items de la barre d'admin */
require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
    /* Notification de mises à jour du thème */
    require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

    /* Cacher des items du menu aux non administrateurs */
    require get_stylesheet_directory() . '/functions/admin_menu.php';

    /* Cacher les widgets du dashboard */
    require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}
