<?php
/*
 * Template Name: Blog single-post.php
 * Description: Modèle pour le blog
 *
 * Auteur: Sébastien Chevalley
 * Date: Février 2013
 */
get_header(); ?>

<div class="container">
	<div class="row">
		<div class="col20 sidebarLeft">
			<?php get_sidebar(); ?>
		</div>

		<div class="col80">
			<?php
			if( have_posts() ): while ( have_posts() ): the_post();
			if( in_category( 'actualites' ) ):
			?>
			
			<div id="sidebar" class="post_links"></div>

			<div id="page" class="<?php if( has_post_thumbnail() ) echo 'has_thumbnail'; ?> normal">
				<h1>Actualité</h1>

				<div class="clear"></div>
				
				<div class="content shadow-line opacity">
					<div class="article">
						<div class="actualites_page">
							<p><strong><?php the_title(); ?></strong></p>
							
							<div class="contenu">
								<?php the_content(); ?>
							</div>
							
							<span class="date">Publié le <?php echo get_the_date(); ?></span>

							<div class="clear"></div>
						</div>
					</div>
				</div>

				<div class="content shadow-line opacity"></div>
				<div class="clear"></div>
			</div>

			<div class="control">
				<div><?php previous_post_link( '<span class="previous">%link</span>', '← %title', 1 ); ?></div>
				<div><?php next_post_link( '<span class="next">%link</span>', '→ %title', 1 ); ?></div>
				<div class="clear"></div>
			</div>

			<?php else: ?>

			<div id="page" class="blog <?php if( has_post_thumbnail() ) echo 'has_thumbnail'; else echo 'has_no_thumbnail'; ?>">
				<div class="content blogpost">
					<div class="metadata">
						<p class="date">le <?php echo get_the_date( 'd M y' ); ?></p>
						<p class="author">par <?php the_author_meta( 'first_name' ); ?> <?php the_author_meta( 'last_name' ); ?></p>
					</div>

					<div class="article the_post">
						<a href="<?php echo get_permalink(); ?>"><?php the_title( '<h2>', '</h2>' ); ?></a>
						
						<?php the_content(); ?>
					</div>

					<?php if( has_post_thumbnail() ): ?>
					<div class="thumbnail">
						<?php the_post_thumbnail( 'page-thumb', array( 'class' => 'image-effect' ) ); ?>
						
						<?php if( !empty( $customFields['legende-photo'][0] ) ): ?>
						<div class="blue-box blue-box-bottom-right legend">
							<?php echo $customFields['legende-photo'][0]; ?>
						</div>
						<?php endif; ?>
					</div>
					<?php endif; ?>

					<div class="clear"></div>
				</div><!-- .content -->
			</div><!-- .blog -->

			<?php
			endif;
			endwhile; 
			else:
			endif;

			wp_reset_query();
			?>
		</div><!-- .col20 -->
	</div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>