<?php
/**
 * Description: Modèle pour les fiches d'auteurs
 *
 * Auteur: Sébastien Chevalley
 * Date: Janvier 2011
 */
get_header(); ?>

<div class="container">
    <div class="row">
        <?php if( have_posts() ): while ( have_posts() ): the_post(); ?>

        <div class="col20 sidebarLeft">
            <div id="sidebar">
                <div class="control_column">
                    <?php
                    $tags = array();

                    // if( !empty( $customFields['Jour de présence'] ) ) {
                    //  foreach( $customFields['Jour de présence'] as $jour ) {
                    //      $tags[] = $jour;
                    //  }
                    // }
                    //
                    // if( is_array( get_field( 'jours_presence' ) ) && count( get_field( 'jours_presence' ) ) > 0)
                    // $tags = get_field( 'jours_presence' );

                    $tags = llq_joursPresenceAuteur( $id );

                    $lieux = get_the_terms( $post->ID, 'categories-auteurs' );
                    if(is_array( $lieux ) && count( $lieux ) > 0 ) {
                        foreach( $lieux as $lieu ) {
                            $tags[] = $lieu -> slug;
                        }
                    }

                    function isActive( $tag ) {
                        global $tags;

                        if( in_array( $tag, $tags ) ) {
                            return 'active';
                        }
                    }

                    // $categorieAuteur = get_terms( 'categories-auteurs', array( 'hide_empty' => 0 ) );
                    /*
                    $categorieAuteur = wp_get_post_terms( $post->ID, 'categories-auteurs', array( 'hide_empty' => 0 ) );

                    if( isset( $categorieAuteur ) && is_array( $categorieAuteur ) ) {
                        for( $i = 0; $i < count( $categorieAuteur ); $i++ ) {
                            $marginExtra = ( $i == count( $categorieAuteur ) - 1 ) ? ' margin-extra' : '';
                            printf( '<li class="filter %s %s" title="%s">%s</li>', $marginExtra, isActive( $categorieAuteur[$i]->slug ), $categorieAuteur[$i]->slug, $categorieAuteur[$i]->name );
                        }
                    }
                    */
                    ?>

                    <!--
                    <ul id="author_card">
                        <li class="title">En dédicace</li>
                        <li class="filter <?php // echo isActive( 'vendredi' ); ?>" title="vendredi">Vendredi</li>
                        <li class="filter <?php // echo isActive( 'samedi' ); ?>" title="samedi">Samedi</li>
                        <li class="filter margin-separator <?php // echo isActive( 'dimanche' ); ?>" title="dimanche">Dimanche</li>
                        <li><a href="javascript:void(0);" class="blue-box" title="return_to_authors_list">retour à la liste</a></li>
                    </ul>
                    -->

                    <a href="/auteurs" style="font-size:1.2em;">Liste des auteurs·trices</a>
                </div>
            </div>
        </div>

        <div class="col80">
            <div id="page" class="authors_list author_card">
                <div class="col20 author_picture">
                    <?php if( has_post_thumbnail() ): ?>
                    <?php the_post_thumbnail( 'auteur' ); ?>
                    <?php endif; ?>
                    <?php echo get_field( 'copyright_photo' ); ?>
                </div>

                <div class="col60 content shadow-line opacity">
                    <div class="article author_card_2">
                        <?php $customFields = get_post_custom(); ?>

                        <h2 class="author_name"><?php the_title(); ?></h2>

                        <?php
                            $annees = get_the_terms( $post->ID, 'annee-auteurs' );
                            if(is_array( $annees ) && count( $annees ) > 0 ) {
                                if(count( $annees ) > 1 )
                                    echo '<p class="author_presence">Présence durant les éditions :</p>';
                                else
                                    echo '<p class="author_presence">Présence durant l\'édition :</p>';
                                foreach( $annees as $annee ) {
                                    echo '<a class="author_year" href="' . get_page_link( get_page_by_title( 'Auteurs·trices ' . $annee->name ) ) . '" title="Auteurs ' . $annee->name . '">' . $annee->name . '</a>';
                                }
                            }
                        ?>

                        <?php
                        echo wpautop( $customFields['Description'][0] );
                        //echo get_field('nouveaute1Titre');

                        // Programme
                        include ABSPATH . 'docs/JG_Cache.php';
                        $cache = new JG_Cache( ABSPATH . 'docs/cache' ); //Make sure it exists and is writeable
                        $programme = $cache->get( 'programmeAuteur_' . $post->ID, 1800 );

                        if( $programme === FALSE ) {
                            $curlSession = curl_init();
                            curl_setopt( $curlSession, CURLOPT_URL, get_site_url() . '/api.php?act=programmeAuteur&auteurId=' . $post->ID );
                            curl_setopt( $curlSession, CURLOPT_BINARYTRANSFER, true );
                            curl_setopt( $curlSession, CURLOPT_RETURNTRANSFER, true );
                            curl_setopt( $curlSession, CURLOPT_USERAGENT, "CURL" );
                            curl_setopt( $curlSession, CURLOPT_SSL_VERIFYPEER, false);

                            // Debug tools to uncomment if you want to debug
                            // curl_setopt( $curlSession, CURLOPT_VERBOSE, true );
                            // $verbose = fopen( 'php://temp', 'rw+' );
                            // curl_setopt( $curlHandle, CURLOPT_STDERR, $verbose );

                            // $programme = curl_exec( $curlSession );
                            // $debug = false;
                            // if( $debug ) {
                            //  if ( $programme === FALSE ) {
                            //      printf( "cUrl error (#%d): %s<br>\n", curl_errno( $curlSession ),
                            //      htmlspecialchars( curl_error( $curlSession ) ) );
                            //  }
                            //  rewind( $verbose );
                            //  $verboseLog = stream_get_contents( $verbose );

                            //  echo "Verbose information:\n<pre>", htmlspecialchars( $verboseLog ), "</pre>\n";
                            //  print_r( $programme );
                            // }

                            $programme = curl_exec( $curlSession );


                            $programme = $cache->get( 'programmeAuteur_' . $post->ID, 1800 );
                            curl_close( $curlSession );
                        }
                        $programme = json_decode( $programme, true );

                        define( 'RATIO_BARRE_PROGRAMME', 490/29.5/3600 );

                        date_default_timezone_set( 'UTC' );
                        llq_afficherBarreProgramme( $programme, get_field( 'no_place' ) );

                        llq_auteurLinks();
                        ?>
                    </div><!-- .article -->

                    <div class="clear"></div>
                </div><!-- .col60 -->
            </div><!-- .authors_list -->
        </div><!-- .col80 -->

        <?php endwhile; else: endif; ?>
    </div><!-- .row -->
</div><!-- .container -->


<?php get_footer(); ?>
