<?php
/*
 * Template Name: Programme felipe
 * Description: Modèle pour le programme de l'évènement
 */
get_header(); ?>

<div class="container">
    <div class="col20">
        <?php get_sidebar(); ?>

        <?php
        $selectedDay = "-1";
        $selectedCategory = "-1";
        if( isset( $_POST['evD'] ) )
        $selectedDay = $_POST['evD'];
        if( isset( $_POST['evCat'] ) )
        $selectedCategory = $_POST['evCat'];
        ?>
    </div>

    <div class="col80">
        <h1>Programme</h1>

    <?php if ( ! post_password_required() ) : ?>
        <div class="blockSearch row">
            <form  name="searchForm" id="searchForm" action="<?php the_permalink(); ?>" method="post">
                <div class="row">
                    <p>Affichez le programme par jour&nbsp;:</p>
                    <select name="evD" onchange="this.form.submit()" id="evD">
                        <option value="-1">-- Recherche par jour --</option>
                        <?php
                        // Pour masquer un jour du programme. ID des jours dans event_form.php
                        // 349 : mercredi ; 312 : jeudi
                        // $excludeArray = array(349);

                        $days = get_terms( 'jour-evenement',
                            array(
                                // 'exclude'       => $excludeArray,
                                'include'       => get_field('jour-evenement'),
                                'orderby'       => 'tax_order',
                                'order'         => 'ASC',
                                'hide_empty'    => false
                            )
                        );

                        if( isset( $days ) && is_array( $days ) ) {
                            for( $i = 0; $i < count( $days ); $i++ ) {
                                $marginExtra = ( $i == count( $$days ) - 1 ) ? ' margin-extra' : '';
                                printf( '<option %s value="%s">%s</option>', ( $selectedDay == $days[$i]->slug ? 'selected':'' ), $days[$i]->slug, $days[$i]->name );
                            }
                        }
                        ?>
                    </select>
                </div>

                <div class="row">
                    <p>Affichez le programme par type d'évènement&nbsp;:</p>
                    <select name="evCat" onchange="this.form.submit()" >
                        <option value="-1">-- Recherche par type d'évènement --</option>
                        <?php
                        // $categories = get_terms( 'type-evenement' );
                        $categories = get_field( 'type-evenement' );

                        if( isset( $categories ) && is_array( $categories ) ) {
                            for( $i = 0; $i < count( $categories ); $i++ ) {
                                if( isset( $categories[$i] ) && $categories[$i]->name !="" ) {
                                    $marginExtra = ( $i == count( $categories ) - 1 ) ? ' margin-extra' : '';
                                    printf( '<option %s value="%s">%s</option>', ( $selectedCategory == $categories[$i]->slug ? 'selected':'' ), $categories[$i]->slug, $categories[$i]->name );
                                }
                            }
                        }
                        ?>
                    </select>
                </div>
            </form>
        </div>
    <?php endif; ?>

        <!-- <hr/> -->

        <?php if ( have_posts() ) : ?>
        <?php while ( have_posts() ) : the_post(); ?>
        <?php if( $selectedDay == "-1" && $selectedCategory == "-1" ) { // On masque la préouverture si sur un jour ?>

        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="entry clear">
                <?php if ( function_exists( 'add_theme_support' ) ) the_post_thumbnail(); ?>

                <?php the_content(); ?>

                <?php wp_link_pages(); ?>
            </div><!--. entry-->
        </div><!-- #post-ID -->

        <?php } // On masque la préouverture si sur un jour FIN ?>
        <?php endwhile; /* rewind or continue if all posts have been fetched */ ?>

        <nav class="navigation index">
            <div class="alignleft"><?php next_posts_link( 'Older Entries' ); ?></div>
            <div class="alignright"><?php previous_posts_link( 'Newer Entries' ); ?></div>
        </nav><!--.navigation-->

        <?php else : ?>
        <?php endif; ?>

    <?php if ( ! post_password_required() ) : ?>
        <div class="blockProgramme">
            <?php
            if( $selectedDay == "-1" && $selectedCategory == "-1" ) {
                //too many events to print them all
                echo "<h2>Affichez ici le programme par jour&nbsp;:</h2>";
                if( isset( $days ) && is_array( $days ) ) {
                    for( $i = 0; $i < count( $days ); $i++ ) {
                        $marginExtra = ( $i == count( $$days ) - 1 ) ? ' margin-extra' : '';
                        printf( "<p><a href=\"javascript:void(0);\" onclick=\"document.getElementById('evD').value='%s';document.getElementById('evD').form.submit();\">%s</a></p>", $days[$i]->slug, $days[$i]->name );
                    }
                }
            }
            else
            echo llq_ProgrammeList( $annee, $selectedDay, $selectedCategory );
            ?>
        </div><!--.blovkProgramme -->
    <?php endif; ?>
    
    </div><!--.col80 -->
</div><!--.container -->

<script type="text/javascript" src="https://code.jquery.com/jquery-1.10.2.js"></script>
<script type="text/javascript">
    // var divs = $("h2 + .listeProgramme");
    // for(var i = 0; i < divs.length; i+=3) {
    //  divs.slice(i, i+3).wrapAll("<div class='row'></div>");
    // }
    $(".blockProgramme h2:nth-of-type(1)").addClass("je");
    $(".blockProgramme h2:nth-of-type(2)").addClass("ve");
    $(".blockProgramme h2:nth-of-type(3)").addClass("sa");
    $(".blockProgramme h2:nth-of-type(4)").addClass("di");
    $(".je").nextUntil("h2").wrapAll("<div></div>");
    $(".ve").nextUntil("h2").wrapAll("<div></div>");
    $(".sa").nextUntil("h2").wrapAll("<div></div>");
    $(".di").nextUntil("h2").wrapAll("<div></div>");

    if (location.search.indexOf('day=') > 0) {
        $day = location.search.substring(1).split('=')[1];
        $combo = window.document.getElementById('evD');

        if ($combo) {
            $combo.value = $day;
            //this.form.submit();
            document.getElementById("searchForm").submit();
        }
    }
</script>

<?php get_footer(); ?>
