<?php
/*
 * Template Name: Espace presse
 * Description: Modèle pour la page Presse
 *
 * Auteur: Sébastien Chevalley
 * Date: Janvier 2011
 */
get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<?php
// Si c'est la page d'accueil
if( is_page() ):
$customFields = get_post_custom();

if( !empty( $customFields['exergue'][0] ) ):
$phraseExergue = $customFields['exergue'][0];
endif;
?>

<div class="container">
	<div class="col20">
		<?php
		// fro: affiche le sous menu dans les pages. (voir code dans functions.php)
		wp_nav_menu( array(
			'menu'			=> '',
			'before'		=> '<div>',
			'after'			=> '</div>',
			'show_parent'	=> true,
			'sub_menu'		=> true
		) );
		?>
	</div>

	<div class="col80">
		<div class="container">
			<script type="text/javascript" src="<?php echo get_template_directory_uri() . '/js/jquery-1.5.1.min.js'; ?>"></script>
			<script type="text/javascript" src="<?php echo get_template_directory_uri() . '/js/TriPresse.js'; ?>"></script>

			<div class="blockSearch row">
				<p>Filtrer les articles de presse par</p>

				<div id="sidebar">
					<select class="listeCategoriePresse">
						<?php
						$terms = get_terms( 'categorie-presse', array(
							'hide_empty'	=> false,
							'orderby'		=> 'custom_sort'
						) );

						foreach ( $terms as $term ) {
							printf( '<option value="%s" data-categorie="%s">%s</option>', $term->slug, $term->slug, $term->name );
						}
						?>
					</select>
				</div>
			</div><!-- .blockSearch -->
			
			<div id="page" class="presse <?php if( has_post_thumbnail() ) echo 'has_thumbnail'; ?>">
				<?php
				// if ( current_user_can( 'edit_posts' ) )
				// echo '<a href="', get_edit_post_link(), '" class="edit_admin_button button">Éditer</a>';
				?>

				<div class="clear"></div>

				<div class="content shadow-line opacity espacePresse">
					<div class="article">
						<div class="miniColumn">
							<?php
							wp_reset_query();

							query_posts( array(
								'post_type'			=> 'presse',
								'posts_per_page'	=> 400,
								'orderby'			=> 'post_date',
								'order'				=> 'DESC'
							) );

							// echo $GLOBALS['wp_query']->request;

							if( have_posts() ) : while ( have_posts() ) : the_post();
							$type = get_field( 'type_presse' );
							$typePresse = get_the_terms( $post->ID, 'categorie-presse' );
							$typePresseOutput = array();
							$target = "";

							if( is_array( $typePresse ) ) {
								foreach( $typePresse as $typeItem ) {
									$typePresseOutput[] = $typeItem->slug;
								}
							}

							$typePresseOutput = ( implode( ' ', $typePresseOutput ) );

							switch( $type ) {
								case 'file' :
								$content = get_field( 'file_presse' );
								break;
								case 'link' :
								$content = get_field( 'lien_presse' );
								$target = ' target="_blank"';
								break;
								case 'image' :
								$content = wp_get_attachment_image_src( get_field( 'image_presse' ), 'large' );
								break;
							}

							printf( '<p class="presseItem %s" data-typePresse="%s" data-postDate="%s"><a href="%s" %s target="_blank">%s</a>' . "\t\t\t\t" . PHP_EOL . "\t\t\t" . '</p>' . PHP_EOL . "\t\t\t", $typePresseOutput, $type, $post->post_date,  $content, $target, get_the_title() );
							
							endwhile; endif;

							wp_reset_query();
							?>
						</div><!-- .miniColumn -->

						<div id="loadPresse"></div>
					</div><!-- .article -->

					<div class="clear"></div>
				</div><!-- .content -->

				<div class="clear"></div>
			</div><!-- .presse -->
		</div><!-- .container -->
	</div><!-- .col80 -->
</div><!-- .container -->

<?php
// Si c'est la page auteur
elseif(is_page('auteurs')):

endif; // is_page()
endwhile; else:
endif;
?>

<?php get_footer(); ?>