<?php
/*
 * Template Name: Partenaires
 * Description: Page partenaires
 *
 * Auteur: Felipe Roy
 * Date: Juin 2015
 */
get_header(); ?>

<div class="container">
	<div class="row">
		<div class="col20 sidebarLeft">
			<?php get_sidebar(); ?>
		</div>

		<div class="col80">
			<div class="container">
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
					<div class="post-header">
						<h1><?php the_title(); ?></h1>
					</div><!-- .post-header -->

					<div class="entry clear">
						<?php if ( function_exists( 'add_theme_support' ) ) the_post_thumbnail(); ?>
						
						<?php the_content(); ?>

						<?php wp_link_pages(); ?>
					</div><!-- .entry -->
				</div><!-- #post- -->

				<?php endwhile; /* rewind or continue if all posts have been fetched */ ?>

				<nav class="navigation index">
					<div class="alignleft"><?php next_posts_link( 'Older Entries' ); ?></div>
					<div class="alignright"><?php previous_posts_link( 'Newer Entries' ); ?></div>
				</nav><!-- .navigation -->

				<?php else : endif; ?>		
			</div><!-- .container -->	
		</div><!-- .col80 -->
	</div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>