<?php
/*
 * Template Name: Newsletter - Détail d'un bloc
 * Description: Modèle pour le détail d'un bloc de la newsletter
 *
 * Auteur: Felipe Roy
 * Date: Février 2016
 */
get_header(); ?>

<div class="container newsletter">
	<div class="row">
		<div class="col100">
			<div class="container">
				<?php
				// Debug Tools
				$debugMode = false; //set it to true if you want to debug

				$newsletterId = 0;
				$blockId = '';
				$lang = 'fr';

				$clientErrorStr = "Une erreur s'est produite lors l'ouverture du bloc de détail de la Newsletter.<br/> " . "Si le problème se répète, merci de nous contacter.";	

				if( ( ( int )$_GET['nlid'] )<=0 || ( ( int )$_GET['nlbid'] )<=0 || $_GET['nllang'] == '' ) {
					echo $clientErrorStr;	
				} else {
					$NewsletterId	= ( int )$_GET['nlid'];
					$blockId		= ( int )$_GET['nlbid'];
					$lang			= $_GET['nllang'];

					// Create soapclient
					try  {
						$client = new SoapClient( "http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", array(
							'cache_wsdl'	=> 0,
							'trace'			=> 1
						));
						
						if( $debugMode ) {
							echo "<br/><br/><b>Soap client types:</b><br/>";
							var_dump( $client->__getTypes() );
							echo "<br/><br/><b>Soap client functions:</b><br/>";
							var_dump( $client->__getFunctions() );
						}
					}

					catch( Exception $e ) {
						echo $clientErrorStr;
						echo '<br/><b>Erreur :</b>',  $e->getMessage(), "\n";
					}

					// Show Newsletter block
					try {
						$GetNewsletterBlockDetailRequest = array(
							'ClientGuid'		=> '93e7163c-29e9-475b-98c9-6243e08edd39',
							'Password'			=> '#UIr0mUB;Hkh',
							'Language'			=> $lang,
							'IncludeFooter'		=> false,
							'Language'			=> $lang,
							'NewsletterBlockId'	=> $blockId,
							'NewsletterId'		=> $newsletterId
						);

						$response = $client->GetNewsletterBlockDetail( array( 'request' => $GetNewsletterBlockDetailRequest ) );
						
						if( $debugMode )
						var_dump( $response );

						if( $response->GetNewsletterBlockDetailResult->Status == "Success" ) {
							echo $response->GetNewsletterBlockDetailResult->Result;
							echo "<p style=\"max-width:550px; text-align:right;font-weight:bold;\"><a href=\"" . get_site_url() . "/newsletter/?nlid=$newsletterId&nllang=$lang\">Revenir à la newsletter</a></p>";
						} else {
							echo "Impossible d'afficher le détail du bloc de la Newsletter";

							if( $response->GetNewsletterBlockDetailResult->ErrorMessage != '' ) {
								echo "<br/> <br/> <i>Erreur (" . $response->GetNewsletterBlockDetailResult->ErrorCode . ") : " . $response->GetNewsletterBlockDetailResult->ErrorMessage . "</i>";
							}

							echo "<p><a href=\"" . get_site_url() . "/newsletter/?&nllang=$lang\">Revenir à la dernière newsletter.</a></p>";
						}
					}

					catch( SoapFault $fault ) {
						echo "<b>Une erreur s'est produite !</b>";
						
						if( $debugMode ) {
							echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
							echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
							echo "<br/><p>Request :" . htmlspecialchars( $client->__getLastRequest() ) . "</p>";
							echo "<br/><p>Response :" . htmlspecialchars( $client->__getLastResponse() ) . "</p>";
						}
						
						if ( $client != null ) {
							$client = null;
						}

						exit();
					}

					$client = null;
				}
				?>
			</div><!-- .container -->
		</div><!-- .col80 -->
	</div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>