<?php
/*
 * Template Name: Newsletter - Confirmation de désinscription
 * Description: Modèle pour la page de confirmation de désinscription à la newsletter
 *
 * Auteur: Felipe Roy
 * Date: Février 2016
 */
get_header(); ?>

<div class="container newsletter">
    <div class="row">
        <div class="col100">
            <div class="container">
                <?php
                // Debug Tools
                $debugMode = false; //set it to true if you want to debug

                $newsletterId = 0;
                $email = '';

                $clientErrorStr = "<p>Une erreur s'est produite lors de la désinscription.</p> " . "<p>Si le problème se répète, merci de nous contacter.</p>";

                if ( isset( $_POST['unsubscribe'] ) && ( int )$_POST['nlid']>0 && $_POST['nlm'] != '' ) {
                    $NewsletterId   = ( int )$_POST['nlid'];
                    $email          = $_POST['nlm'];

                    // Create soapclient
                    try {
                        $client = new SoapClient( "http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", array(
                            'cache_wsdl'    => 0,
                            'trace'         => 1
                        ) );

                        if( $debugMode ) {
                            echo "<br/><br/><b>Soap client types:</b><br/>";
                            var_dump( $client->__getTypes() );
                            echo "<br/><br/><b>Soap client functions:</b><br/>";
                            var_dump( $client->__getFunctions() );
                        }
                    }

                    catch(Exception $e) {
                        echo $clientErrorStr;
                        echo '<br/><b>Erreur :</b>',  $e->getMessage(), "\n";
                    }

                    // Do unsubsribe
                    try {
                        $unsubscribeRequest = array(
                            'ClientGuid'    => '93e7163c-29e9-475b-98c9-6243e08edd39',
                            'Password'      => '#UIr0mUB;Hkh',
                            'Email'         => $email,
                            'NewsletterId'  => $newsletterId
                        );

                        $unsubscribeResponse = $client->Unsubscribe( array(
                            'request'       => $unsubscribeRequest
                        ));

                        if( $debugMode ) {
                            echo "<br/><br/><b>Unsubscribe response:</b><br/>";
                            var_dump( $unsubscribeResponse );
                        }

                        if( $unsubscribeResponse->UnsubscribeResult->Result == true )
                        echo "<p>Votre désinscription à la newsletter du Livre sur les quais a été enregistrée pour $email.<p/>";
                        else {
                            echo $clientErrorStr;

                            if( $unsubscribeResponse->UnsubscribeResult->ErrorMessage != '' ) {
                                echo "<br/> <br/> <i>Erreur (" . $unsubscribeResponse->UnsubscribeResult->ErrorCode . ") : " . $unsubscribeResponse->UnsubscribeResult->ErrorMessage . "</i>";
                            }
                        }
                    }

                    catch ( SoapFault $fault ) {
                        echo $clientErrorStr;

                        if( $debugMode ) {
                            echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
                            echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
                            echo "<br/><p>Request :" . htmlspecialchars( $client->__getLastRequest() ) . "</p>";
                            echo "<br/><p>Response :" . htmlspecialchars( $client->__getLastResponse() ) . "</p>";
                        }

                        if ( $client != null ) {
                            $client = null;
                        }

                        exit();
                    }
                } elseif( ( int )$_GET['nlid']>0 || $_GET['nlm'] != '' ) {
                    echo "<h3>Nous regrettons votre décision de vous désinscrire de notre newsletter</h3><h4>Cliquez sur le bouton ci-dessous pour confirmer votre désincription</h4><p>Email à désinscrire: " . $_GET['nlm'] . "</p>";
                } else {
                    echo $clientErrorStr;
                }
                ?>

                <form action="<?php the_permalink(); ?>" method="post"
                <?php if ( ( ( int )$_GET['nlid']<=0 || $_GET['nlm'] == '' ) || isset( $_POST['unsubscribe'] ) ) { echo ' style="display: none"'; } ?>
                onsubmit="return confirm('Êtes-vous sûr de vouloir vous désinscrire de la newsletter du Livre sur les Quais ?');">
                    <input type="hidden" name="nlid" value="<?php echo $_GET['nlid']; ?>">
                    <input type="hidden" name="nlm" value="<?php echo $_GET['nlm']; ?>">
                    <input type="submit" name="unsubscribe" value="Se désinscrire de la newsletter"/>
                </form>
            </div><!-- .container -->
        </div><!-- .col100 -->
    </div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>
