<?php
/*
 * Template Name: Archives newsletters CDI
 * Description: Modèle pour la page newsletter
 *
 * Auteur: Luc Poupard
 * Date: Avril 2019
 */
get_header(); ?>

<?php
wp_register_script( 'newsletterJS', get_template_directory_uri() . '/js/page-NL.js' );
wp_enqueue_script( 'newsletterJS' );

// Debug Tools
$debugMode                      = false; // set it to true if you want to debug
$debugSubscriptionOnlyMode      = false; // set it to true if you want to debug subscription only
$debugNewsletterOnlyMode        = false; // set it to true if you want to debug newsletter only
$debugNewsletterListOnlyMode    = false; // set it to true if you want to debug previous newsletter list only

// Create soapclient
try {
    if( $debugMode ) {
        echo "Start Create soapclient";
    }

    $client = new SoapClient( "http://newsletter.cdi.ch/services/services/CdiNewsletterService.svc?Wsdl", array(
        'cache_wsdl'    => 0,
        'trace'         => 1
    ) );

    if($debugMode) {
        echo "<br/><br/><b>Soap client types:</b><br/>";
        var_dump( $client->__getTypes() );
        echo "<br/><br/><b>Soap client functions:</b><br/>";
        var_dump( $client->__getFunctions() );
    }
}
catch ( Exception $e ) {
    echo 'Erreur : ',  $e->getMessage(), "\n";
}

// Get previous newsletter list
if( $debugMode || $debugNewsletterListOnlyMode ) {
    echo "<br/>Start get list of previous newsletters <br/>";
}

$GetNewsletters = null;
$lastNewsletterId = 0;
try {

    $lang = 'fr';
    if( $_GET['nllang'] != '' )
    $lang = $_GET['nllang'];

    $GetNewsletters = array(
        'ClientGuid'    => '93e7163c-29e9-475b-98c9-6243e08edd39',
        'Password'      => '#UIr0mUB;Hkh',
        'Language'      => $lang,
        'SortDirection' => 'Descending',
        'IsPublished' => true,
        'DateSentFrom' => mktime(0, 0, 0, 1, 1, 2016)

    );

    $response = $client->GetNewsletters( array( 'request' => $GetNewsletters ) );
    if( $debugMode || $debugNewsletterListOnlyMode )
    var_dump( $response );
    if( $response->GetNewslettersResult->Status == "Success" ) {
    $GetNewsletters = $response->GetNewslettersResult->Result;
        // foreach ($GetNewsletters->NewsletterItem as $NewsletterItem)
        // {
        //  echo"<br/>id=".$NewsletterItem->Id." value=".$NewsletterItem->Subject."<br/>";
        // }
    } else {
        echo "Aucune newsletter disponible pour le moment !";
        if ( $response->GetNewslettersResult->ErrorMessage != '' ) {
            echo "<br/><br/> <i>Erreur (" . $response->GetNewslettersResult->ErrorCode . ") : " . $response->GetNewslettersResult->ErrorMessage . "</i>";
        }
    }
}

catch ( SoapFault $fault ) {
    echo "<b>Une erreur s'est produite lors de la récupération des newsletters précédentes !</b>";
    if( $debugMode || $debugNewsletterListOnlyMode ) {
        echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
        echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
        echo "<br/><p>Request :" . htmlspecialchars( $client->__getLastRequest() ) . "</p>";
        echo "<br/><p>Response :" . htmlspecialchars( $client->__getLastResponse() ) . "</p>";
    }

    if ( $client != null ) {
        $client = null;
    }

    exit();
}
?>

<div class="container newsletter">
    <div class="row">
        <div class="col20 sidebarLeft">
            <div class="nlSearch">
                <h4>Rechercher une newsletter</h4>

                <form  action="#" name="SentNewsletterForm">
                    <select name="nlid" id="nlid" onchange="SentNewsletterForm.submit();">
                        <?php
                                                     if($GetNewsletters != null)
                             {
                                 if(isset($GetNewsletters->NewsletterItem->Id) && $GetNewsletters->NewsletterItem->Id>0)
                                 {//if there is only one newsletter in response, the response is directly the newsletter
                                        $lastNewsletterId = (int)$NewsletterItem->Id;
                                        $NewsletterItem = $GetNewsletters->NewsletterItem;
                                        if(((int)$_GET['nlid'])>0 && $_GET['nlid'] == $NewsletterItem->Id)
                                        {
                                            $dateStr ="";
                                            if ($NewsletterItem->DateSent!=null)
                                            {
                                                $dateStr = " (".date("d-m-Y", strtotime($NewsletterItem->DateSent)).")";
                                            }
                                            echo "<option selected='selected' value='".$NewsletterItem->Id."'>".$NewsletterItem->Subject.$dateStr."</option>";
                                        }
                                        else
                                        {
                                            $dateStr ="";
                                            if ($NewsletterItem->DateSent!=null)
                                            {
                                                $dateStr = " (".date("d-m-Y", strtotime($NewsletterItem->DateSent)).")";
                                            }
                                            echo "<option value='".$NewsletterItem->Id."'>".$NewsletterItem->Subject.$dateStr."</option>";
                                        }
                                }
                                else
                                {
                                    if( $GetNewsletters != null )
                                    {
                                        $nlCpt = 0;
                                        foreach( $GetNewsletters->NewsletterItem as $NewsletterItem )
                                        {
                                            if($nlCpt==0)
                                            {
                                                $lastNewsletterId = (int)$NewsletterItem->Id;
                                            }
                                            $nlCpt++;

                                            if( ( ( int )$_GET['nlid'] )>0 && $_GET['nlid'] == $NewsletterItem->Id )
                                            {
                                                $dateStr ="";
                                                if ($NewsletterItem->DateSent!=null)
                                                {
                                                    $dateStr = " (".date("d-m-Y", strtotime($NewsletterItem->DateSent)).")";
                                                }
                                                echo "<option selected='selected' value='" . $NewsletterItem->Id . "'>" . $NewsletterItem->Id . ". " . $NewsletterItem->Subject . $dateStr. "</option>";
                                            }
                                            else
                                            {
                                                $dateStr ="";
                                                if ($NewsletterItem->DateSent!=null)
                                                {
                                                    $dateStr = " (".date("d-m-Y", strtotime($NewsletterItem->DateSent)).")";
                                                }
                                                echo "<option value='" . $NewsletterItem->Id . "'>" . $NewsletterItem->Id . ". " . $NewsletterItem->Subject . $dateStr. "</option>";
                                            }
                                        }
                                    }
                                }
                             }
                        ?>
                    </select>
                </form>
            </div><!-- .nlSearch -->

            <div>
                <a href="/newsletter">Voir les newsletters plus récentes</a>
            </div>
        </div><!-- .col20 -->

        <div class="col80">
            <div class="container">
                <?php
                // Do inscription and confirm
                $clientErrorStr = "<p class=\"confirm\">Une erreur s'est produite lors de l'inscription. Veuillez remplir à nouveau le formulaire d'inscription.<br/> " . "Si le problème persiste, merci de nous contacter.</p>";

                if( $debugMode || $debugSubscriptionOnlyMode ) {
                    echo "<br/> POST = <br/>";
                    print_r( $_POST );
                }

                if( $_POST['nl_email']!='' ) {
                    if( $debugMode || $debugSubscriptionOnlyMode ) {
                        echo "Start do inscription and confirm";
                    }

                    $subscribeRequest = array('ClientGuid'  => '93e7163c-29e9-475b-98c9-6243e08edd39',
                    'Password'    => '#UIr0mUB;Hkh',
                    'Email'       => $_POST['nl_email'],
                    'Language'    => 'fr');

                    try {
                        $subscribeResponse = $client->Subscribe( array( 'request' => $subscribeRequest ) );

                        if( $debugMode || $debugSubscriptionOnlyMode ) {
                            echo "<br/><br/><b>Subscription response:</b><br/>";
                            var_dump( $subscribeResponse );
                        }

                        if( $subscribeResponse->SubscribeResult->Result == true )
                        echo "<p class=\"confirm\">Votre inscription à la newsletter a été enregistrée. Merci.<p/>";
                        else {
                            echo $clientErrorStr;

                            if( $subscribeResponse->SubscribeResult->ErrorMessage != '' ) {
                                echo "<br/><br/> <i>Erreur (" . $subscribeResponse->SubscribeResult->ErrorCode . ") : " . $subscribeResponse->SubscribeResult->ErrorMessage . "</i>";
                            }
                        }
                    }

                    catch ( SoapFault $fault ) {
                        echo $clientErrorStr;

                        if( $debugMode || $debugSubscriptionOnlyMode ) {
                            echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
                            echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
                            echo "<br/><p>Request :" . htmlspecialchars( $client->__getLastRequest() ) . "</p>";
                            echo "<br/><p>Response :" . htmlspecialchars( $client->__getLastResponse() ) . "</p>";
                        }

                        if ( $client != null ) {
                            $client = null;
                        }

                        exit();
                    }
                }

                // Show Newsletter
                try {
                    if( $debugMode || $debugNewsletterOnlyMode ) {
                        echo "Start Show newsletter";
                    }

                    $lang='fr';

                    if( $_GET['nllang'] != '' )
                    $lang = $_GET['nllang'];

                    $crtNewsletterId =  ( int )$_GET['nlid'];

                    if( $crtNewsletterId <= 0 ) {
                        $crtNewsletterId = $lastNewsletterId;
                        // Get last newsletter
                        // $GetLastNewsletterRequest = array(
                            // 'ClientGuid' => '93e7163c-29e9-475b-98c9-6243e08edd39',
                            // 'Password'       => '#UIr0mUB;Hkh',
                            // 'Language'       => $lang,
                            // 'IncludeFooter'  => false
                        // );

                        // $response = $client->GetLastNewsletter( array( 'request' => $GetLastNewsletterRequest ) );
                        // if( $debugMode || $debugNewsletterOnlyMode )
                        // var_dump( $response );

                        // if( $response->GetLastNewsletterResult->Status == "Success" ) {
                            // echo $response->GetLastNewsletterResult->Result;
                        // } else {
                            // echo "Aucune newsletter disponible pour le moment.";

                            // if( $response->GetLastNewsletterResult->ErrorMessage != '' ) {
                                // echo "<br/><br/> <i>Erreur (" . $response->GetLastNewsletterResult->ErrorCode . ") : " . $response->GetLastNewsletterResult->ErrorMessage . "</i>";
                            // }
                        // }
                    }
                    if ( $crtNewsletterId >0) {
                        // Get newsletter of a specific id
                        $GetNewsletterRequest = array(
                            'ClientGuid'    => '93e7163c-29e9-475b-98c9-6243e08edd39',
                            'Password'      => '#UIr0mUB;Hkh',
                            'Language'      => $lang,
                            'IncludeFooter' => false,
                            'NewsletterId'  => $crtNewsletterId
                        );

                        $response = $client->GetNewsletter( array( 'request' => $GetNewsletterRequest ) );

                        if( $debugMode || $debugNewsletterOnlyMode )
                        var_dump( $response );
                        if( $response->GetNewsletterResult->Status == "Success" ) {
                            echo $response->GetNewsletterResult->Result;
                        } else  {
                            echo "Aucune newsletter disponible pour le moment.";

                            if( $response->GetNewsletterResult->ErrorMessage != '' ) {
                                echo "<br/><br/> <i>Erreur (" . $response->GetNewsletterResult->ErrorCode . ") : ". $response->GetNewsletterResult->ErrorMessage . "</i>";
                            }
                        }
                    }
                    else
                    {
                        echo "Aucune newsletter disponible pour le moment.";
                    }
                }

                catch ( SoapFault $fault ) {
                    echo "<b>Une erreur s'est produite !</b>";

                    if( $debugMode || $debugNewsletterOnlyMode ) {
                        echo "<br/><b>Fault code:</b> {$fault->faultcode}" . "<br/>";
                        echo "<br/><b>Fault string:</b> {$fault->faultstring}" . "<br/><br/><br/>";
                        echo "<br/><p>Request :" . htmlspecialchars( $client->__getLastRequest() ) . "</p>";
                        echo "<br/><p>Response :" . htmlspecialchars( $client->__getLastResponse() ) . "</p>";
                    }

                    if ( $client != null ) {
                        $client = null;
                    }

                    exit();
                }

                $client = null;
                ?>
            </div><!-- .container -->
        </div><!-- .col80 -->
    </div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>
