<?php
/**
 * Template Name: Votes ouvrages
 * Description: Modèle pour la page des votes d'ouvrages
 *
 *
 * Auteur: CDI
 * Date: Mars 2016
 */
 session_start();
    $hasVoted = false;
    $hasVoteError = false;
    $exceptionStr = "";
    $debugMode = false;
    $hasAlreadyVoted = false;
    function isReCaptchaValid($code, $ip = null)
    {
        if (empty($code)) {
            return false; // Si aucun code n'est entré, on ne cherche pas plus loin
        }
        $params = [
            'secret'    => "6LeakRoTAAAAAC_3vtwOlQCtVUVjPOgHphKWACOG",
            'response'  => $code
        ];
        if( $ip ){
            $params['remoteip'] = $ip;
        }
        $url = "https://www.google.com/recaptcha/api/siteverify?" . http_build_query($params);
        if (function_exists('curl_version')) {
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_TIMEOUT, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // Evite les problèmes, si le ser
            $response = curl_exec($curl);
        } else {
            echo "getcontent";
            // Si curl n'est pas dispo, un bon vieux file_get_contents
            $response = file_get_contents($url);
        }
        if (empty($response) || is_null($response)) {
            return false;
        }

        $json = json_decode($response);
        return $json->success;
    }
    $categorie = get_field('categorie');
    if(((int)$_POST['li_sel'])>0 || $_COOKIE["vllq".$categorie]=="v")
    { //thiis code has to be here because cookie must be set before any html echo
        $hasVoted  = true;
        if(((int)$_POST['li_sel'])>0 && ($_COOKIE["vllq".$categorie]==null || $_COOKIE["vllq".$categorie]!="v"))
        {          
            if(isReCaptchaValid($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']) === true)
            { 
                setcookie("vllq".$categorie, "v",strtotime( '+210 days' ));
                if(!isset($_SESSION['v_'.$categorie]))
                {
                    try
                    {
                        $_SESSION['v_'.$categorie] = 'voted';
                        $ouvragePostId = ((int)$_POST['li_sel']);
                        $nbVote = (int) get_field("nb_de_votes", $ouvragePostId);
                        update_field("field_56e95dfa57459", ($nbVote+1), $ouvragePostId); 
                        
                        $log = get_field("votes_log_info", $ouvragePostId);
                        update_field("field_57022c181e4c0",($log.";".$_SERVER['REMOTE_ADDR'].":".date("Y-m-d H.i.s")), $ouvragePostId); 
                    }
                    catch (Exception $e)
                    {
                        $hasVoteError = true;
                        $exceptionStr =  "<br/>Exception reçue : ".$e->getMessage()."<br/>";
                        
                    }
                }
                else
                {
                    
                    $hasVoted = true;
                    $hasVoteError = false;
                    $hasAlreadyVoted = true;
                }
            }
            else
            {
                $hasVoted = false;
                $hasVoteError = true;
            }
        }
    }
    get_header();
?>
<div class="container">
	<div class="col20 sidebarLeft">
		<?php
            wp_nav_menu( array(
                'menu'			=> '',
                'before'		=> '<div>',
                'after'			=> '</div>',
                'show_parent'	=> true,
                'sub_menu'		=> true) );
		?>
	</div>

	<div class="col80">
		<div class="container">
			<h1>Votez pour l'ouvrage de votre choix</h1>
			<?php
    		// pour afficher le contenu de la page (pour introduction au prix)
		    while ( have_posts() ) : the_post(); ?>
		        <div class="contenuPagePrix">
		            <?php the_content(); ?>
		        </div>

		    <?php
                endwhile; //resetting the page loop
                wp_reset_query(); //resetting the page query
                $categorie = get_field('categorie');
                $args = array( 
                                'post_type' => 'ouvrage',					
                                'tax_query' => array( 
                                        array( 
                                            'taxonomy' => 'categories-ouvrage',
                                            'field' => 'id', 
                                            'terms' => array($categorie) 
                                        ) 
                                ) 					
                        );
                 $loop = new WP_Query($args);
                 
                 if($debugMode)
                 {
                     echo "<br/> Cookie vote = [".$_COOKIE["vllq".$categorie]."]<br/>";
                 }
            ?>
			<div class="formVote" >
                <?php 
                 
                if($hasVoted) 
                {
                    if($hasVoteError)
                    {
                        
                        if($debugMode)
                            echo $exceptionStr;
                        echo "<div class=\"error\" hidden>
                                    <p>Une erreur est survenue</p>
                                 </div>";
                    }
                    elseif($hasAlreadyVoted)
                    {
                        echo "<div class=\"success\">
                                <p>Votre vote a déjà été pris en compte !</h3>
                                </div>";
                    }
                    else
                    {
                        echo "<div class=\"success\">
                                <p>Merci, votre choix a bien été pris en compte</h3>
                                </div>";
                    }
                }
                else { 
                if($hasVoteError)
                {
                    
                        echo "<div class=\"error\">
                                <p>Une erreur est survenue, veuillez réitérer votre vote. N'oubliez pas de cocher 'Je ne suis pas un robot'.</h3>
                                </div>";
                }
                ?>
                    <form method="POST" action="<?php the_permalink(); ?>" >
                        <select name="li_sel">
                            <option selected>Votez pour un ouvrage ci-dessous</option>
                            <?php
                                while ($loop->have_posts()): $loop->the_post();
                                    $title = get_the_title();
                                    $id = get_the_ID();
                                    echo '<option value="'.$id.'">'.$title.'</option>';						
                                endwhile;
                            ?>		
                        </select>
                        <div class="g-recaptcha" data-sitekey="6LeakRoTAAAAAETz68KkoA22SWwFPuFtZdg15tiy"></div>
                        
                        <input type="submit" value="Voter">
                    </form>
                        
                <?php } ?>
			</div>
			<div class="vote">
				<?php 
					while ( $loop->have_posts() ) : $loop->the_post();				
					$auteur = get_field('auteur');
					$infosup = get_field('informations_supplementaires');                                       
				?>
				<div class="ficheOuvrage">
					
					<div class="col20"><?php the_post_thumbnail(); ?></div>
					<div class="col80">
						<h3><?php the_title(); ?></h3>
						<div>
							<p class="ouvrageAuteur"><?php echo $auteur; ?></p>
							<div class="ouvrageDescription"><?php the_content(); ?></div>							
							<div class="ouvrageInfoSup"><?php echo $infosup; ?></div>										
							<p class="ouvrageLiens">
								<?php 
									while( have_rows('liens') ): the_row();
											$liens = get_sub_field('AdresseUrl');
											$titre_du_lien = get_sub_field('titre_du_lien');											
											echo '<p><a href="'.$liens.'">';
											echo $titre_du_lien . '</a></p>';
									endwhile;
								?>
							</p>
							
						</div>
					</div>
				</div>
				<?php endwhile;?>
		</div>
		
	</div><!-- .col80 -->

	

</div><!-- .container -->

<?php get_footer();	?>