/*
	Supersized - Fullscreen Background jQuery Plugin
	Version 3.1 Core
	www.buildinternet.com/project/supersized
	
	By Sam Dunn / One Mighty Roar (www.onemightyroar.com)
	Released under MIT License / GPL License
*/

(function($){
	
	
	//Resize image to fill background
	$.supersized = function( options ) {
		
		//Default settings
		var settings = {
			//Functionality
			slideshow               :   1,		//Slideshow on/off
			autoplay				:	1,		//Slideshow starts playing automatically
			start_slide             :   1,		//Start slide (0 is random)
			random					: 	0,		//Randomize slide order (Ignores start slide)
			slide_interval          :   5000,	//Length between transitions
			transition              :   1, 		//0-None, 1-Fade, 2-Slide Top, 3-Slide Right, 4-Slide Bottom, 5-Slide Left, 6-Carousel Right, 7-Carousel Left
			transition_speed		:	750,	//Speed of transition
			new_window				:	1,		//Image links open in new window/tab
			pause_hover             :   0,		//Pause slideshow on hover
			keyboard_nav            :   1,		//Keyboard navigation on/off
			performance				:	1,		//0-Normal, 1-Hybrid speed/quality, 2-Optimizes image quality, 3-Optimizes transition speed // (Only works for Firefox/IE, not Webkit)
			image_protect			:	1,		//Disables image dragging and right click with Javascript
			image_path				:	'img/', //Default image path

			//Size & Position
			min_width		        :   0,		//Min width allowed (in pixels)
			min_height		        :   0,		//Min height allowed (in pixels)
			vertical_center         :   1,		//Vertically center background
			horizontal_center       :   1,		//Horizontally center background
			fit_portrait         	:   0,		//Portrait images will not exceed browser height
			fit_landscape			:   0,		//Landscape images will not exceed browser width

			//Components
			navigation              :   1,		//Slideshow controls on/off
			thumbnail_navigation    :   0,		//Thumbnail navigation
			slide_counter           :   1,		//Display slide numbers
			slide_captions          :   1		//Slide caption (Pull from "title" in slides array)
    	};
		
		var element = $('#supersized');		//Define element for Supersized
		
		//Combine options with default settings
		if (options) {
			var options = $.extend(settings, options);	//Pull from both defaults and supplied options
		}else{
			var options = $.extend(settings);			//Only pull from default settings		
		}	
		
		//Determine starting slide (random or defined)
		if (options.start_slide){
			var currentSlide = options.start_slide - 1;	//Default to defined start slide
		}else{
			var currentSlide = Math.floor(Math.random()*options.slides.length);	//Generate random slide number
		}
		
		$("<img/>").attr("src", options.slides[currentSlide].image).appendTo(element);		//Set current image
		
		element.hide();		//Hide image to be faded in
		
		//Display image once page has loaded
		$(window).load(function(){
		
			$('#supersized-loader').hide();		//Hide loading animation
			element.fadeIn('fast');				//Fade in background
			
			
			resizenow();
			
			var topPositionWithSupersize = $('#supersized img').height() + $('#supersized img').position().top - $('#gradient-bottom').height();
			if($('#supersized img').height() > $('#zone').height())
				$('#gradient-bottom').css('top', $('#extra-content').position().top - $('#gradient-bottom').height());
			else
				$('#gradient-bottom').css('top', topPositionWithSupersize);
			
		});
		
		//Adjust image when browser is resized
		$(window).resize(function(){


			resizenow();
				
			var topPositionWithSupersize = $('#supersized img').height() + $('#supersized img').position().top - $('#gradient-bottom').height();
			if($('#supersized img').height() > $('#zone').height())
				$('#gradient-bottom').css('top', $('#extra-content').position().top - $('#gradient-bottom').height());
			else
				$('#gradient-bottom').css('top', topPositionWithSupersize);
		});
	
		//Adjust image size
		function resizenow() {
			return element.each(function() {
		  	
		  		var t = $('img', element);
		  		
		  		//Resize each image seperately
		  		$(t).each(function(){
		  			
					var ratio = ($(this).height()/$(this).width()).toFixed(2);	//Define image ratio
					
					//Gather browser size
					var browserwidth = $(window).width();
					var browserheight = $(window).height();
					var offset;
					
					//Resize image to proper ratio
					if ((browserheight > options.min_height) || (browserwidth > options.min_width)){	//If window larger than minimum width/height
						
						if ((browserheight/browserwidth) > ratio){
							
							if ( options.fit_landscape && ratio <= 1){	//If landscapes are set to fit
						    	$(this).width(browserwidth);
						    	$(this).height(browserwidth * ratio);
							}else{										//Otherwise handle normally
								$(this).height(browserheight);
							    $(this).width(browserheight / ratio);
							}
						
						} else {
						
							if ( options.fit_portrait && ratio > 1){	//If portraits are set to fit
								$(this).height(browserheight);
							    $(this).width(browserheight / ratio);
							}else{										//Otherwise handle normally
								$(this).width(browserwidth);
						    	$(this).height(browserwidth * ratio);
							}
						
						}	//End dynamic resizing
						
					}	//End minimum size check
					
					//Horizontally Center
					if (options.horizontal_center){
						$(this).css('left', (browserwidth - $(this).width())/2);
					}
					
					//Vertically Center
					if (options.vertical_center){
						$(this).css('top', ($('#zone').height() - $(this).height())/2);
					}
					
				});
				
				return false;
				
			});
		};
		
	//Next slide
		function nextslide() {

			if(inAnimation) return false;		//Abort if currently animating
				else inAnimation = true;		//Otherwise set animation marker

		    var slides = options.slides;	//Pull in slides array

			var currentslide = element.find('.activeslide');		//Find active slide
			currentslide.removeClass('activeslide');				//Remove active class

		    if ( currentslide.length == 0 ) currentslide = element.find('a:last');	//If end of set, note this is last slide
		    var nextslide = currentslide.next().length ? currentslide.next() : element.find('a:first');
			var prevslide = nextslide.prev().length ? nextslide.prev() : element.find('a:last');

			//Update previous slide
			$('.prevslide').removeClass('prevslide');
			prevslide.addClass('prevslide');

			//Get the slide number of new slide
			currentSlide + 1 == slides.length ? currentSlide = 0 : currentSlide++;

			//If hybrid mode is on drop quality for transition
			if (options.performance == 1) element.removeClass('quality').addClass('speed');

			/**** Image Loading ****/

			//Load next image
			loadSlide = false;

			currentSlide == slides.length - 1 ? loadSlide = 0 : loadSlide = currentSlide + 1;	//Determine next slide
			imageLink = (options.slides[loadSlide].url) ? "href='" + options.slides[loadSlide].url + "'" : "";	//If link exists, build it
			$("<img/>").attr("src", options.slides[loadSlide].image).appendTo(element).wrap("<a " + imageLink + linkTarget + "></a>");	//Append new image

			//Update thumbnails (if enabled)
			if (options.thumbnail_navigation == 1){

				//Load previous thumbnail
				currentSlide - 1 < 0  ? prevThumb = slides.length - 1 : prevThumb = currentSlide - 1;
				$('#prevthumb').html($("<img/>").attr("src", options.slides[prevThumb].image));

				//Load next thumbnail
				nextThumb = loadSlide;
				$('#nextthumb').html($("<img/>").attr("src", options.slides[nextThumb].image));

			}

			currentslide.prev().remove(); //Remove Old Image

			/**** End Image Loading ****/


			//Update slide number
			if (options.slide_counter){
			    $('#slidecounter .slidenumber').html(currentSlide + 1);
			}

			//Update captions
		    if (options.slide_captions){
		    	(options.slides[currentSlide].title) ? $('#slidecaption').html(options.slides[currentSlide].title) : $('#slidecaption').html('');
		    }

		    nextslide.hide().addClass('activeslide');	//Update active slide

	    	switch(options.transition){

	    		case 0:    //No transition
	    		    nextslide.show(); inAnimation = false;
	    		    break;
	    		case 1:    //Fade
	    		    nextslide.fadeTo(options.transition_speed, 1, function(){ afterAnimation(); });
	    		    break;
	    		case 2:    //Slide Top
	    		    nextslide.animate({top : -$(window).height()}, 0 ).show().animate({ top:0 }, options.transition_speed, function(){ afterAnimation(); });
	    		    break;
	    		case 3:    //Slide Right
	    			nextslide.animate({left : $(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 4:    //Slide Bottom
	    			nextslide.animate({top : $(window).height()}, 0 ).show().animate({ top:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 5:    //Slide Left
	    			nextslide.animate({left : -$(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 6:    //Carousel Right
	    			nextslide.animate({left : $(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
					currentslide.animate({ left: -$(window).width() }, options.transition_speed );
	    			break;
	    		case 7:    //Carousel Left
	    			nextslide.animate({left : -$(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
					currentslide.animate({ left: $(window).width() }, options.transition_speed );
	    			break;
	    	};

		}


		//Previous Slide
		function prevslide() {

			if(inAnimation) return false;		//Abort if currently animating
				else inAnimation = true;		//Otherwise set animation marker

			var slides = options.slides;	//Pull in slides array

			var currentslide = element.find('.activeslide');		//Find active slide
			currentslide.removeClass('activeslide');				//Remove active class

		    if ( currentslide.length == 0 ) currentslide = $(element).find('a:first');	//If end of set, note this is first slide
		    var nextslide =  currentslide.prev().length ? currentslide.prev() : $(element).find('a:last');
			var prevslide =  nextslide.next().length ? nextslide.next() : $(element).find('a:first');

			//Update previous slide
			$('.prevslide').removeClass('prevslide');
			prevslide.addClass('prevslide');

			//Get current slide number
			currentSlide == 0 ?  currentSlide = slides.length - 1 : currentSlide-- ;

			//If hybrid mode is on drop quality for transition
			if (options.performance == 1) element.removeClass('quality').addClass('speed');

			/**** Image Loading ****/

			//Load next image
			loadSlide = false;
			currentSlide - 1 < 0  ? loadSlide = slides.length - 1 : loadSlide = currentSlide - 1;	//Determine next slide
			imageLink = (options.slides[loadSlide].url) ? "href='" + options.slides[loadSlide].url + "'" : "";	//If link exists, build it
			$("<img/>").attr("src", options.slides[loadSlide].image).prependTo(element).wrap("<a " + imageLink + linkTarget + "></a>");	//Append new image

			//Update thumbnails (if enabled)
			if (options.thumbnail_navigation == 1){

				//Load previous thumbnail
				prevThumb = loadSlide;
				$('#prevthumb').html($("<img/>").attr("src", options.slides[prevThumb].image));

				//Load next thumbnail
				currentSlide == slides.length - 1 ? nextThumb = 0 : nextThumb = currentSlide + 1;
				$('#nextthumb').html($("<img/>").attr("src", options.slides[nextThumb].image));
			}

			currentslide.next().remove(); //Remove Old Image

			/**** End Image Loading ****/


			//Update slide counter
			if (options.slide_counter){
			    $('#slidecounter .slidenumber').html(currentSlide + 1);
			}

			//Update captions
		    if (options.slide_captions){
		    	(options.slides[currentSlide].title) ? $('#slidecaption').html(options.slides[currentSlide].title) : $('#slidecaption').html('');
		    }

		    nextslide.hide().addClass('activeslide');	//Update active slide

		    switch(options.transition){

	    		case 0:    //No transition
	    		    nextslide.show(); inAnimation = false;
	    		    break;
	    		case 1:    //Fade
	    		    nextslide.fadeTo(options.transition_speed, 1, function(){ afterAnimation(); });
	    		    break;
	    		case 2:    //Slide Top (reverse)
	    		    nextslide.animate({top : $(window).height()}, 0 ).show().animate({ top:0 }, options.transition_speed, function(){ afterAnimation(); });
	    		    break;
	    		case 3:    //Slide Right (reverse)
	    			nextslide.animate({left : -$(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 4:    //Slide Bottom (reverse)
	    			nextslide.animate({top : -$(window).height()}, 0 ).show().animate({ top:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 5:    //Slide Left (reverse)
	    			nextslide.animate({left : $(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
	    			break;
	    		case 6:    //Carousel Right (reverse)
	    			nextslide.animate({left : -$(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
					currentslide.animate({ left: $(window).width() }, options.transition_speed );
	    			break;
	    		case 7:    //Carousel Left (reverse)
	    			nextslide.animate({left : $(window).width()}, 0 ).show().animate({ left:0 }, options.transition_speed, function(){ afterAnimation(); });
					currentslide.animate({ left: -$(window).width() }, options.transition_speed );
	    			break;
	    	};

		}

		//After slide animation
		function afterAnimation() {

			inAnimation = false;

			//If hybrid mode is on swap back to higher image quality
			if (options.performance == 1){
		    	element.removeClass('speed').addClass('quality');
			}

			resizenow();

		}

	};

	
})(jQuery);