<?php
/**
 * Description: Header du site
 *
 * @package WordPress
 * @subpackage lelivresurlesquais 1.7.1
 * @since lelivresurlesquais 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, maximum-scale=1.0">
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Exo+2">
    <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri() . '/styles/styles.css?v=' . date("Ymd", filemtime(get_template_directory() . '/styles/styles.css')); ?>" />
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri() . '/images/favicons/apple-touch-icon.png'; ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri() . '/images/favicons/favicon-32x32.png'; ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri() . '/images/favicons/favicon-16x16.png'; ?>">
    <link rel="manifest" href="<?php echo get_template_directory_uri() . '/images/favicons/site.webmanifest'; ?>">
    <link rel="mask-icon" href="<?php echo get_template_directory_uri() . '/images/favicons/safari-pinned-tab.svg'; ?>" color="#003c56">
    <link rel="shortcut icon" href="<?php echo get_template_directory_uri() . '/images/favicons/favicon.ico'; ?>">
    <meta name="msapplication-TileColor" content="#003c56">
    <meta name="msapplication-config" content="<?php echo get_template_directory_uri() . '/images/favicons/browserconfig.xml'; ?>">
    <meta name="theme-color" content="#ffffff">
    <script src='https://www.google.com/recaptcha/api.js?hl=fr'></script>
    <script type="text/javascript" src="<?php echo get_template_directory_uri() . '/js/modernizr.js'; ?>"></script>
    <!--[if lt IE 9]><script src="<?php echo get_template_directory_uri() . '/js/html5.js'; ?>"></script><![endif]-->
    <?php wp_head(); ?>
    <script type="text/javascript" src="https://code.jquery.com/jquery-1.10.2.js"></script>
</head>
<body>
    <div id="outer-wrap">
        <div id="inner-wrap">
            <header class="header" id="top" role="banner">
                <div class="block">
                    <h2 class="block-title">Menu</h2>
                    <a class="nav-btn" id="nav-open-btn" href="#nav">Book Navigation</a>
                </div>
            </header>

            <header>
                <div class="container">
                    <div class="row">
                        <div class="col100">
                            <div class="mobile">
                                <img src="<?php echo get_template_directory_uri() . '/images/logo-2024.jpg?v=20240215'; ?>" alt="Le Livre sur les Quais, 1-2-3 septembre 2023 à Morges" width="540" height="100" />
                                <!-- Idéalement, mettre un logo long pour mobile <img src="<?php echo get_template_directory_uri() . '/images/logo-mobile-long-2023.svg?v=20230404'; ?>" alt="Le Livre sur les Quais, 1-2-3 septembre 2023 à Morges" width="540" height="100" />-->
                            </div>
                        </div>

                        <div class="col20 logo desktop">
                            <a href="/"><img src="<?php echo get_template_directory_uri() . '/images/logo-2024.jpg?v=20240215'; ?>" alt="Le Livre sur les Quais, 1-2-3 septembre 2023 à Morges" width="240" height="160"></a>
                        </div>

                        <div class="col50 blockMenu">
                            <nav id="nav" role="navigation">
                                <div class="logo mobile">
                                    <a href="/"><img src="<?php echo get_template_directory_uri() . '/images/logo-2024.jpg?v=20240215'; ?>" alt="Le Livre sur les Quais, 1-2-3 septembre 2023 à Morges" width="248" height="160"></a>
                                </div>

                                <ul class="mainMenu right">
                                    <?php
                                    $defaults = array(
                                        'theme_location'    => '',
                                        'menu'              => '',
                                        'container'         => 'ul',
                                        'container_class'   => 'mainMenu right',
                                        'container_id'      => '',
                                        'menu_class'        => '',
                                        'menu_id'           => '',
                                        'echo'              => true,
                                        'fallback_cb'       => 'wp_page_menu',
                                        'before'            => '',
                                        'after'             => '',
                                        'link_before'       => '',
                                        'link_after'        => '',
                                        'items_wrap'        => '%3$s',
                                        'depth'             => 1,
                                        'walker'            => ''
                                    );

                                    wp_nav_menu( $defaults );
                                    ?>
                                </ul>

                                <a id="nav-close-btn" href="#top"></a>
                            </nav>
                            <?php if(get_field('extra_menu_link', 'option')): ?>
                                <a 
                                    style="color: <?php the_field('extra_menu_color', 'option'); ?>; border-color: <?php the_field('extra_menu_color', 'option'); ?>" 
                                    href="<?php the_field('extra_menu_link', 'option'); ?>" 
                                    class="info-menu">
                                        <?php the_field('extra_menu_text', 'option'); ?>
                                </a>
                            <?php endif; ?>
                        </div>

                        <div class="col30 social desktop tablet">
                            <p>
                                <a href="/newsletter">Newsletter</a>
                                <a href="https://www.facebook.com/pages/Le-livre-sur-les-quais/167942109918713" target="_blank">Facebook</a>
                                <a href="https://www.youtube.com/@lelivresurlesquais_Morges" target="_blank">YouTube</a>
                                <!--<a href="/blog">Blog</a>-->
                                <a href="https://twitter.com/LivreSurQuais" target="_blank">Twitter</a>
                                <a href="https://www.instagram.com/lelivresurlesquais" target="_blank">Instagram</a>
                                <a href="https://www.linkedin.com/company/lelivresurlesquais/?originalSubdomain=ch" target="_blank">LinkedIn</a>
                            </p>

                            <!-- Cacher remporairement la "vague"<a href="/"><img src="<?php echo get_template_directory_uri() . '/images/14e-edition.svg?v=20230404'; ?>" alt="Le Livre Sur les Quais" width="467" height="215"></a>-->
                        </div>
                    </div>
                </div>
            </header>
