<?php
/**
 * Description: Fonctions du thème
 *
 * Auteur   Sébastien Chevalley
 * Date     Janvier 2011
 *
 * Auteur   Felipe Roy, Olivier Mülhauser, Luc Poupard
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
  == Divers
  == lelivresurlesquais_setup
  == watchTermEditWp
  == watchTermRemoveWp
  == llq_auteurLinks
  == llq_auteurControls
    -- creerLienDedicace
  == llq_joursPresenceAuteur
  == llq_auteurList
  == llq_auteurPreviewList
  == llq_auteurLightList
  == llq_listeEvenement
    -- generateEventBox
  == llq_listeEvenementSidebar
  == llq_orderbyReplace
  == generateEventBox2013
  == llq_listeEvenement2013
  == llq_listeEvenementSidebar2013
  == llq_evenementCode
  == llq_formatUrl
  == llq_menuSidebar
  == llq_menuSidebarShortcode
  == llq_logo
  == llq_logoShortcode
  == llq_afficherBarreProgramme
  == llq_afficherBarreProgrammeBackup
  == mv_is_subpage
  == include commonFunctions.php
  == Current jQuery
  == Custom Post Types and Taxonomies
    -- Réservations d'hôtels
    -- Auteurs
    -- Petits-déjeuners
    -- Évènements
    -- Logos
    -- Espace presse
    -- Invités
  == ACF register_field_group
  == Sidebars
  == Sous-menu contextuel
  == Format de date
  == Affichage du programme
  == Personnalisation admin
    -- Menu
    -- Dashboard
    -- Barre d'admin
    -- Rôle dédicaces
    -- ACF : Options
    -- Notifications de mise à jour
  == Personnalisation front
    -- Grand ménage dans <head>
    -- Version WP
    -- Contact Form 7
  == Event Espresso Custom Templates
*/


/* == @section Divers ==================== */
// add_action( 'widgets_init', 'lelivresurlesquais_setup_widget_area' ); fro: use register_sidebar instead of lelivresurlesquais_setup_widget_area

// HTML Dans les description de taxonomies…
// source : http://docs.appthemes.com/tutorials/allow-html-in-wordpress-category-taxonomy-descriptions/
remove_filter( 'term_description', 'wp_kses_data' );
remove_filter( 'pre_term_description', 'wp_filter_kses' );


/* == @section lelivresurlesquais_setup ==================== */
// ------------------------------------------------------------------
// Actions à effectuer pour activer convenablement le tème. (1/2)
// L'activation des miniatures de posts, dimensions des miniatures
// à générer et enregistrement de la barre de navigation principale
// ------------------------------------------------------------------
function lelivresurlesquais_setup() {
    // ------------------------------------------------------------------
    // VARIABLE DE CONFIGURATIONS
    // ------------------------------------------------------------------
    define( 'YEAR', 2023);
    define( 'DAY_ONE', 1); // Premier jour de l'évènement

    // Dimension des images : page d'accueil
    define( 'MINIATURE_HOMEPAGE_LARGEUR', 229 );
    define( 'MINIATURE_HOMEPAGE_HAUTEUR', 250 );

    // Dimension des images : auteurs
    define( 'MINIATURE_AUTEUR_SLIDER_LARGEUR', 800 );
    define( 'MINIATURE_AUTEUR_SLIDER_HAUTEUR', 500 );

    // Dimension des images : auteurs miniature
    define( 'MINIATURE_AUTEUR_THUMB_LARGEUR', 0 );
    define( 'MINIATURE_AUTEUR_THUMB_HAUTEUR', 75 );

    // Dimension des images : page 50%/50%
    define( 'MINIATURE_PAGE_50_LARGEUR', 256 );
    define( 'MINIATURE_PAGE_50_HAUTEUR', 9999 );

    // Dimension des images : logo
    define( 'MINIATURE_LOGO_LARGEUR', 9999 );
    define( 'MINIATURE_LOGO_HAUTEUR', 35 );

    // Dimension des images : logo 2013
    define( 'MINIATURE_LOGO2013_LARGEUR', 160 );
    define( 'MINIATURE_LOGO2013_HAUTEUR', 160 );

    // Dimension des images : auteur
    define( 'MINIATURE_AUTEUR_PHOTO_LARGEUR', 200 );
    define( 'MINIATURE_AUTEUR_PHOTO_HAUTEUR', 9999 );

    // Dimension des images : slider
    define( 'MINIATURE_SLIDER_LARGEUR', 475 );
    define( 'MINIATURE_SLIDER_HAUTEUR', 300 );

    // Dimension des images : site mobile
    define( 'MINIATURE_MOBILE_LARGEUR', 99999 );
    define( 'MINIATURE_MOBILE_HAUTEUR', 500 );

    // ------------------------------------------------------------------
    // MINIATURE DE PAGES/ARTICLES
    //
    // Activation du support de la création de miniatures pour les
    // contenus générés via Wordpress (les pages, articles, auteurs,
    // sponsors). Ce champ est utilisé pour stocker les images
    // utilisés sur la page d'accueil, sur le défilement animé des
    // auteurs.
    // ------------------------------------------------------------------

    // On ajoute le support des miniatures de posts
    if( function_exists( 'add_theme_support' ) )
    add_theme_support( 'post-thumbnails' );

    // Les différentes tailles de miniatures
    if( function_exists( 'add_image_size' ) ) {
        // add_image_size(
        //  'homepage-thumb',
        //  MINIATURE_HOMEPAGE_LARGEUR,
        //  MINIATURE_HOMEPAGE_HAUTEUR,
        //  true
        // );
        add_image_size(
            'auteur',
            MINIATURE_AUTEUR_PHOTO_LARGEUR,
            MINIATURE_AUTEUR_PHOTO_HAUTEUR
        );
        add_image_size(
            'page-thumb',
            MINIATURE_PAGE_50_LARGEUR,
            MINIATURE_PAGE_50_HAUTEUR
        );
        // add_image_size(
        //  'logo',
        //  MINIATURE_LOGO_LARGEUR,
        //  MINIATURE_LOGO_HAUTEUR
        // );
        add_image_size(
            'logo2013',
            MINIATURE_LOGO2013_LARGEUR,
            MINIATURE_LOGO2013_HAUTEUR
        );
        add_image_size(
            'homepage-slider',
            MINIATURE_SLIDER_LARGEUR,
            MINIATURE_SLIDER_HAUTEUR,
            false
        );
        add_image_size(
            'mobile',
            MINIATURE_MOBILE_LARGEUR,
            MINIATURE_MOBILE_HAUTEUR,
            false
        );
    }

    // ------------------------------------------------------------------
    // NAVIGATION
    //
    // Activation d'un menu de navigation pour le haut de la page. Pour
    // afficher le menu, il faut utiliser cette fonction :
    // wp_nav_menu(array( 'container_class' => 'menu-header', 'theme_location' => 'navigation_principale' ));
    // ------------------------------------------------------------------
    if ( function_exists( 'register_nav_menu' ) ) {
        register_nav_menu( 'navigation_principale', 'Menu de navigation du haut de la page' );
        register_nav_menu( 'navigation_horizontale', 'Menu de navigation horizontale' );
    }

    // ------------------------------------------------------------------
    // ADMIN BAR
    //
    // Avec la version 3.1 de Wordpress, une barre d'administration est
    // apparue sur le site front-end qui peut causer des problèmes avec
    // supersize
    // ------------------------------------------------------------------
    // wp_deregister_script( 'admin-bar' );
    // wp_deregister_style( 'admin-bar' );
    // remove_action( 'wp_footer', 'wp_admin_bar_render', 1000 );
    // add_filter( 'show_admin_bar', '__return_false' );

    remove_filter( 'the_content', 'wptexturize' );

    add_action( 'set_object_terms', 'watchTermEditWp', 10, 6 );
    add_action( 'deleted_term_relationships', 'watchTermRemoveWp', 10, 2 );

    /*
     * On gère la balise <title> dans WordPress et pas dans le thème.
     */
    add_theme_support( 'title-tag' );
}
add_action( 'after_setup_theme', 'lelivresurlesquais_setup' );


/* == @section watchTermEditWp ==================== */
/**
 * Filtre pour attraper les modifications de taxonomies
 * @param int    $object_id  Object ID.
 * @param array  $terms      An array of object terms.
 * @param array  $tt_ids     An array of term taxonomy IDs.
 * @param string $taxonomy   Taxonomy slug.
 * @param bool   $append     Whether to append new terms to the old terms.
 * @param array  $old_tt_ids Old array of term taxonomy IDs.
 */
function watchTermEditWp( $object_id, $terms, $tt_ids, $taxonomy, $append, $old_tt_ids ) {
    if( $taxonomy == 'annee-auteurs' ) {
        $currentUser = wp_get_current_user();

        $log = json_encode(
            array(
                'object_id'     => $object_id,
                'terms'         => $terms,
                'tt_ids'        => $tt_ids,
                'taxonomy'      => $taxonomy,
                'append'        => $append,
                'old_tt_ids'    => $old_tt_ids
            ),
            JSON_PRETTY_PRINT
        );

        file_put_contents( ABSPATH . '/tools/logs/logBug', '[' . strftime( '%d/%m/%Y %H:%M' ) . '][' . $currentUser->user_login . '] watchTermEditWp' . PHP_EOL . $log . PHP_EOL, FILE_APPEND );
    }
}


/* == @section watchTermRemoveWp ==================== */
/**
 * Filtre pour attraper les suppression de relations
 * @param int   $object_id Object ID.
 * @param array $tt_ids    An array of term taxonomy IDs.
 */
function watchTermRemoveWp( $object_id, $tt_ids ) {
    $currentUser = wp_get_current_user();

    $log = json_encode(
        array(
            'object_id' => $object_id,
            'tt_ids'    => $tt_ids
        ),
        JSON_PRETTY_PRINT
    );

    file_put_contents( ABSPATH . '/tools/logs/logBug', '[' . strftime( '%d/%m/%Y %H:%M' ) . '][' . $currentUser->user_login . '] watchTermRemoveWp' . PHP_EOL . $log . PHP_EOL, FILE_APPEND );
}


/* == @section llq_auteurLinks ==================== */
function llq_auteurLinks() {
    global $post;

    if( get_field( 'liens_auteur' ) ) {
        echo '<div class="liens_auteurs">';

        while( has_sub_field( 'liens_auteur' ) ) {
            $type = array(
                "blog"              => "Blog de l'auteur·trice ",
                "site"              => "Site de l'auteur·trice ",
                "dernier_ouvrage"   => "Dernier ouvrage paru",
                "twitter"           => "Suivre sur Twitter",
                "facebook"          => "Facebook",
                "wikipedia"         => "Page Wikipédia"
            );

            $link_title = get_sub_field( 'link_title' );
            if( !empty( $link_title ) )
            $label = get_sub_field( 'link_title' );
            else {
                if( in_array( get_sub_field( 'type' ), array_keys( $type ) ) )
                $label = $type[get_sub_field( 'type' )];
                else
                $label = get_sub_field( 'type' );
            }

            printf( '<p><a href="%s" target="_blank">%s</a></p>', get_sub_field( 'link' ), $label );
        }

        echo '</div>';
    }
}


/* == @section llq_auteurControls ==================== */
function llq_auteurControls( $customFields = '', $exclude = '' ) {
    global $post;

    $args = array(
        'pagename'  => 'auteurs-2012'
    );

    if( empty( $exclude ) )
    $exclude = array();

    query_posts( $args );


    /* -- @subsection creerLienDedicace -------------------- */
    function creerLienDedicace( $content = '', $label = '' ) {
        if( !empty( $content ) )
        echo '<li class="link"><a href="', $content, '" class="blue-box">', $label, '</a></li>';
    }

    if ( have_posts() ) : while ( have_posts() ) : the_post();
    $id = get_the_ID();

    $classCSS = array();
    $customFields = array();

    $customFields = get_post_custom();

    $vendredi = '';
    $samedi = '';
    $dimanche = '';

    if( get_field( 'fichier_dedicace' ) )
    $dedicace = get_field( 'fichier_dedicace' );

    endwhile; endif;
    wp_reset_query();

    ob_start();
    ?>

    <div class="control_column">
        <ul>
            <!--<li class="info margin-separator">Cliquer ci-dessous pour trier les auteurs</li>-->
            <li class="title">En dédicace</li>
            <li class="filter" title="vendredi">Vendredi</li>
            <li class="filter" title="samedi">Samedi</li>
            <li class="filter margin-separator" title="dimanche">Dimanche</li>
            <?php
            $categorieAuteur = get_terms( 'categories-auteurs', array( 'exclude' => $exclude, 'hide_empty' => 0 ) );

            if( isset( $categorieAuteur ) && is_array( $categorieAuteur ) ) {
                for( $i = 0; $i < count( $categorieAuteur ); $i++ ) {
                    $marginExtra = ( $i == count( $categorieAuteur ) - 1 ) ? ' margin-extra' : '';
                    printf( '<li class="filter%s" title="%s">%s</li>', $marginExtra, $categorieAuteur[$i]->slug, $categorieAuteur[$i]->name );
                }
            }
            ?>

            <?php creerLienDedicace( $dedicace, 'Horaires dédicaces' ); ?>
        </ul>
    </div>

    <?php
    $sidebar = ob_get_contents();
    ob_end_clean();

    return $sidebar;
}


/* == @section llq_joursPresenceAuteur ==================== */
/*
 * Nouvelle manière de récupérer les jours de présence d'un auteur,
 * plus long mais plus fiable : parcourir son programme et enregistrer
 * ses jours de présence
 */
function llq_joursPresenceAuteur( $id ) {
    $curlSession = curl_init();
    curl_setopt( $curlSession, CURLOPT_URL, get_site_url() . '/api.php?act=programmeAuteur&auteurId=' . $id );
    curl_setopt( $curlSession, CURLOPT_BINARYTRANSFER, true );
    curl_setopt( $curlSession, CURLOPT_RETURNTRANSFER, true );

    $programmeParAuteur = json_decode( curl_exec( $curlSession ), true );
    curl_close( $curlSession );

    if(
        is_array( $programmeParAuteur )
        && array_key_exists( 'dedicaces', $programmeParAuteur )
        && array_key_exists( 'programme', $programmeParAuteur )
    ) {
        date_default_timezone_set( 'UTC' );
        setlocale ( LC_ALL, "fr_FR" );
        $jours = array();

        if( count( $programmeParAuteur['dedicaces'] ) > 0 ) {
            foreach( $programmeParAuteur['dedicaces'] as $event ) {
                $jours[strftime( '%A', $event['debut'] )] = true;
            }
        }

        if( count( $programmeParAuteur['programme'] ) > 0 ) {
            foreach( $programmeParAuteur['programme'] as $event ) {
                $jours[strftime( '%A', $event['heureDebut'] )] = true;
            }
        }

        // on récupère les clés du tableau pour n'avoir que les jours
        return array_keys( $jours );
    } else {
        return array();
    }
}


/* == @section llq_auteurList ==================== */
function llq_auteurList($annee = '') {
    ob_start();

    if( empty( $annee ) )
    $annee = 2023;

    $args = array(
        'post_type' => 'auteur',
        'nopaging'  => true,
        'orderby'   => 'meta_value',
        'meta_key'  => 'Nom',
        'order'     => 'ASC',
        'tax_query' => array(
            'relation'  => 'AND',
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => $annee
            ),
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => 'special',
                'operator'  => 'NOT IN'
            )
        )
    );

    query_posts($args);

    $i = 0;
    $auteurs = array();

    if ( have_posts() ) : while ( have_posts() ) : the_post();
    $id = get_the_ID();

    if( $id === 21053 )
    continue;

    $classCSS = array();
    $customFields = array();

    $customFields = get_post_custom();

    /*
    if( !empty( $customFields['Jour de présence'] ) ) {
        foreach( $customFields['Jour de présence'] as $jour ) {
            $classCSS[] = $jour;
        }
    }
    */
    if( is_array( get_field( 'jours_presence' ) ) && count( get_field( 'jours_presence' ) ) > 0 )
    $classCSS = get_field( 'jours_presence' );

    $classCSS = llq_joursPresenceAuteur( $id );

    $lieux = get_the_terms( $id, 'categories-auteurs' );
    if( is_array( $lieux ) && count( $lieux ) > 0) {
        foreach( $lieux as $lieu ) {
            $classCSS[] = $lieu->slug;
        }
    }

    remove_filter( 'the_title', 'wptexturize' );
    $nom = get_the_title( $id );
    $nom = wp_specialchars_decode( $nom, ENT_QUOTES );
    $nom = str_replace(array( '’', '’' ), array( '\'', '\'' ), $nom );
    $nom = preg_replace( "#’#ui", "'", $nom );

    $customFields['Nom'][0] = wp_specialchars_decode( $customFields['Nom'][0], ENT_QUOTES );
    $customFields['Nom'][0] = preg_replace( "#’#ui", "'", $customFields['Nom'][0] );

    // d’Ormesson
    // d’Ormesson
    if( !empty( $customFields['Nom'][0] ) ) {
        /*
        $nom = str_replace(
            $customFields['Nom'][0],
            '<strong>' . $customFields['Nom'][0] . '</strong>',
            $nom
        );
        */
        $nom = str_replace( '(' . html_entity_decode( $customFields['Nom'][0], ENT_COMPAT, 'UTF-8' ) . ')', '<strong>\1</strong>', $nom );
    }

    $auteurs_html = sprintf( '<span class="%s"><a href="%s" name="%u">%s</a></span>', implode( ' ', $classCSS ), get_permalink(), $id, $nom );

    $auteurs[] = array( 'html' => $auteurs_html, 'nom' => $customFields['Nom'][0] );
    endwhile; endif;

    $nom_temp = array();

    // Obtain a list of columns
    foreach ( $auteurs as $key => $auteur ) {
        $html[$key]  = $auteur['html'];

        // $nom_temp[$key] = str_replace( 'de ', '', strtolower( $auteur['nom'] ) );
        $nom_temp[$key] = preg_replace( "#(de |di |d'|del |des )#ui", '', strtolower( $auteur['nom'] ) );
        $nom_temp[$key] = mb_strtolower( $auteur['nom'] );
        $nom_temp[$key] = str_replace(
            array('à','á','â','ã','ä','ç','è','é','ê','ë','ì','í','î','ï','ñ','ò','ó','ô','õ','ö','ù','ú','û','ü','ý','ÿ','À','Á','Â','Ã','Ä','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ñ','Ò','Ó','Ô','Õ','Ö','Ù','Ú','Û','Ü','Ý'),
            array('a','a','a','a','a','c','e','e','e','e','i','i','i','i','n','o','o','o','o','o','u','u','u','u','y','y','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N','O','O','O','O','O','U','U','U','U','Y'),
            $nom_temp[$key]
        );
        // $nom_temp[$key] = str_replace( 'd’', '', strtolower($auteur['nom'] ) );
        // $nom_temp[$key] = str_replace( 'd\'', '', strtolower($auteur['nom'] ) );
    }

    // Sort the data with volume descending, edition ascending
    // Add $data as the last parameter, to sort by the common key
    if( is_array( $auteurs ) && count( $auteurs ) > 0) {
        array_multisort( $nom_temp, SORT_STRING, $auteurs );
        $lettre_courante = '';

        if( count( $auteurs ) > 0 ) {
            // print_r( $auteurs );
            $columnCount = 3;
            $recordPerColumn = ( int ) ceil( count( $auteurs ) / $columnCount );
            // var_dump($recordPerColumn);

            echo '<div class="authors_column">';

            for( $i = 0; $i <= count( $auteurs ); $i++ ) {
                if( $i % $recordPerColumn == 0 && $i != 0 )
                echo '</div><div class="authors_column">';

                if( $lettre_courante != $nom_temp[$i][0] ) {
                    $lettre_courante = $nom_temp[$i][0];
                    echo' <span class="lettre">', $lettre_courante, '</span>';
                }
                echo $auteurs[$i]['html'];
            }

            echo '</div>';
        }
    }

    wp_reset_query();
    ?>
    <div class="clear"></div>
    <?php
    $list = ob_get_contents();
    ob_end_clean();

    return $list;
}


/* == @section lq_auteurPreviewList ==================== */
function llq_auteurPreviewList( $annee = '', $searchTxt = '', $categorieAuteur = -1 ) {
    ob_start();

    if( empty( $annee ) )
    $annee = 2023;

    $args = array(
        'post_type' => 'auteur',
        'nopaging'  => true,
        'orderby'   => 'meta_value',
        'meta_key'  => 'Nom',
        'order'     => 'ASC',
        'tax_query' => array(
            'relation'  => 'AND',
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => $annee
            ),
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => 'special',
                'operator'  => 'NOT IN'
            )
        )
    );

    query_posts($args);

    $i = 0;
    $auteurs = array();

    if ( have_posts() ) : while ( have_posts() ) : the_post();
    $id = get_the_ID();

    if( $id === 21053 )
    continue;

    $classCSS = array();

    $nomField = get_field( 'Nom' );

    remove_filter( 'the_title', 'wptexturize' );
    $nom = get_the_title( $id );
    $nom = wp_specialchars_decode( $nom, ENT_QUOTES );
    $nom = str_replace( array( '’', '’' ), array( '\'', '\'' ), $nom );
    $nom = preg_replace( "#’#ui", "'", $nom );

    $nomField = wp_specialchars_decode( $nomField, ENT_QUOTES );
    $nomField = preg_replace( "#’#ui", "'", $nomField );

    $post_thumbnail_id = get_post_thumbnail_id( $post->ID );
    $post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );

    if( $searchTxt != '' ) {
        if( strpos( strtoupper( $nom ),strtoupper( $searchTxt ) ) === false ) {
            continue;
        }
    }

    if( $categorieAuteur != "" && $categorieAuteur != "-1" ) {
        $term_list = wp_get_post_terms( $id, 'categories-auteurs', array( "fields" => "all" ) );

        if ( $term_list==null )
        continue;

        $hasCategory = false;
        foreach ( $term_list as $key => $val ) {
            if( $val->slug == $categorieAuteur )
            $hasCategory = true;
        }

        if ( !$hasCategory )
        continue;
    }

    if( !empty( $nomField ) ) {
        $nom = str_replace( '(' . html_entity_decode( $nomField, ENT_COMPAT, 'UTF-8' ) . ')', '<strong>\1</strong>', $nom );
    }

    $auteurs_html = sprintf( '<div class="thumbnail"><a href="%s" name="%u"><img src="%s" /><div class="thumbAuthorName">%s</div></a></div>', get_permalink(), $id, $post_thumbnail_url, $nom );

    $auteurs[] = array( 'html' => $auteurs_html, 'nom' => $nomField );
    endwhile; endif;

    $nom_temp = array();

    // Obtain a list of columns
    foreach ( $auteurs as $key => $auteur ) {
        $html[$key]  = $auteur['html'];
        $nom_temp[$key] = preg_replace( "#(de |di |d'|del |des )#ui", '', strtolower( $auteur['nom'] ) );
        $nom_temp[$key] = mb_strtolower( $auteur['nom'] );
        $nom_temp[$key] = str_replace(
            array('à','á','â','ã','ä','ç','è','é','ê','ë','ì','í','î','ï','ñ','ò','ó','ô','õ','ö','ù','ú','û','ü','ý','ÿ','À','Á','Â','Ã','Ä','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ñ','Ò','Ó','Ô','Õ','Ö','Ù','Ú','Û','Ü','Ý'),
            array('a','a','a','a','a','c','e','e','e','e','i','i','i','i','n','o','o','o','o','o','u','u','u','u','y','y','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N','O','O','O','O','O','U','U','U','U','Y'),
            $nom_temp[$key]
        );
    }

    // Sort the data with volume descending, edition ascending
    // Add $data as the last parameter, to sort by the common key
    if( is_array( $auteurs ) && count( $auteurs ) > 0 ) {
        array_multisort( $nom_temp, SORT_STRING, $auteurs );
        $lettre_courante = '';

        if (count( $auteurs ) > 0 ) {
            //print_r($auteurs);
            $columnCount = 3;
            $recordPerColumn = ( int ) ceil( count( $auteurs ) / $columnCount );
            //var_dump($recordPerColumn);

            echo '<div class="authors_column">';

            for( $i = 0; $i <= count( $auteurs ); $i++ ) {
                if( $i % $recordPerColumn == 0 && $i != 0 )

                echo '</div><div class="authors_column">';

                if( $lettre_courante != $nom_temp[$i][0] ) {
                    $lettre_courante = $nom_temp[$i][0];
                    echo' <span class="lettre">', $lettre_courante, '</span>';
                }
                echo $auteurs[$i]['html'];
            }

            echo '</div>';
        }
    }

    wp_reset_query();
    ?>
    <div class="clear"></div>
    <?php
    $list = ob_get_contents();
    ob_end_clean();

    return $list;
}


/* == @section llq_auteurLightList ==================== */
function llq_auteurLightList( $annee = '' ) {
    ob_start();

    if( empty( $annee ) )
    $annee = 2023;

    $args = array(
        'post_type' => 'auteur',
        'nopaging'  => true,
        'orderby'   => 'meta_value',
        'meta_key'  => 'Nom',
        'order'     => 'ASC',
        'tax_query' => array(
            'relation'  => 'AND',
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => $annee
            ),
            array(
                'taxonomy'  => 'annee-auteurs',
                'field'     => 'slug',
                'terms'     => 'special',
                'operator'  => 'NOT IN'
            )
        )
    );

    query_posts( $args );

    $i = 0;
    $auteurs = array();

    if ( have_posts() ) : while ( have_posts() ) : the_post();
    $id = get_the_ID();

    if( $id === 21053 )
    continue;

    $classCSS = array();

    $nomField = get_field( 'Nom' );

    remove_filter( 'the_title', 'wptexturize' );
    $nom = get_the_title( $id );
    $nom = wp_specialchars_decode( $nom, ENT_QUOTES );
    $nom = str_replace( array( '’', '’' ), array( '\'', '\'' ), $nom );
    $nom = preg_replace( "#’#ui", "'", $nom );

    $nomField = wp_specialchars_decode( $nomField, ENT_QUOTES );
    $nomField = preg_replace( "#’#ui", "'", $nomField );


    if( !empty( $nomField ) ) {
        $nom = str_replace( '(' . html_entity_decode( $nomField, ENT_COMPAT, 'UTF-8' ) . ')', '<strong>\1</strong>', $nom );
    }

    $auteurs_html = sprintf( '<span ><a href="%s" name="%u">%s</a></span>', get_permalink(), $id, $nom );

    $auteurs[] = array( 'html' => $auteurs_html, 'nom' => $nomField );
    //echo $auteurs_html, '<br/>';
    endwhile; endif;

    $nom_temp = array();

    // Obtain a list of columns
    foreach ( $auteurs as $key => $auteur ) {
        $html[$key]  = $auteur['html'];
        $nom_temp[$key] = preg_replace( "#(de |di |d'|del |des )#ui", '', strtolower( $auteur['nom'] ) );
        $nom_temp[$key] = mb_strtolower( $auteur['nom'] );
        $nom_temp[$key] = str_replace(
            array('à','á','â','ã','ä','ç','è','é','ê','ë','ì','í','î','ï','ñ','ò','ó','ô','õ','ö','ù','ú','û','ü','ý','ÿ','À','Á','Â','Ã','Ä','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ñ','Ò','Ó','Ô','Õ','Ö','Ù','Ú','Û','Ü','Ý'),
            array('a','a','a','a','a','c','e','e','e','e','i','i','i','i','n','o','o','o','o','o','u','u','u','u','y','y','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N','O','O','O','O','O','U','U','U','U','Y'),
            $nom_temp[$key]
        );
    }

    // Sort the data with volume descending, edition ascending
    // Add $data as the last parameter, to sort by the common key
    if(is_array( $auteurs ) && count( $auteurs ) > 0 ) {
        array_multisort( $nom_temp, SORT_STRING, $auteurs );
        $lettre_courante = '';

        if( count( $auteurs ) > 0 ) {
            //print_r($auteurs);
            $columnCount = 3;
            $recordPerColumn = ( int ) ceil( count( $auteurs ) / $columnCount );
            //var_dump($recordPerColumn);

            echo '<div class="authors_column">';

            for( $i = 0; $i <= count( $auteurs ); $i++ ) {
                if( $i % $recordPerColumn == 0 && $i != 0 )
                echo '</div><div class="authors_column">';
                if( $lettre_courante != $nom_temp[$i][0] ) {
                    $lettre_courante = $nom_temp[$i][0];
                    echo' <span class="lettre">', $lettre_courante, '</span>';
                }
                echo $auteurs[$i]['html'];
            }

            echo '</div>';
        }
    }

    wp_reset_query();
    ?>
    <div class="clear"></div>
    <?php
    $list = ob_get_contents();
    ob_end_clean();

    return $list;
}


/* == @section llq_listeEvenement ==================== */
function llq_listeEvenement( $type = '', $jour = '', $annee = '', $croisiere = false, $disableNav = false ) {
    global $post;

    if( empty( $annee ) )
    $annee = date( 'Y' );

    $lang = ( $type == 'anglais' ) ? 'en' : 'fr';
    $lang = ( $type == 'cinema' ) ? 'ci' : $lang;
    $lang = ( $type == 'lectures' ) ? 'lt' : $lang;

    ob_start();

    $args = array(
        'post_type' => 'evenement',
        'nopaging'  => true
    );

    if( !empty( $annee ) ) {
        $args['tax_query'][] = array(
            'taxonomy'  => 'annee-evenement',
            'terms'     => array( $annee ),
            'field'     => 'slug'
        );
    }

    if( !empty( $type ) ) {
        $args['tax_query'][] = array(
            'taxonomy'  => 'type-evenement',
            'terms'     => array( $type ),
            'field'     => 'slug'
        );
    }

    if( !empty( $jour ) ) {
        $args['tax_query'][] =  array(
            'taxonomy'  => 'jour-evenement',
            'terms'     => array( strtolower( $jour ) ),
            'field'     => 'slug'
        );
    } else {
        $nav = true;
    }

    query_posts($args);

    $i = 0;
    $jours = array();

    if ( have_posts() ) : while ( have_posts() ) : the_post();
    $post->custom_field = get_post_custom();

    $timestamp = $post->custom_field['Heure'][0];
    $timestamp = str_replace( array( 'h', ' h', ' h', ' h ' ), 'h', $timestamp );
    $timestamp = trim( $timestamp );

    $first_part = explode( '-', $timestamp );

    if( substr( $timestamp, -1, 1 ) == 'h' )
    $timestamp .= '00';
    elseif( count( $first_part ) == 2 ) {
        if( substr( $first_part[0], -1, 1 ) == 'h' )
        $timestamp = $first_part[0] . '00';
    }

    $timestamp = explode( 'h', $timestamp );
    $timestamp = mktime( ( int ) $timestamp[0], ( int ) $timestamp[1], 1, 1, 1, 2011 );

    ob_start();
    the_content();
    $post->content_text = ob_get_contents();
    ob_end_clean();
    //$post->content_text = get_the_content();
    $post->timestamp = $timestamp;

    $id = get_the_ID();

    unset( $jour_temp );
    $jour_temp = get_the_terms( $id, 'jour-evenement' );

    $jour_temp = current( $jour_temp );

    if( !array_key_exists( $jour_temp->term_id, $jours ) )
    $jours[$jour_temp->term_id] = $jour_temp;

    $post->jour = $jour_temp->slug;

    $event[$id] = $post;

    $event_tri[$id] = $timestamp;

    $i++;
    endwhile; endif;

    wp_reset_query();


    /* -- @subsection generateEventBox -------------------- */
    function generateEventBox( $event_array, $event_tri, $lang = 'fr') {
        $locals['avec']['fr'] = 'Avec';
        $locals['avec']['lt'] = 'par';
        $locals['avec']['ci'] = 'Avec';
        $locals['avec']['en'] = 'With';
        $locals['presente_par']['fr'] = 'Animé par';
        $locals['presente_par']['lt'] = 'Animé par';
        $locals['presente_par']['ci'] = 'De';
        $locals['presente_par']['en'] = 'Presented by';

        /*ksort($event_array);*/
        asort( $event_tri, SORT_NUMERIC );

        $new_event = array();

        foreach( $event_tri as $id => $timestamp ) {
            $new_event[$id] = $event_array[$id];
        }

        $event_array = $new_event;

        if( !is_array( $event_array ) && count( $event_array ) == 0 )
        return false;

        foreach( $event_array as $timestamp => $event ) {
        $date = '&nbsp';
        $avec = '';
        $anime_par = '';
        $lieu = '&nbsp;';
        $lieuSlug = '';
        $lieuText = '';

        if( $event->custom_field['Afficher la date'][0] == 'oui' ) {
            $date = $event->custom_field['Heure'][0];
            $date = strtolower( $date );
            $date = str_replace( array( 'h', ' h', ' h', ' h ' ), 'h', $date );

            if( substr( $date, -1, 1 ) == 'h' )
            $date .= '00';
            elseif( preg_match( '#\h\-#', $date ) )
            $date = preg_replace( '#(\h)(\-)#', '${1}00${2}', $date );

            $date_explode = explode( 'h', $date );
            $event->timestamp_tri = mktime( $date_explode[0], $date_explode[1] );
        } else {
            $event->timestamp_tri = 0;
        }

        if( isset( $event->custom_field['Auteurs présents'] ) )
        $avec = sprintf( '<span class="avec">%s %s</span>', $locals['avec'][$lang], $event->custom_field['Auteurs présents'][0] );

        if( isset( $event->custom_field['Animé par'] ) )
        $anime_par = sprintf( '<span class="anime_par">%s %s</span>', $locals['presente_par'][$lang], $event->custom_field['Animé par'][0] );

        $lieux = get_the_terms( $event->ID, 'lieu-evenement' );
        if( is_array( $lieux ) && count( $lieux ) > 0) {
            foreach( $lieux as $lieu ) {
                $lieuText = $lieu->name;
                $lieuSlug = $lieu->slug;
            }
            //$lieu = $lieuText;
            $lieu = preg_replace( "#(.*)(\s+)\((.*)\)#U", '$1,$2<small>$3</small>', $lieuText );
        }

        $classCSS   = array();
        //$classCSS[] = $lieuSlug;
        $classCSS[] = $event->jour;
        //$classCSS[] = $event->timestamp_tri;
        $classCSS   = implode( ' ', $classCSS );

        printf( '<tr class="%s" title="%s"><td class="date">%s</td> <td class="title"><h3 class="fixed-width">%s</h3></td><td class="info"> %s %s %s</td><td class="lieu">%s</td></tr>', $classCSS, $event->timestamp_tri, $date, $event->post_title, $event->content_text, $avec, $anime_par, $lieu );
        }
    }

    if(count( $event ) && count( $event_tri ) ) {
        if( $nav && !$disableNav ) {
            llq_listeEvenementSidebar();
        }

        // On génère les en-têtes pour les jours
        echo '<table class="event_box hideJS" cellpadding="0" cellspacing="0">';
        generateEventBox( $event, $event_tri, $lang );
        echo '</table>';
    }
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}


/* == @section llq_listeEvenementSidebar ==================== */
function llq_listeEvenementSidebar() {
    $listeJour = get_terms( 'jour-evenement' );
    //var_dump($listeJour);

    if(is_array( $listeJour ) && !empty( $listeJour ) ) {
    echo '<ul class="listeJour hideJS">';

    foreach( $listeJour as $elementJour ) {
        printf( '<li class="elementJour" title="%s"><a href="javascript:void(0);" title="Cliquer pour afficher les événements du %s">%s</a></li>', $elementJour->slug, strtolower( $elementJour->name ), $elementJour->name );
    }
        echo '</ul>';
    }
}


/* == @section llq_orderbyReplace ==================== */
function llq_orderbyReplace( $orderby ) {
    return str_replace( 'menu_order', 'mt1.meta_value, mt2.meta_value', $orderby );
}


/* == @section generateEventBox2013 ==================== */
function generateEventBox2013( $event_array, $lang = 'fr' ) {
    $locals['avec']['fr'] = 'Avec';
    $locals['avec']['lt'] = 'par';
    $locals['avec']['ci'] = 'Avec';
    $locals['avec']['en'] = 'With';
    $locals['presente_par']['fr'] = 'Animé par';
    $locals['presente_par']['lt'] = 'Animé par';
    $locals['presente_par']['ci'] = 'De';
    $locals['presente_par']['en'] = 'Presented by';

    // ksort( $event_array );
    // asort( $event_tri, SORT_NUMERIC ;

    // $new_event = array();
    // foreach( $event_tri as $id => $timestamp ) {
    //  $new_event[$id] = $event_array[$id];
    // }
    // $event_array = $new_event;

    // print_r( $event_array );

    usort( $event_array, make_comparer( 'timestamp', 'typeOrder', 'lieuOrder' ) );

    if( !is_array( $event_array ) && count( $event_array ) == 0 )
    return false;

    $lastDate = "";
    $lastDatePerType = array();
    foreach( $event_array as $timestamp => $event ) {
        $event = ( object ) $event;

        $date = '';
        $avec = '';
        $anime_par = '';
        $lieu = '';
        $lieuSlug = '';
        $lieuText = '';
        $ponctuation = '';
        $informations_importantes = '';

        $usePunctuation = true;

        if( mb_strlen( trim( $event->post_title ) ) == 0 )
        $usePunctuation = false;
        elseif( !preg_match( "#[!?.]#", substr( $event->post_title, -1 ) ) ) {
            $ponctuation = '.';
            $usePunctuation = false;
        }
        else
        $ponctuation = substr( $event->post_title, -1 );

        if( true ) {
            $date = $event->custom_field['Heure'][0];
            $date = str_replace( ':', 'h', $event->heure2013 );
            $date_display = $date;

            /*
            $date = strtolower( $date );
            $date = str_replace( array( ' : ', ' :' , ':' , ':', 'h', ' h', ' h', ' h ' ), 'h', $date );
            $date = str_replace( '00', '', $date );

            if( substr( $date, -1, 1 ) == 'h' ) {
                // $date .= '00';
                $date_display = $date;
            } elseif(preg_match( '#-#', $date ) ) {
            // $date = preg_replace( '#(\h)(\-)#', '${1}00${2}', $date );
                $date_display = explode( '-', $date );
                $date_display = $date_display[0];
            }
            */

            $date_explode = explode( 'h', $date );

            $event->timestamp_tri = mktime( ( int ) $date_explode[0], ( int ) $date_explode[1] );
            $date = '<div class="date">' . $date_display . '</div>';

            if( $date_display == $lastDate ) {
                $date = '<div class="date alreadyDisplayed">' . $date_display . '</div>';
            } else {
                $lastDate = $date_display;
            }

            if( count( $event->typeEvent ) > 0 ) {
                foreach( $event->typeEvent as $eventType ) {
                    if( array_key_exists( $eventType, $lastDatePerType ) && $date_display == $lastDatePerType[$eventType] ) {
                        $date = '<div class="date alreadyDisplayed alreadyTypeDisplayed">' . $date_display . '</div>';
                    } else {
                        $lastDatePerType[$eventType] = $date_display;
                    }
                }
            }
        } else {
            $event->timestamp_tri = 0;
        }

        // if( isset( $event->custom_field['Auteurs présents'] ) )
        //$avec = sprintf( '<span class="avec">%s %s</span>', $locals['avec'][$lang], $event->custom_field['Auteurs présents'][0] );

        if( $event->avec && !empty( $event->avec ) )
        $avec = sprintf( '<span class="avec">%s %s</span>', $locals['avec'][$lang], $event->avec );

        if( $event->anime_par )
        $anime_par = sprintf( '<span class="anime_par">%s %s</span>', $locals['presente_par'][$lang], $event->anime_par );

        if( $event->informations_importantes )
        $informations_importantes = sprintf( '<span class="informations_importantes">%s</span>', $event->informations_importantes );

        $lieux = get_the_terms( $event->ID, 'lieu-evenement' );
        if( !empty( $event->lieuText ) ) {
            $lieu = '<div class="lieu">' . preg_replace( "#(.*)(\s+)\((.*)\)#U", '$1,$2<small>$3</small>', $event->lieuText ) . '</div>';
        }

        global $jourEvent;
        if( $jourEvent !=  $event->jour ) {
            $jourEvent = $event->jour;
            printf( '<div class="jourEvent" data-jour="%s">%s</div>', $event->jour, $event->jourTitle );
        }

        if( $usePunctuation )
        $event->post_title = mb_substr( $event->post_title, 0,-1 );

        printf(
            '<div data-jour="%s" data-type="%s" title="%s" class="e">%s %s<div class="title"> <h3 class="fixed-width">%s<span>%s</span></h3><div class="info">%s %s %s</div>%s</div></div>',
            $event->jour,
            implode( ' ', $event->typeEvent ),
            $event->timestamp,
            $date,
            $lieu,
            $event->post_title,
            $ponctuation,
            /*$event->content_text,*/
            $avec,
            $anime_par,
            $informations_importantes,
            '<div class="desc">' . $event->content_text . '</div>'
        );
    }
}


/* == @section llq_listeEvenement2013 ==================== */
function llq_listeEvenement2013( $type = '', $jour = '', $annee = '', $croisiere = false, $disableNav = false ) {
    global $post;

    if( empty( $annee ) )
    $annee = date( 'Y' );

    $lang = ( $type == 'anglais' ) ? 'en' : 'fr';
    $lang = ( $type == 'cinema' ) ? 'ci' : $lang;
    $lang = ( $type == 'lectures' ) ? 'lt' : $lang;

    ob_start();

    $args = array(
        'post_type'         => 'evenement',
        'posts_per_page'    => -1
    );

    if( !empty( $annee ) ) {
        $args['annee-evenement'] = ( string ) $annee;
    }

    if( !empty( $type ) ) {
        $args['tax_query'][] = array(
            'taxonomy'  => 'type-evenement',
            'terms'     => array($type),
            'field'     => 'slug'
        );
    } elseif( !empty( $post->typeEvent ) ) {
        $typesRequete = array();

        foreach( $post->typeEvent as $type ) {
            $typesRequete[] = $type->slug;
        }
        //var_dump($post->typeEvent);

        $args['tax_query'][] = array(
            'taxonomy'  => 'type-evenement',
            'terms'     => $typesRequete,
            'field'     => 'slug'
        );
    }

    if( !empty( $jour ) ) {
        $args['jour-evenement'] = strtolower( $jour );
    } else {
        $nav = true;
    }

    query_posts( $args );

    // global $wp_query;

    // echo $wp_query->request;
    // echo "<br>$wp_query->post_count";

    $i = 0;
    $jours = array();
    if ( have_posts() ) {
        while ( have_posts() ) {
            the_post();
            $post->custom_field = get_post_custom();
            $slugEvent = get_the_terms( $post->ID, 'type-evenement' );

            $post->typeEvent = array();
            if( count( $slugEvent ) > 0) {
                foreach( $slugEvent as $eventType ) {
                    $post->typeEvent[] = $eventType->slug;
                }
            }

            $heureDébut = get_field( 'heure_tri' );
            // $dayDelta;

            if( empty( $heureDébut ) ) {
                // Zone de temps pour écarter les bugs de timestamp
                date_default_timezone_set( 'UTC' );

                $heure2013 = get_field( 'heure_2013' );

                if( empty( $heure2013 ) ) {
                    echo 'continue heure';
                    continue;
                }

                $heure2013 = explode( ':', $heure2013 );

                $jours = wp_get_post_terms( $post->ID, 'jour-evenement' );

                if( count( $jours ) == 0 ) {
                    echo 'continue jour';
                    continue;
                }

                $jour = $jours[0]->slug;
                $dayDelta = 0;

                switch( $jour ) {
                    case 'samedi' :
                    $dayDelta = 1;
                    break;
                    case 'dimanche' :
                    $dayDelta = 2;
                    break;
                }

                $heureDébut = mktime( (int) $heure2013[0], ( int ) $heure2013[1], 0, 9, DAY_ONE + $dayDelta, YEAR );
            }

            ob_start();
            the_content();
            $post->content_text = ob_get_contents();
            ob_end_clean();
            //$post->content_text = get_the_content();

            $post->c = get_the_title();

            $id = get_the_ID();

            unset( $jour_temp );
            $jour_temp = get_the_terms( $id, 'jour-evenement' );

            $jour_temp = current( $jour_temp );

            if( !array_key_exists( $jour_temp->term_id, $jours ) )
            $jours[$jour_temp->term_id] = $jour_temp;

            $post->jour = $jour_temp->slug;
            //$post->jourTitle = $jour_temp->name;
            $post->jourTitle = $jour_temp->description;
            $post->timestamp = $heureDébut;

            $post->heure2013 = get_field( 'heure_2013' );

            $auteurs_presents = get_field( 'auteurs_presents' );
            $auteurs_presents_texte = get_field( 'auteurs_presents_texte' );
            $post->avec = trim( texteAuteursPrésents( $auteurs_presents_texte, $auteurs_presents ) );

            $post->anime_par = get_field( 'anime_par' );
            $post->informations_importantes = get_field( 'informations_importantes' );

            $lieux =  get_the_terms( $post->ID, 'lieu-evenement' );
            $types = get_the_terms( $post->ID, 'type-evenement' );

            if( is_array( $lieux ) && count( $lieux ) > 0 ) {
                $post->lieuText = $lieux[0]->name;
                $post->lieuOrder = $lieux[0]->tax_order;
            } else {
                $post->lieuText = '';
                $post->lieuxOrder = 0;
            }

            if( is_array( $types ) && count( $types ) > 0 ) {
                $post->typeOrder = $types[0]->tax_order;
            } else {
                $post->typeOrder = 0;
            }

            $event[] = (array) $post;
            // $event_tri[$id] = $timestamp;

            $i++;
        }
    }

    wp_reset_query();

    if( count( $event ) ) {
        if( $nav && !$disableNav ) {
            llq_listeEvenementSidebar2013();
        }

        generateEventBox2013( $event, $lang );
    }
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}


/* == @section llq_listeEvenementSidebar2013 ==================== */
function llq_listeEvenementSidebar2013( $typeToInclude = array(), $jourToInclude = array() ) {
    foreach( $typeToInclude as $type ) {
        $typeFinal[] = $type->term_id;
    }

    $args = array( 'include' => $jourToInclude );
    $listeJour = get_terms('jour-evenement', $args );
    $args = array( 'include' => $typeFinal );
    $listeType = get_terms( 'type-evenement', $args );
    //var_dump($listeJour);

    echo '<ul class="controlProgram">';

    if( is_array( $listeJour ) && !empty( $listeJour ) ) {
        foreach( $listeJour as $key =>  $elementJour ) {
            $last = '';
            if( $key == count( $listeJour ) - 1 )
            $last = 'last';

            printf( '<li class="filter jour %s" title="%s">%s</li>', $last, $elementJour->slug, ucfirst( $elementJour->slug ) );
        }
    }

    if( is_array( $listeType ) && !empty( $listeType ) ) {
        foreach( $listeType as $key => $elementType ) {
            $last = '';
            if( $key == count( $listeType ) - 1 )
            $last = 'last';

            printf( '<li class="filter %s type" title="%s">%s</li>', $last, $elementType->slug, $elementType->name );
        }
    }

    echo '</ul>';
}


/* == @section llq_evenementCode ==================== */
// [bartag foo="foo-value"]
function llq_evenementCode( $atts ) {
    extract( shortcode_atts( array(
        'type'  => '',
        'jour'  => '',
        'annee' => ''
    ), $atts ) );

    if( ( int ) $annee < 2013 )
    echo llq_listeEvenement( $type, $jour, $annee );
    else {
        if( empty( $jour ) )
        return sprintf(
            '',
            llq_listeEvenement2013( $type, '', $annee, false, true )
        );
    }
}
add_shortcode( 'evenement', 'llq_evenementCode' );


/* == @section llq_formatUrl ==================== */
function llq_formatUrl( $url, $text, $class = '' ) {
    return sprintf( '<a href="%s" class="%s">%s</a>', $url, $class, $text );
}


/* == @section llq_menuSidebar ==================== */
function llq_menuSidebar( $page = '', $addLastClass = true ) {
    if( empty( $page ) )
    return '';

    switch( $page ) {
        case 'Accueil2':
        $pageData = get_page_by_title( 'Accueil' );
        break;
        default:
        $pageData = get_page_by_title( $page );
        break;
    }

    if( is_null( $pageData ) )
    return '';

    $pagesForMenu = get_pages( array(
        'parent'        => $pageData->ID,
        'hierarchical'  => 0,
        'sort_column'   => 'menu_order'
    ) );

    if( !is_array( $pagesForMenu ) || count( $pagesForMenu ) == 0 )
    return '';

    $addLastClass = ( $addLastClass) ? '' : '';
    global $post;

    ob_start();
    if( $page == 'Accueil' ) {
        if( get_field( 'invites', 'options' ) ) {
            $guestMenu = array();
            $i = 0;
            while( has_sub_field( 'invites', 'options' ) ) {
                if( get_sub_field( 'url' ) ) {
                    $url = get_sub_field( 'url' );
                    $active = ( is_page( end( explode( '/', $url ) ) ) ) ? 'active' : '';

                    $guestMenu[$i]['label'] = llq_formatUrl($url, get_sub_field( 'label' ), $active);

                    $i++;
                }
            }

            for( $i = 0, $max = count( $guestMenu ); $i < $max; $i++ ) {
                $last = ( $i == $max - 1 ) ? 'last' : '';

                printf( '<p class="%s">%s</p>', $last, $guestMenu[$i]['label'] );
            }
        }
        ?>
        <!--
        <p><a class="<?php // if( is_page( 'presidente-dhonneur-tatiana-de-rosnay' ) ) echo 'active'; ?>" href=<?php // echo get_site_url(); ?>/presidente-dhonneur-tatiana-de-rosnay">Présidente d'honneur</a></p>
        <p><a class="<?php // if( is_page( 'invite-dhonneur-rhone-alpes' ) ) echo 'active'; ?>" href=<?php // echo get_site_url(); ?>/invite-dhonneur-rhone-alpes">Invité d'honneur</a></p>
        <p><a class="<?php // if( is_page( 'editeur-invite-les-editions-belfond' ) ) echo 'active'; ?>" href=<?php // echo get_site_url(); ?>/editeur-invite-les-editions-belfond">&Eacute;diteur invit&eacute;</a></p>
        <p class="last"><a class="<?php // if( is_page( 'descente-aux-plaisirs' ) ) echo 'active'; ?>" href=<?php // echo get_site_url(); ?>/programme/descente-aux-plaisirs">Spectacle d'ouverture</a></p>
        -->
        <?php
    }

    foreach( $pagesForMenu as $page ) {
        $active = ( $post->ID == $page->ID ) ? 'active' : '';
        $last = ( $page == end($pagesForMenu) ) ? 'last' : '';
        printf( '<p class="%s"><a href="%s" class="%s">%s</a></p>', $last, get_page_link($page->ID), $active, $page->post_title );
    }

    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}


/* == @section llq_menuSidebarShortcode ==================== */
function llq_menuSidebarShortcode( $atts ) {
    extract( shortcode_atts( array(
        'page'          => '',
        'addLastClass'  => true
    ), $atts) );

    return llq_menuSidebar( $page, $addLastClass );
}
add_shortcode( 'menu_sidebar', 'llq_menuSidebarShortcode' );


/* == @section llq_logo ==================== */
function llq_logo( $titre ) {}


/* == @section llq_logoShortcode ==================== */
function llq_logoShortcode( $atts ) {
    extract( shortcode_atts( array(
        'nom'   => ''
    ), $atts) );

    if( !empty( $titre ) );
    echo llq_logo( $titre );
}
add_shortcode( 'logo', 'llq_logoShortcode' );


/* == @section llq_afficherBarreProgramme ==================== */
function llq_afficherBarreProgramme( $programme, $noPlace ) {
    if( !get_field( 'enableProgrammeAuteur', 'options' ) )
    return '';

    $noPlace = ( $noPlace == false ) ? '' : $noPlace;
    if( $noPlace == 'b' )
    $noPlace = 'bateau';

    $noPlace = ( !empty( $noPlace ) ) ? sprintf( '<span class="noPlace">place n<sup>o</sup> : %s</span>', $noPlace ) : '';

    // Programme incomplet ou vide
    if(
        !array_key_exists( 'dedicaces', $programme )
        || !array_key_exists( 'programme', $programme )
        || (
            count( $programme['dedicaces'] ) == 0
            && count( $programme['programme'] ) == 0
        )
    )
    // return;

    $finalProgramme = array();

    foreach( $programme['programme'] as $event ) {
        $dayDelta = 0;
        $isOutOfEventDay = false;

        // switch( (int) date( 'j', $event['heureDebut'] ) ) {
        //     case DAY_ONE :
        //     case DAY_ONE + 1:
        //     case DAY_ONE + 2:
        //     $dayDelta = ( int ) date( 'j', $event['heureDebut'] ) - DAY_ONE;
        //     break;
        //     default :
        //     $isOutOfEventDay = true;
        //     break;
        // }

        switch( (int) date( 'jm', $event['heureDebut'] ) ) {
            // Si le premier jour est le 4/09, mettre 409
            case 109 :
            $dayDelta = 0;
            break;
            case 209 :
            $dayDelta = 1;
            break;
            case 309 :
            $dayDelta = 2;
            break;
            default :
            $isOutOfEventDay = true;
            break;
        }

        if( !$isOutOfEventDay ) {
            $titre = ( !empty( $event['titre'] ) ) ? sprintf( '<b>%s</b>', $event['titre']=="."? "Rencontre":$event['titre']) : '';

            $horaire = sprintf( '<span class="horaire">%s-%s</span>', strftime( '%kh%M', $event['heureDebut'] ), strftime( '%kh%M', $event['heureFin'] ) );

            $finalProgramme[$dayDelta][] = array(
                't' => $event['heureDebut'],
                'e' => sprintf(
                    '<span class="eP" data-event="%s" data-heure_debut="%s">%s&nbsp;&nbsp;%s</span>',
                    $event['id'],
                    $event['heureDebut'],
                    $horaire,
                    $titre
                )
            );
        }
    }

    foreach( $programme['dedicaces'] as $event ) {
        $dayDelta = 0;
        $isOutOfEventDay = false;

        // switch( ( int ) date( 'j', $event['debut'] ) ) {
        //     case DAY_ONE :
        //     case DAY_ONE + 1:
        //     case DAY_ONE + 2:
        //     $dayDelta = ( int ) date( 'j', $event['fin'] ) - DAY_ONE;
        //     break;
        //     default :
        //     $isOutOfEventDay = true;
        //     break;
        // }

        switch( ( int ) date( 'jm', $event['debut'] ) ) {
            case 109 :
            $dayDelta = 0;
            break;
            case 209 :
            $dayDelta = 1;
            break;
            case 309 :
            $dayDelta = 2;
            break;
            default :
            $isOutOfEventDay = true;
            break;
        }

        if( !$isOutOfEventDay ) {
            $horaire = sprintf( '<span class="horaire">%s-%s</span>', strftime( '%kh%M', $event['debut'] ), strftime( '%kh%M', $event['fin'] ) );

            $finalProgramme[$dayDelta][] = array(
                't' => $event['debut'],
                'e' => sprintf(
                    '<div><span class="eP">%s <span>Dédicaces&nbsp;</span></span></div>',
                    $horaire
                )
            );
        }
    }

    foreach( $finalProgramme as $dayDelta => $jourProgramme ) {
        if( is_array( $jourProgramme ) && count( $jourProgramme ) > 0 )
        usort( $finalProgramme[$dayDelta], make_comparer( 't' ) );
    }

    $displayProgramme = array();

    foreach( $finalProgramme as $dayDelta => $jourProgramme ) {
        if( is_array( $jourProgramme ) && count( $jourProgramme ) > 0 ) {
            foreach( $jourProgramme as $programme ) {
                $displayProgramme[$dayDelta] .= $programme['e'];
            }
        }
        else
        $displayProgramme[$dayDelta] = '-';
    }

    for( $i = 0; $i < 3; $i++ ) {
        if( !array_key_exists( $i, $displayProgramme ) )
        $displayProgramme[$i] = '-';
    }

    $commentProgramme = (get_field( 'commentProgrammeAuteur', 'options' ) != '') ? '<div class="commentAuteur">' . get_field( 'commentProgrammeAuteur', 'options' ) . '</div>' : '';

    // Rendu
    printf(
        '<div class="programmeAuteur">
        %s
        <p><b>Programme de l\'auteur·trice</b></p>
        <div class="col33 vendredi"><p><strong><a href="/programme?day=vendredi">Vendredi</a></strong></p><div>%s</div></div>
        <div class="col33 samedi"><p><strong><a href="/programme?day=samedi">Samedi</a></strong></p><div>%s</div></div>
        <div class="col33 dimanche"><p><strong><a href="/programme?day=dimanche">Dimanche</a></strong></p><div>%s</div></div>
        <div class="clear"></div>
        </div>',
        $commentProgramme,
        $displayProgramme[0],
        $displayProgramme[1],
        $displayProgramme[2]
    );
}


/* == @section llq_afficherBarreProgrammeBackup ==================== */
function llq_afficherBarreProgrammeBackup( $programme, $noPlace ) {
    $noPlace = ( $noPlace == false ) ? '' : $noPlace;
    if( $noPlace == 'b' )
    $noPlace = 'bateau';

    $noPlace = ( !empty( $noPlace ) ) ? sprintf( '<span class="noPlace">place n<sup>o</sup> : %s</span>', $noPlace ) : '';

    // Programme incomplet ou vide
    if(
        !array_key_exists( 'dedicaces', $programme )
        || !array_key_exists( 'programme', $programme )
        || (
            count( $programme['dedicaces'] ) == 0
            &&  count( $programme['programme'] ) == 0
        )
    )
    return;

    $defaultMargin = array(
        0 => 0,
        1 => 158 + 3,
        2 => 158 + 3 + 174 + 3
    );

    ob_start();

    foreach( $programme['programme'] as $event ) {
        $dayDelta = 0;

        switch( ( int ) date( 'j', $event['heureDebut'] ) ) {
            case DAY_ONE :
            case DAY_ONE + 1:
            case DAY_ONE + 2:
            $dayDelta = ( int ) date( 'j', $event['heureDebut'] ) - DAY_ONE;
            break;
            default :
            break;
            break;
        }

        $startTime = mktime( 9, 30, 0, 9, DAY_ONE + $dayDelta, YEAR );

        $margin = $defaultMargin[$dayDelta] + RATIO_BARRE_PROGRAMME * ( $event['heureDebut'] - $startTime );
        $width = RATIO_BARRE_PROGRAMME * ( $event['duree'] * 60 );

        $titre = ( !empty( $event['titre'] ) ) ? sprintf( '<h3>%s</h3>', $event['titre'] ) : '';

        $horaire = sprintf( '<span class="horaire">%s – %s</span>', strftime( '%kh%M', $event['heureDebut'] ), strftime( '%kh%M', $event['heureFin'] ) );

        $lieu = ( count( $event['lieu'] ) > 0 ) ? sprintf( '<span class="lieu">%s</span>', $event['lieu'][0]['nom'] ) : '';
        $type = ( count( $event['type'] ) > 0 ) ? sprintf( '<span class="type">%s</span>', $event['type'][0]['nom'] ) : '';

        printf(
            '<div class="eB programme" style="width: %spx; margin-left: %spx"><div> %s %s %s %s</div></div>',
            $width,
            $margin,
            $titre,
            $horaire,
            $lieu,
            $type
        );
    }

    foreach( $programme['dedicaces'] as $event ) {
        $dayDelta = 0;

        switch( ( int ) date( 'j', $event['heureDebut'] ) ) {
            case DAY_ONE :
            case DAY_ONE + 1:
            case DAY_ONE + 2:
            $dayDelta = ( int ) date( 'j', $event['heureDebut'] ) - DAY_ONE;
            break;
            default :
            break;
            break;
        }

        $startTime = mktime( 9, 30, 0, 9, DAY_ONE + $dayDelta, YEAR );

        $margin = $defaultMargin[$dayDelta] + RATIO_BARRE_PROGRAMME * ( $event['heureDebut'] - $startTime );
        $width = RATIO_BARRE_PROGRAMME * ( $event['heureFin'] - $event['heureDebut'] );

        $horaire = sprintf( '<span class="horaire">%s – %s</span>', strftime( '%kh%M', $event['heureDebut'] ), strftime( '%kh%M', $event['heureFin'] ) );

        printf(
            '<div class="eB dedicace" style="width: %spx; margin-left: %spx"><div><h3>Dédicace</h3> %s %s</div></div>',
            $width,
            $margin,
            $horaire,
            $noPlace
        );
    }

    $events = ob_get_contents();
    ob_end_clean();

    // Rendu
    printf(
        '<div class="barreProgramme"><div class="vendredi"></div><div class="samedi"></div><div class="dimanche"></div><span class="vendredi">Vendredi</span><span class="samedi">Samedi</span><span class="dimanche">Dimanche</span>%s</div>',
        $events
    );
}


/* == @section mv_is_subpage ==================== */
/**
 * Is SubPage?
 *
 * Checks if the current page is a sub-page and returns true or false.
 *
 * @param  $page mixed optional ( post_name or ID ) to check against.
 * @return boolean
 */
function mv_is_subpage( $page = null ) {
    global $post;

    // is this even a page?
    if ( !is_page() )
    return false;

    // does it have a parent?
    if ( !isset( $post->post_parent ) OR $post->post_parent <= 0 )
    return false;

    // is there something to check against?
    if ( !isset( $page ) ) {
        // yup this is a sub-page
        return true;
    } else {
        // if $page is an integer then its a simple check
        if ( is_int( $page ) ) {
            // check
            if ( $post->post_parent == $page )
            return true;
        } else if ( is_string( $page ) ) {
            // get ancestors
            $parent = get_ancestors( $post->ID, 'page' );

            // does it have ancestors?
            if ( empty( $parent ) )
            return false;

            // get the first ancestor
            $parent = get_post( $parent[0] );

            // compare the post_name
            if ( $parent->post_name == $page )
            return true;
        }
        return false;
    }
}


/* == @section include commonFunctions.php ==================== */
include ABSPATH . 'commonFunctions.php';


/* == @section // Current jQuery ==================== */
// function current_jquery( $version ) {
//  global $wp_scripts;
//  if ( ( version_compare( $version, $wp_scripts -> registered[jquery] -> ver ) == 1 ) && !is_admin() ) {
//      wp_deregister_script( 'jquery' );
//
//      wp_register_script(
//          'jquery',
//          'http://ajax.googleapis.com/ajax/libs/jquery/' . $version . '/jquery.min.js',
//          false,
//          $version,
//          true
//      );
//  }
// }
// add_action( 'wp_head', current_jquery( '1.5.2' ) );


/* == @section Custom Post Types and Taxonomies ==================== */
/* -- @subsection Réservations d'hôtels -------------------- */
function cptui_register_my_cpt_reservation_hotel() {
    register_post_type( 'reservation-hotel', array(
        'label' => 'Réservations d\'hôtel',
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => false,
        'rewrite' => array(
            'slug' => 'reservation-hotel',
            'with_front' => true
        ),
        'query_var' => true,
        'supports' => array(
            'custom-fields',
            'revisions',
            'author',
            'page-attributes',
            'post-formats'
        ),
        'labels' => array(
            'name' => 'Réservations d\'hôtel',
            'singular_name' => 'Réservation d\'hôtel',
            'menu_name' => 'Réservations d\'hôtels',
            'add_new' => 'Enregistrer une réservation',
            'add_new_item' => 'Enregistrer une réservation',
            'edit' => 'Éditer',
            'edit_item' => 'Éditer une réservation',
            'new_item' => 'Nouvelle réservation',
            'view' => 'View Réservation d\'hôtel',
            'view_item' => 'View Réservation d\'hôtel',
            'search_items' => 'Search Réservations d\'hôtel',
            'not_found' => 'No Réservations d\'hôtel Found',
            'not_found_in_trash' => 'No Réservations d\'hôtel Found in Trash',
            'parent' => 'Parent Réservation d\'hôtel',
        )
    ) );
}
add_action( 'init', 'cptui_register_my_cpt_reservation_hotel' );

function cptui_register_my_taxes_remboursement() {
    register_taxonomy(
        'remboursement',
        array(
            0 => 'reservation-hotel',
        ),
        array(
            'hierarchical' => false,
            'label' => 'Remboursements',
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => false,
            'labels' => array(
                'search_items' => 'Remboursement',
                'popular_items' => '',
                'all_items' => '',
                'parent_item' => '',
                'parent_item_colon' => '',
                'edit_item' => '',
                'update_item' => '',
                'add_new_item' => '',
                'new_item_name' => '',
                'separate_items_with_commas' => '',
                'add_or_remove_items' => '',
                'choose_from_most_used' => '',
            )
        )
    );
}
add_action( 'init', 'cptui_register_my_taxes_remboursement' );

function cptui_register_my_taxes_hotel() {
    register_taxonomy(
        'hotel',
        array(
            0 => 'reservation-hotel',
        ),
        array(
            'hierarchical' => false,
            'label' => 'Hôtels',
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => false,
            'labels' => array(
                'search_items' => 'Hôtel',
                'popular_items' => '',
                'all_items' => '',
                'parent_item' => '',
                'parent_item_colon' => '',
                'edit_item' => '',
                'update_item' => '',
                'add_new_item' => '',
                'new_item_name' => '',
                'separate_items_with_commas' => '',
                'add_or_remove_items' => '',
                'choose_from_most_used' => '',
            )
        )
    );
}
add_action( 'init', 'cptui_register_my_taxes_hotel' );

function cptui_register_my_taxes_annee_reservation() {
    register_taxonomy(
        'annee-reservation',
        array(
            0 => 'reservation-hotel',
        ),
        array(
            'hierarchical' => false,
            'label' => 'Années de réservation',
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => false,
            'labels' => array(
                'search_items' => 'Année de réservation',
                'popular_items' => '',
                'all_items' => '',
                'parent_item' => '',
                'parent_item_colon' => '',
                'edit_item' => '',
                'update_item' => '',
                'add_new_item' => '',
                'new_item_name' => '',
                'separate_items_with_commas' => '',
                'add_or_remove_items' => '',
                'choose_from_most_used' => '',
            )
        )
    );
}
add_action( 'init', 'cptui_register_my_taxes_annee_reservation' );

/* -- @subsection Auteurs -------------------- */
function cptui_register_my_cpts_auteur() {
    $labels = array(
        "name" => "Auteurs",
        "singular_name" => "Auteur",
        "menu_name" => "Auteurs",
        "add_new" => "Ajouter un auteur",
        "add_new_item" => "Ajouter un auteur",
        "edit" => "Editer",
        "edit_item" => "Editer un auteur",
        "new_item" => "Nouvel auteur",
        "view" => "Afficher",
        "view_item" => "Afficher un auteur",
        "search_items" => "Rechercher un auteur",
        "not_found" => "Aucun auteur trouvé",
        "not_found_in_trash" => "Auteur non trouvé dans la corbeille",
        "parent" => "Auteur parent",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "menu_icon" => "dashicons-id",
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "auteur", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "excerpt", "custom-fields", "revisions", "thumbnail", "author", "page-attributes" ),
        "taxonomies" => array( "category" ),
    );
    register_post_type( "auteur", $args );
}
add_action( 'init', 'cptui_register_my_cpts_auteur' );

/* Année */
function cptui_register_my_taxes_annee_auteurs() {
    $labels = array(
        "name" => "Année auteur",
        "label" => "Année auteur",
    );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Année auteur",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'annee-auteurs', 'with_front' => true ),
        "show_admin_column" => true,
    );
    register_taxonomy( "annee-auteurs", array( "auteur" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_annee_auteurs' );

/* Catégories */
function cptui_register_my_taxes_categories_auteurs() {
    $labels = array(
        "name" => "Catégories",
        "label" => "Catégories",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => true,
        "label" => "Catégories",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'categories-auteurs', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "categories-auteurs", array( "auteur" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_categories_auteurs' );


/* -- @subsection Petits-déjeuners -------------------- */
// Masqué pour la mise à jour du thème 2016
function cptui_register_my_cpts_dejeuners() {
    $labels = array(
        "name" => "Petits-déjeuners",
        "singular_name" => "Petit-déjeuner",
        "add_new" => "Ajouter un petit-déjeuner",
        "add_new_item" => "Ajouter un petit-déjeuner",
        "edit" => "Modifier un petit-déjeuner",
        "edit_item" => "Modifier un petit-déjeuner",
        "new_item" => "Ajouter un petit-déjeuner",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "dejeuners", "with_front" => true ),
        "query_var" => true,

    );
    register_post_type( "dejeuners", $args );
}
add_action( 'init', 'cptui_register_my_cpts_dejeuners' );


/* -- @subsection Évènements -------------------- */
function cptui_register_my_cpts_evenement() {
    $labels = array(
        "name" => "Événéments",
        "singular_name" => "Événément",
        "menu_name" => "Événements",
        "all_items" => "Tous les événements",
        "add_new" => "Ajouter",
        "add_new_item" => "Ajouter un événement",
        "edit" => "Éditer",
        "edit_item" => "Éditer un événement",
        "new_item" => "Nouvel événement",
        "view" => "Afficher",
        "view_item" => "Afficher un événement",
        "search_items" => "Recherche un événement",
        "not_found" => "Aucun événement trouvé",
        "not_found_in_trash" => "Aucun événement trouvé dans la corbeille",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "menu_icon" => "dashicons-calendar-alt",
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "evenement", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "editor", "excerpt", "revisions", "author" ),
    );
    register_post_type( "evenement", $args );
}
add_action( 'init', 'cptui_register_my_cpts_evenement' );

/* Année */
function cptui_register_my_taxes_annee_evenement() {
    $labels = array(
        "name" => "Année événements",
        "label" => "Année événements",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Année événements",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'annee-evenement', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "annee-evenement", array( "evenement" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_annee_evenement' );

/* Lieux */
function cptui_register_my_taxes_lieu_evenement() {
    $labels = array(
        "name" => "Lieux événement",
        "label" => "Lieux événement",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Lieux événement",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'lieu-evenement', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "lieu-evenement", array( "evenement" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_lieu_evenement' );


/* Types */
function cptui_register_my_taxes_type_evenement() {
    $labels = array(
        "name" => "Types événements",
        "label" => "Types événements",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => true,
        "label" => "Types événements",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'type-evenement', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "type-evenement", array( "evenement" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_type_evenement' );

/* Jours */
function cptui_register_my_taxes_jour_evenement() {
    $labels = array(
        "name" => "Jours évènements",
        "label" => "Jours évènements",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Jours évènements",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'jour-evenement', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "jour-evenement", array( "evenement" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_jour_evenement' );


/* -- @subsection Logos -------------------- */
// Masqué pour la mise à jour du thème 2016
function cptui_register_my_cpts_logos() {
    $labels = array(
        "name" => "Logos",
        "singular_name" => "Logo",
        "menu_name" => "Logos",
        "add_new" => "Ajouter un logo",
        "add_new_item" => "Ajouter un logo",
        "edit" => "Éditer",
        "edit_item" => "Éditer un logo",
        "new_item" => "Nouveau logo",
        "view" => "Afficher",
        "view_item" => "Afficher un logo",
        "search_items" => "Rechercher un logo",
        );

    $args = array(
        "labels" => $labels,
        "description" => "Enregistrement pour les logos des sponsors, soutients, partenaires, etc. de la manifestation",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "logos", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "custom-fields", "thumbnail", "page-attributes" ),
    );
    register_post_type( "logos", $args );
}
add_action( 'init', 'cptui_register_my_cpts_logos' );

/* Types */
function cptui_register_my_taxes_type_logo() {

    $labels = array(
        "name" => "Types de logos",
        "label" => "Types de logos",
        "menu_name" => "Logos",
        "all_items" => "Tous les logos",
        "edit_item" => "Editer un logo",
        "view_item" => "Afficher un logo",
        "add_new_item" => "Ajouter un logo",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Types de logos",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'type-logo', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "type-logo", array( "logos" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_type_logo' );


/* -- @subsection Espace presse -------------------- */
function cptui_register_my_cpts_presse() {
    $labels = array(
        "name" => "Espace presse",
        "singular_name" => "Presse",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "menu_icon" => "dashicons-book-alt",
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "presse", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "thumbnail" ),
    );
    register_post_type( "presse", $args );
}
add_action( 'init', 'cptui_register_my_cpts_presse' );

/* Catégories */
function cptui_register_my_taxes_categorie_presse() {
    $labels = array(
        "name" => "Catégories",
        "label" => "Catégories",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => false,
        "label" => "Catégories",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'categorie-presse', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "categorie-presse", array( "presse" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_categorie_presse' );


/* -- @subsection Invités -------------------- */
// Masqué pour la mise à jour du thème 2016
function cptui_register_my_cpts_invites() {
    $labels = array(
        "name" => "invites",
        "singular_name" => "invites",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "invites", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "editor", "excerpt", "trackbacks", "custom-fields", "comments", "revisions", "thumbnail", "author", "page-attributes", "post-formats" ),
    );
    register_post_type( "invites", $args );
}
add_action( 'init', 'cptui_register_my_cpts_invites' );

/* -- @subsection Ouvrages -------------------- */
function cptui_register_my_cpts_ouvrage() {
    $labels = array(
        "name" => "Ouvrages",
        "singular_name" => "Ouvrages",
        "menu_name" => "Ouvrages",
        "add_new" => "Ajouter un ouvrage",
        "add_new_item" => "Ajouter un ouvrage",
        "edit" => "Editer",
        "edit_item" => "Editer un ouvrage",
        "new_item" => "Nouvel ouvrage",
        "view" => "Afficher",
        "view_item" => "Afficher un ouvrage",
        "search_items" => "Rechercher un ouvrage",
        "not_found" => "Aucun ouvrage trouvé",
        "not_found_in_trash" => "Ouvrage non trouvé dans la corbeille",
        "parent" => "Ouvrage parent",
        );

    $args = array(
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "has_archive" => false,
        "menu_icon" => "dashicons-id",
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array( "slug" => "ouvrage", "with_front" => true ),
        "query_var" => true,

        "supports" => array( "title", "custom-fields", "editor", "revisions", "thumbnail", "page-attributes" ),
        // "taxonomies" => array( "category" ),
    );
    register_post_type( "ouvrage", $args );
}
add_action( 'init', 'cptui_register_my_cpts_ouvrage' );

/* Catégories */
function cptui_register_my_taxes_categories_ouvrage() {
    $labels = array(
        "name" => "Catégories",
        "label" => "Catégories",
        );

    $args = array(
        "labels" => $labels,
        "hierarchical" => true,
        "label" => "Catégories",
        "show_ui" => true,
        "query_var" => true,
        "rewrite" => array( 'slug' => 'categories-ouvrage', 'with_front' => true ),
        "show_admin_column" => false,
    );
    register_taxonomy( "categories-ouvrage", array( "ouvrage" ), $args );
}
add_action( 'init', 'cptui_register_my_taxes_categories_ouvrage' );


/* == @section ACF register_field_group ==================== */
register_field_group( array(
    'id' => 'acf_etapes-de-suivi',
    'title' => 'Étapes de suivi',
    'fields' => array(
        array(
            'key' => 'field_535d5f923c9c7',
            'label' => 'Étapes de suivi',
            'name' => 'steps',
            'type' => 'repeater',
            'instructions' => 'Saisir par ordre de priorité croissante les étapes de suivi d\'une fiche d\'auteur pendant le salon.',
            'sub_fields' => array(
                array(
                    'key' => 'field_535d5fd673991',
                    'label' => 'Titre',
                    'name' => 'titre',
                    'type' => 'text',
                    'column_width' => '',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'none',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_535d6a5da5d77',
                    'label' => 'alias',
                    'name' => 'alias',
                    'type' => 'text',
                    'instructions' => 'Version simplifiée sans caractères spéciaux pour identifier électroniquement les étapes',
                    'column_width' => '',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
            ),
            'row_min' => '',
            'row_limit' => '',
            'layout' => 'table',
            'button_label' => 'Ajouter une étape',
        ),
    ),
    'location' => array(
        array(
            array(
            'param' => 'options_page',
            'operator' => '==',
            'value' => 'acf-options',
            'order_no' => 0,
            'group_no' => 0,
            ),
        ),
    ),
    'options' => array(
        'position' => 'normal',
        'layout' => 'default',
        'hide_on_screen' => array(),
    ),
    'menu_order' => 0,
) );


/* == @section Sidebars ==================== */
if ( function_exists( 'register_sidebar' ) )

// register_sidebar( array(
//  'name' => 'petits déjeuners',
//  'id' => 'petits_dejeuners',
//  'before_widget' => '<div class="blockContent petitsdejeuners"><span class="titre">Petits déjeuners</span><div class="wrapContentBlock">', // par défaut: <div id="%1$s" class="highlight %2$s">
//  'after_widget' => '<div><a href="/petits-dejeuners" class="btn bg-petitsdej">En savoir plus</a></div></div></div>',
//  'before_title' => '',
//  'after_title' => '',
// ));
// register_sidebar( array(
//  'name' => 'spectacles',
//  'id' => 'spectacles',
//  'before_widget' => '<div class="blockContent spectacles bg-grey"><div class="titre">Spectacles</div><div class="wrapContentBlock">',
//  'after_widget' => '<div><a href="/spectacles" class="btn">En savoir plus</a></div></div></div>',
//  'before_title' => '',
//  'after_title' => '',
// ));
// register_sidebar( array(
//  'name' => 'expositions',
//  'id' => 'expositions',
//  'before_widget' => '<div class="blockContent expositions bg-grey"><span class="titre">Expositions</span><div class="wrapContentBlock">',
//  'after_widget' => '<div><a href="/expositions" class="btn">En savoir plus</a></div></div></div>',
//  'before_title' => '',
//  'after_title' => '',
// ));

register_sidebar( array(
    'name' => 'hotes d\'honneur',
    'id' => 'hotes',
    'before_widget' => '',
    'after_widget' => '',//<div><a href="/hotes" class="btn">En savoir plus</a></div>
    'before_title' => '<span class="titre">',
    'after_title' => '</span>',
));

// register_sidebar( array(
//  'name' => 'hotes d\'honneur',
//  'id' => 'hotes',
//  'before_widget' => '<div class="blockContent bg-hotes"><div class="wrapContentBlock">',
//  'after_widget' => '<div><a href="/hotes" class="btn">En savoir plus</a></div></div></div>',
//  'before_title' => '<span class="titre">',
//  'after_title' => '</span>',
// ));

// register_sidebar( array(
//  'name' => 'hotes d\'honneur',
//  'id' => 'hotes',
//  'before_widget' => '<div class="block col50">',
//  'after_widget' => '</div>',
//  'before_title' => '<span class="titre">',
//  'after_title' => '</div>',
// ));

// register_sidebar( array(
//  'name' => 'informations',
//  'id' => 'informations',
//  'before_widget' => '<div class="blockContent informations bg-grey"><span class="titre">Informations</span><div class="wrapContentBlock">',
//  'after_widget' => '<div><a href="/informations" class="btn">En savoir plus</a></div></div></div>',
//  'before_title' => '',
//  'after_title' => '',
// ));

// register_sidebar( array(
//  'name' => 'actualités',
//  'id' => 'actualites',
//  'before_widget' => '<div class="blockContent actualites bg-grey"><span class="titre">Actualités</span><div class="wrapContentBlock">',
//  'after_widget' => '</div></div>',
//  'before_title' => '',
//  'after_title' => '',
// ));

// register_sidebar( array(
//  'name' => '3-blocs-ligne-1',
//  'id' => 'threeblocksrow1',
//  'before_widget' => '<div class="block col33">',
//  'after_widget' => '</div>',
//  'before_title' => '<span class="titre">',
//  'after_title' => '</span>',
// ));

register_sidebar( array(
    'name' => '3-blocs-ligne-2',
    'id' => 'threeblocksrow2',
    'before_widget' => '<div class="block col33">',
    'after_widget' => '</div>',
    'before_title' => '<span class="titre">',
    'after_title' => '</span>',
));

register_sidebar( array(
    'name' => '6-blocs-colonne-1',
    'id' => 'sixblocks-col1',
    'before_widget' => '<div class="blockCol">',
    'after_widget' => '</div>',
    'before_title' => '<span class="titre">',
    'after_title' => '</span>',
));

// register_sidebar( array(
//     'name' => '6-blocs-colonne-2',
//     'id' => 'sixblocks-col2',
//     'before_widget' => '<div class="blockCol">',
//     'after_widget' => '</div>',
//     'before_title' => '<span class="titre">',
//     'after_title' => '</span>',
// ));

// register_sidebar( array(
//     'name' => '6-blocs-colonne-3',
//     'id' => 'sixblocks-col3',
//     'before_widget' => '<div class="blockCol">',
//     'after_widget' => '</div>',
//     'before_title' => '<span class="titre">',
//     'after_title' => '</span>',
// ));

register_sidebar( array(
    'name' => '2-blocs',
    'id' => 'twoblocks',
    'before_widget' => '<div class="block col50">',
    'after_widget' => '</div>',
    'before_title' => ' <span class="titre">',
    'after_title' => '</span>',
));

// Emplacement inscription newsletter
register_sidebar( array(
    'name' => 'Inscription newsletter',
    'id' => 'register-newsletter',
    'before_widget' => '<span id="register_newsletter" class="%2$s">',
    'after_widget' => '</span></span>',
    'before_title' => '',
    'after_title' => '<span class="newsletter-content">',
));


/* == @section Sous-menu contextuel ==================== */
/* fro: affiche le sous menu dans les pages
 * filter_hook function to react on sub_menu flag
 */
function my_wp_nav_menu_objects_sub_menu( $sorted_menu_items, $args ) {
    if ( isset( $args->sub_menu ) ) {
        $root_id = 0;

        // find the current menu item
        foreach ( $sorted_menu_items as $menu_item ) {
            if ( $menu_item->current ) {
                // set the root id based on whether the current menu item has a parent or not
                $root_id = ( $menu_item->menu_item_parent ) ? $menu_item->menu_item_parent : $menu_item->ID;
                break;
            }
        }

        // find the top level parent
        if ( ! isset( $args->direct_parent ) ) {
            $prev_root_id = $root_id;
            while ( $prev_root_id != 0 ) {
                foreach ( $sorted_menu_items as $menu_item ) {
                    if ( $menu_item->ID == $prev_root_id ) {
                        $prev_root_id = $menu_item->menu_item_parent;
                        // don't set the root_id to 0 if we've reached the top of the menu
                        if ( $prev_root_id != 0 ) $root_id = $menu_item->menu_item_parent;
                        break;
                    }
                }
            }
        }

        $menu_item_parents = array();
            foreach ( $sorted_menu_items as $key => $item ) {
            // init menu_item_parents
            if ( $item->ID == $root_id ) $menu_item_parents[] = $item->ID;

            if ( in_array( $item->menu_item_parent, $menu_item_parents ) ) {
                // part of sub-tree: keep!
                $menu_item_parents[] = $item->ID;
            } else if ( ! ( isset( $args->show_parent ) && in_array( $item->ID, $menu_item_parents ) ) ) {
                // not part of sub-tree: away with it!
                unset( $sorted_menu_items[$key] );
            }
        }

        return $sorted_menu_items;
    } else {
        return $sorted_menu_items;
    }
}
add_filter( 'wp_nav_menu_objects', 'my_wp_nav_menu_objects_sub_menu', 10, 2 );


/* == @section Format de date ==================== */
/*
 * Sky Date in French by Matt - www.skyminds.net
 * Returns or echoes the date in French format (dd/mm/YYYY) for WordPress themes.
 */
function sky_date_french( $format, $timestamp = null, $echo = null ) {
    $param_D = array( '', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam', 'Dim' );
    $param_l = array( '', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche' );
    $param_F = array( '', 'Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre' );
    $param_M = array( '', 'Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû', 'Sep', 'Oct', 'Nov', 'Déc' );
    $return = '';

    if( is_null( $timestamp ) ) {
        $timestamp = mktime();
    }

    for( $i = 0, $len = strlen( $format ); $i < $len; $i++ ) {
        switch( $format[$i] ) {
            case '\\' : // fix.slashes
            $i++;
            $return .= isset( $format[$i] ) ? $format[$i] : '';
            break;
            case 'D' :
            $return .= $param_D[date( 'N', $timestamp )];
            break;
            case 'l' :
            $return .= $param_l[date( 'N', $timestamp )];
            break;
            case 'F' :
            $return .= $param_F[date( 'n', $timestamp )];
            break;
            case 'M' :
            $return .= $param_M[date( 'n', $timestamp )];
            break;
            default :
            $return .= date( $format[$i], $timestamp );
            break;
        }
    }

    if( is_null( $echo ) ) {
        return $return;
    } else {
        echo $return;
    }
}


/* == @section Affichage du programme ==================== */
function llq_ProgrammeList( $annee = '',  $day=-1, $category=-1 ) {
    ob_start();

    if( empty( $annee ) )
    $annee = 2023;

    if( $day != "" && $day != "-1" ){
        echo get_term( $day, 'jour-evenement' )->name;
    }

    $locals = array();
    $locals['avec']['fr'] = 'Avec';
    $locals['avec']['lt'] = 'par';
    $locals['avec']['ci'] = 'Avec';
    $locals['avec']['en'] = 'With';
    $locals['enPresenceDe']['fr'] = 'En présence de';
    $locals['enPresenceDe']['lt'] = 'par';
    $locals['enPresenceDe']['ci'] = 'Avec';
    $locals['enPresenceDe']['en'] = 'With';
    $locals['presentePar']['fr'] = 'Animé par';
    $locals['presentePar']['lt'] = 'Animé par';
    $locals['presentePar']['ci'] = 'Animé par';
    $locals['presentePar']['en'] = 'Presented by';

    $args = array(
        'post_type' => 'evenement',
        'annee-evenement' => $annee,
        'orderby' => 'meta_value_num',
        'meta_key' => 'heure_tri',
        'order' => 'ASC',
        'posts_per_page' => -1
    );
    $args['tax_query'] = array( 'relation' => 'AND' );

    if( $category != "" && $category != "-1" ) {
        $args['tax_query'][] = array(
            'taxonomy' => 'type-evenement',
            'terms' => array( $category ),
            'field' => 'slug'
        );
    } else {
        //get only selected category of event for the page
        $categorySlugs = array();
        $categories = get_field( 'type-evenement' );

        if( isset( $categories ) && is_array( $categories ) ) {
            for( $i = 0; $i < count( $categories ); $i++ ) {
                if( isset( $categories[$i] ) && $categories[$i]->name !="" ) {
                    $categorySlugs[] =  $categories[$i]->slug;
                }
            }

            $args['tax_query'][] = array(
                'taxonomy' => 'type-evenement',
                'terms' => $categorySlugs,
                'field' => 'slug'
            );
        }
    }

    if( $day != "" && $day != "-1" ) {
        $args['tax_query'][] = array(
            'taxonomy' => 'jour-evenement',
            'terms' => array($day),
            'field' => 'slug'
        );
    }

    query_posts($args);

    $evenements = array();
    $crtDayStr = "";

    $events = array();
    if ( have_posts() ) : while ( have_posts() ) : the_post();

    if( !get_field( 'heure_2013' ) || !get_field( 'heure_tri' ) )
    continue;

    $id = get_the_ID();
    $daysArray = wp_get_post_terms( $id, 'jour-evenement', array( "fields" => "all" ) );

    if( count( $daysArray )>0 && $daysArray[0]->name!=$crtDayStr ) {
        $crtDayStr = $daysArray[0]->name;
        echo sprintf( "<h2>%s</h2>", $crtDayStr );
    }

    $lieux = get_the_terms( $id, 'lieu-evenement' );
    $types = get_the_terms( $id, 'type-evenement' );

    $lieuxFinal = array();
    $lieuxFinalName = array();
    $typesFinal = array();
    $typesFinalName = array();

    if( is_array( $lieux ) && count( $lieux ) > 0 ) {
        unset( $lieuOrder );

        foreach( $lieux as $lieu ) {
            $lieuxFinal[] =  $lieu->term_id;
            $lieuxFinalName[] =  $lieu->name;

            if( !isset( $lieuOrder ) || $lieuOrder > $lieu->tax_order ) {
                $lieuOrder = $lieu->tax_order;
            }
        }
    }

    $lang = 'fr';

    if( is_array( $types ) && count( $types ) > 0 ) {
        unset( $typeOrder );

        foreach( $types as $type ) {
            $typesFinal[] = $type->term_id;
            $typesFinalName[] =  $type->name;

            if( !isset( $typeOrder ) || $typeOrder > $type->tax_order ) {
                $typeOrder = $type->tax_order;
            }

            /*
            * Identifier la locale à utiliser
            */
            switch( $type->slug ) {
                case 'anglais':
                $lang = 'en';
                break;
                case 'cinema':
                $lang = 'ci';
                break;
                case 'lecture-musicale':
                case 'lecture':
                case 'lecture-bilingue':
                $lang = 'lt';
                break;
            }
        }
    }

    $auteursFormatedHtml = "";
    $auteursPresents = get_field( 'auteurs_presents' );
    $auteursPresentsTexte = get_field( 'auteurs_presents_texte' );
    // $auteursPresentsFinal = trim( texteAuteursPrésents( $auteursPresentsTexte, $auteursPresents ) );

    if( !empty( $auteursPresentsTexte ) && $auteursPresentsTexte!=" " ) {
        $auteursPresentsTexte = $locals['enPresenceDe'][$lang] . ' ' . $auteursPresentsTexte;
    }

    if( $auteursPresents === false || empty( $auteursPresents ) ) {
        $auteursPresentsMetadata = array();
    } else {
        $auteursPresentsMetadata = array();
        $auteursFormatedHtml = "";
        $cpt=0;

        foreach( $auteursPresents as $auteur ) {
            $auteursPresentsMetadata[] = $auteur->ID;
            if( $cpt==0 )
            $auteursFormatedHtml .= $locals['avec'][$lang]." ";
            else
            $auteursFormatedHtml .= ", ";

            $auteursFormatedHtml .= sprintf( '<a href="%s" >%s</a>', get_permalink( $auteur->ID ), get_the_title( $auteur->ID ) );
            $cpt++;
        }
    }

    $animePar = html_entity_decode( (string) get_field( 'anime_par' ), ENT_QUOTES, 'UTF-8' );

    if( !empty( $animePar ) ) {
        $animePar = $locals['presentePar'][$lang] . ' ' . $animePar;
    }

    $return = array(
        'id' => $id,
        'heureDebut' => ( int ) get_field( 'heure_tri' ),
        'heureStr' => ( int ) get_field( 'heure_2013' ),
        'heureFin' => get_field( 'heure_tri' ) + get_field( 'duree' ) * 60,
        'duree' => ( int ) get_field( 'duree' ),
        'titre' => get_the_title()=="."?"": html_entity_decode( get_the_title(), ENT_QUOTES, 'UTF-8' ),
        'animePar' => $animePar,
        'informations_importantes' => html_entity_decode( ( string ) get_field( 'informations_importantes' ), ENT_QUOTES, 'UTF-8' ),
        'lieu' => $lieuxFinal,
        'lieuOrder' => $lieuOrder,
        'type' => $typesFinal,
        'typeStr' => count( $typesFinalName )==0?"":str_replace( "--", "", implode( ',', $typesFinalName ) ), //categorie
        'lieuStr' => count( $lieuxFinalName )==0?"":implode( ',', $lieuxFinalName ), //lieu
        'typeOrder' => $typeOrder,
        'auteursPresentsTexte' => $auteursPresentsTexte,
        'auteursPresents' => $auteursPresentsMetadata,
        'jour' => $daysArray[0]->name,
        'auteurFormatedHtml' => $auteursFormatedHtml,
        'description' => get_the_content(),
        'test' => get_the_ID()
    );

    //usort($return, make_comparer('heureDebut', 'lieuOrder'));
    //print_r($return);
    $doNotShowAssociated = false;

    if( $return['typeStr']==" Lecture" || strpos( $return['typeStr'], 'Lecture bilingue' ) !== false )
    $doNotShowAssociated = true;
    echo sprintf(
        '<div class="listeProgramme col33" style="margin-bottom:20px;">

        <p class="categorie"><span class="heure">%s</span> <span class="type">%s</span></p>
        <p><b>%s</b></p>
        <p>%s</p>
        <p>%s</p>
        <p>%s</p>
        <p>%s</p>
        <p class="info-importantes">%s</p>
        <p>%s <small>(%s min.)</small></p>

        </div>',
        date( 'G\hi', $return['heureDebut'] ),
        $return['typeStr'],
        $return['titre'],
        $doNotShowAssociated?'':$return['auteurFormatedHtml'],
        $doNotShowAssociated?'':$return['auteursPresentsTexte'],
        $doNotShowAssociated?'':$return['animePar'],
        $return['description'],
        $return['informations_importantes'],
        $return['lieuStr'],
        $return['duree']
    );

    endwhile; endif;

    wp_reset_query();

    $list = ob_get_contents();
    ob_end_clean();

    return $list;
}


/* == @section Personnalisation admin ==================== */

/* -- @subsection Menu -------------------- */
function delete_menu_items() {
    /* Tous les utilisateurs */

    // Menus
    /* Comments */          remove_menu_page( 'edit-comments.php' );
    /* Tools */             remove_menu_page( 'tools.php' );
    /* Pages */             remove_menu_page( 'edit.php?post_type=reservation-hotel' );
    /* Pages */             remove_menu_page( 'edit.php?post_type=dejeuners' );
    /* Pages */             remove_menu_page( 'edit.php?post_type=logos' );
    /* Pages */             remove_menu_page( 'edit.php?post_type=invites' );

    // Sous-menus
    // @note Syntaxe : remove_submenu_page( $menu_slug, $submenu_slug )
    /* Edit > Tags */       remove_submenu_page( 'edit.php', 'edit-tags.php?taxonomy=post_tag' );

    /* Non admins */
    if( ! current_user_can( 'add_users' ) ) {
        // Menus
        // @note Syntaxe : remove_menu_page( $menu_slug ) */
        /* Dashboard */         // remove_menu_page( 'index.php' );
        /* Posts */             remove_menu_page( 'edit.php' );
        /* Media */             // remove_menu_page( 'upload.php' );
        /* Links */             remove_menu_page( 'link-manager.php' );
        /* Pages */             // remove_menu_page( 'edit.php?post_type=page' );
        /* Appearance */        remove_menu_page( 'themes.php' );
        /* Plugins */           remove_menu_page( 'plugins.php' );
        /* Users */             remove_menu_page( 'users.php' );
        /* Settings */          remove_menu_page( 'options-general.php' );

        // Extensions
        // @note Se référer à la documentation des extensions si disponible */
        /* Contact Form 7 */    remove_menu_page( 'wpcf7' );
        /* MainWP */            remove_menu_page( 'mainwp_child_tab' );
        /* WP Securtiy */       remove_menu_page( 'aiowpsec' );
        /* Event Espresso */    remove_menu_page( 'event_espresso' );
        /* ACF */               remove_menu_page( 'edit.php?post_type=acf' );
        /* ACF - Options */     remove_menu_page( 'acf-options' );
        /* Meta Slider */       remove_menu_page( 'metaslider' );
    }

    /* Tous les admins */
    if( current_user_can( 'add_users' ) ) {}
}
add_action( 'admin_menu', 'delete_menu_items', 9999 ); // 9999 permet d'outrepasser les paramètres d'extensions

// Supprime le lien Personnaliser dans Apparences
function remove_customize_page() {
    global $submenu;
    unset( $submenu['themes.php'][6] );
}
add_action( 'admin_menu', 'remove_customize_page' );


/* -- @subsection Dashboard -------------------- */
function cdiwp_dashboard_widgets() {
    global $wp_meta_boxes;

    /* == @section Widgets natifs ==================== */

    /* At a Glance */       // unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now'] );
    /* Activity */          // unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity'] );
    /* Comments */          unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments'] );
    /* Incoming Links */    unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links'] );
    /* Plugins */           unset( $wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins'] );
    /* Quick Draft */       unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press'] );
    /* Recent Drafts */     // unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts'] );
    /* WordPress News */    unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_primary'] );
    /* */                   // unset( $wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary'] );


    /* == @section Widgets d'extensions ==================== */
    /* Postman SMTP */      unset( $wp_meta_boxes['dashboard']['normal']['core']['example_dashboard_widget'] );
    /* Event Espresso */    unset( $wp_meta_boxes['dashboard']['normal']['core']['espresso_news_dashboard_widget'] );
}
add_action( 'wp_dashboard_setup', 'cdiwp_dashboard_widgets', 999 );


/* -- @subsection Barre d'admin -------------------- */
function remove_admin_bar_links() {
    global $wp_admin_bar;

    // Remove WordPress Logo Menu Items
    $wp_admin_bar->remove_menu( 'wp-logo' ); // Removes WP Logo and submenus completely, to remove individual items, use the below mentioned codes
    // $wp_admin_bar->remove_menu( 'about' ); // 'About WordPress'
    // $wp_admin_bar->remove_menu( 'wporg' ); // 'WordPress.org'
    // $wp_admin_bar->remove_menu( 'documentation' ); // 'Documentation'
    // $wp_admin_bar->remove_menu( 'support-forums' ); // 'Support Forums'
    // $wp_admin_bar->remove_menu( 'feedback' ); // 'Feedback'

    // Remove Site Name Items
    // $wp_admin_bar->remove_menu( 'site-name' ); // Removes Site Name and submenus completely, To remove individual items, use the below mentioned codes
    $wp_admin_bar->remove_menu( 'view-site' ); // 'Visit Site'
    $wp_admin_bar->remove_menu( 'dashboard' ); // 'Dashboard'
    $wp_admin_bar->remove_menu( 'themes' ); // 'Themes'
    $wp_admin_bar->remove_menu( 'widgets' ); // 'Widgets'
    $wp_admin_bar->remove_menu( 'menus' ); // 'Menus'

    // Remove Comments Bubble
    $wp_admin_bar->remove_menu( 'comments' );

    // Remove Update Link if theme/plugin/core updates are available
    $wp_admin_bar->remove_menu( 'updates' );

    // Remove '+ New' Menu Items
    $wp_admin_bar->remove_menu( 'new-content' ); // Removes '+ New' and submenus completely, to remove individual items, use the below mentioned codes
    // $wp_admin_bar->remove_menu( 'new-post' ); // 'Post' Link
    // $wp_admin_bar->remove_menu( 'new-media' ); // 'Media' Link
    // $wp_admin_bar->remove_menu( 'new-link' ); // 'Link' Link
    // $wp_admin_bar->remove_menu( 'new-page' ); // 'Page' Link
    // $wp_admin_bar->remove_menu( 'new-user' ); // 'User' Link

    // Remove 'Howdy, username' Menu Items
    // $wp_admin_bar->remove_menu( 'my-account' ); // Removes 'Howdy, username' and Menu Items
    // $wp_admin_bar->remove_menu( 'user-actions' ); // Removes Submenu Items Only
    $wp_admin_bar->remove_menu( 'user-info' ); // 'username'
    // $wp_admin_bar->remove_menu( 'edit-profile' ); // 'Edit My Profile'
    // $wp_admin_bar->remove_menu( 'logout' ); // 'Log Out'

    $wp_admin_bar->remove_menu( 'espresso-toolbar' ); // Event Espresso
}
add_action( 'wp_before_admin_bar_render', 'remove_admin_bar_links' );

/* Lien Personnaliser */
function remove_customize( $wp_admin_bar ) {
    $wp_admin_bar->remove_node( 'customize' );
}
add_action( 'admin_bar_menu', 'remove_customize', 999 );

/* Ajout liens tools */
function add_toolbar_link( $wp_admin_bar ) {
    $tools = array(
        'id' => 'tools-admin',
        'title' => '<span class="wp-admin-tools"></span> Tools',
        'href' => false
    );

    $dedicaces = array(
        'id' => 'tools-admin-dedicaces',
        'parent' => 'tools-admin',
        'title' => 'Dédicaces',
        'href' => get_site_url() . '/tools/dedicace.html',
        'meta' => array(
            'class' => 'tools-admin-dedicace',
            'target' => '_blank'
        )
    );

    $eventform = array(
        'id' => 'tools-admin-event',
        'parent' => 'tools-admin',
        'title' => 'Event Form',
        'href' => get_site_url() . '/event_form.php',
        'meta' => array(
            'class' => 'tools-admin-event',
            'target' => '_blank'
        )
    );

    $eventorder = array(
        'id' => 'tools-admin-event-order',
        'parent' => 'tools-admin',
        'title' => 'Event Order',
        'href' => get_site_url() . '/tools/eventOrder.html',
        'meta' => array(
            'class' => 'tools-admin-event-order',
            'target' => '_blank'
        )
    );

    $previewprogram = array(
        'id' => 'tools-program-preview',
        'parent' => 'tools-admin',
        'title' => 'Preview Program',
        'href' => get_site_url() . '/programme-preview',
        'meta' => array(
            'class' => 'tools-program-preview'
        )
    );

    $wp_admin_bar->add_node( $tools );
    $wp_admin_bar->add_node( $dedicaces );
    $wp_admin_bar->add_node( $eventform );
    $wp_admin_bar->add_node( $eventorder );
    $wp_admin_bar->add_node( $previewprogram );
}
add_action( 'admin_bar_menu', 'add_toolbar_link', 999 );

function custom_wp_toolbar() {
    if( current_user_can( 'add_users' ) ) {
        wp_register_style(
            'add_custom_wp_toolbar_css',
            esc_url( get_template_directory_uri() ) . '/styles/admin.css',
            '',
            '',
            'screen'
        );
        wp_enqueue_style( 'add_custom_wp_toolbar_css' );
    }
}
add_action( 'admin_enqueue_scripts', 'custom_wp_toolbar' ); // On charge le style dans l'admin
add_action( 'wp_enqueue_scripts', 'custom_wp_toolbar' ); // On charge le style sur le front aussi


/* -- @subsection Rôle dédicaces -------------------- */
/* Ajout du droit d'édition des dédicaces
 * Anciennement donné par l'extension Capability Manager Enhanced
 */
function add_theme_caps() {
    $role = get_role( 'administrator' );

    $role->add_cap( 'edit_dedicace' );
}
add_action( 'admin_init', 'add_theme_caps' );


/* -- @subsection ACF : Options -------------------- */
// Si update ACF 5
if( function_exists('acf_add_options_page' ) ) {
    acf_add_options_page();
}


/* -- @subsection Notifications de mise à jour -------------------- */
if ( is_admin() ) {
    /* Notification de mises à jour du thème */
    require get_stylesheet_directory() . '/functions/admin_update-notifier.php';
}


/* == @section Personnalisation front ==================== */
/* -- @subsection Grand ménage dans <head> -------------------- */
/**
 * @note Désactivation des liens et balises inutiles.
*/
function head_cleanup() {
    /* Flux des articles et commantaires */
    remove_action( 'wp_head', 'feed_links', 2 );
    /* Flux des catégories */
    remove_action( 'wp_head', 'feed_links_extra', 3 );
    /* Lien Windows Live Writer */
    remove_action( 'wp_head', 'wlwmanifest_link' );
    remove_action( 'wp_head', 'rsd_link' );
    /* Lien vers la catégorie parent */
    remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
    /* start link */
    remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
    /* Liens des articles suivants et précédents */
    remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0 );
    /* Liens des articles suivants et précédents */
    remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
    /* Lien raccourci */
    remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
    /* Version de WP */
    remove_action( 'wp_head', 'wp_generator' );
    /* Support des emojis - @see http://wpcrux.com/disable-emojicons/ */
    remove_filter( 'the_content_feed', 'wp_staticize_emoji' ); // RSS
    remove_filter( 'comment_text_rss', 'wp_staticize_emoji' ); // Commentaires
    //remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' ); // E-mails
    remove_action( 'wp_head', 'print_emoji_detection_script', 7 ); // Head
    remove_action( 'wp_print_styles', 'print_emoji_styles' ); // CSS print
    //remove_action( 'admin_print_scripts', 'print_emoji_detection_script' ); // Admin scripts
    //remove_action( 'admin_print_styles', 'print_emoji_styles' ); // Admin CSS
    /* API */
    remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
    remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
    /* Event Espresso */
    // remove_action( 'wp_head', 'espresso_info_header' );
    // remove_action( 'wp_head', 'header_meta_tag', 10 );
}
add_action( 'after_setup_theme', 'head_cleanup' );


function remove_ee_style() {
    wp_dequeue_style( 'espresso_default' );
    wp_deregister_style( 'espresso_default' );
}
add_action( 'wp_print_styles', 'remove_ee_style' );


/* -- @subsection Versions WP -------------------- */
/**
 * @note On supprime la version de WordPress dans les URL CSS et JavaScript.
 * @link http://b-website.com/nettoyer-les-numeros-de-versions-dans-le-header-de-wordpress
 */
function remove_wp_ver_css_js( $src ) {
    global $wp_version;
    parse_str( parse_url( $src, PHP_URL_QUERY ), $query );
    if ( ! empty( $query['ver'] ) && $query['ver'] === $wp_version ) {
        $src = remove_query_arg( 'ver', $src );
    }
    return $src;
}
add_filter( 'style_loader_src', 'remove_wp_ver_css_js', 9999 ); // Version de WP dans les URL CSS
add_filter( 'script_loader_src', 'remove_wp_ver_css_js', 9999 ); // Version de WP dans les URL JS


/* -- @subsection Contact Form 7 -------------------- */
/**
 * @note Les CSS et JS de Contact Form 7 sont insérés sur toutes les pages par défaut. Cette fonction permet de l'afficher uniquement sur les pages où il y a un formulaire.
 * @see http://dannyvankooten.com/3935/only-load-contact-form-7-scripts-when-needed/
 */
function dequeue_contact() {
  if( is_page( array( 6969 ) ) ) {
    // La page de contact Cercle des Amis porte l'ID 6969 donc on veut garder les styles et scripts Contact Form 7
  } else {
    // Dans tous les autres cas, on ne veut pas appeler les styles et scripts du plugin
    wp_dequeue_script( 'contact-form-7' );
    wp_dequeue_style( 'contact-form-7' );
  }
}
add_action( 'wp_enqueue_scripts', 'dequeue_contact' );


/* == @section Event Espresso Custom Templates ==================== */
add_filter( 'FHEE__EED_Event_Single__template_include__allow_custom_selected_template', '__return_true' );

// Reprise des fonctions EE et adaptation

// Date et heure de l'évènement
function espresso_list_of_event_dates( $EVT_ID = 0, $date_format = '', $time_format = '', $echo = TRUE, $show_expired = NULL, $format = TRUE, $add_breaks = TRUE, $limit = NULL ) {
    $date_format = ! empty( $date_format ) ? $date_format : get_option( 'date_format' );
    $time_format = ! empty( $time_format ) ? $time_format : get_option( 'time_format' );
    $date_format = apply_filters( 'FHEE__espresso_list_of_event_dates__date_format', $date_format );
    $time_format = apply_filters( 'FHEE__espresso_list_of_event_dates__time_format', $time_format );
    EE_Registry::instance()->load_helper( 'Event_View' );
    $datetimes = EEH_Event_View::get_all_date_obj( $EVT_ID, $show_expired, FALSE, $limit );
    if ( ! $format ) {
        return apply_filters( 'FHEE__espresso_list_of_event_dates__datetimes', $datetimes );
    }
    //d( $datetimes );
    if ( is_array( $datetimes ) && ! empty( $datetimes )) {
        global $post;
        $html = $format ? '<ul id="ee-event-datetimes-ul-' . $post->ID . '" class="ee-event-datetimes-ul">' : '';
        foreach ( $datetimes as $datetime ) {
            if ( $datetime instanceof EE_Datetime ) {
                $html .= '<li id="ee-event-datetimes-li-' . $datetime->ID();
                $html .= '" class="ee-event-datetimes-li ee-event-datetimes-li-' . $datetime->get_active_status() . '">';
                $datetime_name = $datetime->name();
                $html .= ! empty( $datetime_name ) ? '<strong>' . $datetime_name . '</strong>' : '';
                $html .= ! empty( $datetime_name )  && $add_breaks ? '<br />' : '';
                $html .= '<span class="dashicons dashicons-calendar"></span>' . $datetime->date_range( $date_format ) . ' : ';
                $html .= '<span class="dashicons dashicons-clock"></span>' . $datetime->time_range( $time_format );
                $datetime_description = $datetime->description();
                $html .= ! empty( $datetime_description )  && $add_breaks ? '<br />' : '';
                $html .= ! empty( $datetime_description ) ? ' - ' . $datetime_description : '';
                $html = apply_filters( 'FHEE__espresso_list_of_event_dates__datetime_html', $html, $datetime );
                $html .= '</li>';
            }
        }
        $html .= $format ? '</ul>' : '';
    } else {
        $html = $format ?  '<p><span class="dashicons dashicons-marker pink-text"></span>' . __( 'There are no upcoming dates for this event.', 'event_espresso' ) . '</p><br/>' : '';
    }
    if ( $echo ) {
        echo $html;
        return '';
    }
    return $html;
}

// Lien d'inscription
function espresso_event_reg_button( $btn_text_if_active = NULL, $btn_text_if_inactive = FALSE, $EVT_ID = FALSE ) {
    EE_Registry::instance()->load_helper( 'Event_View' );
    $event_status = EEH_Event_View::event_active_status( $EVT_ID );
    switch ( $event_status ) {
        case EE_Datetime::sold_out :
            $btn_text = __('Sold Out', 'event_espresso');
            $class = 'ee-pink';
            break;
        case EE_Datetime::expired :
            $btn_text = __('Event is Over', 'event_espresso');
            $class = 'ee-grey';
            break;
        case EE_Datetime::inactive :
            $btn_text = __('Event Not Active', 'event_espresso');
            $class = 'ee-grey';
            break;
        case EE_Datetime::upcoming :
        case EE_Datetime::active :
        default :
            $btn_text =! empty( $btn_text_if_active ) ? $btn_text_if_active : __( 'Register Now', 'event_espresso' );
            $class = 'ee-green';
    }
    if ( $event_status < 1 && ! empty( $btn_text_if_inactive )) {
        $btn_text = $btn_text_if_inactive;
        $class = 'ee-grey';
    }
    ?>
    <a class="ee-button ee-register-button <?php echo $class; ?>" href="<?php espresso_event_link_url(); ?>">
        <?php echo $btn_text; ?>
    </a>
<?php
}

// https://eventespresso.com/topic/ee4-displaying-number-of-tickets-available/#post-104596
// function my_print_tickets_left_after_selector($atts) {
//  global $wpdb;

//  $EVT_ID = $atts['evt_id'];

//  $x = '';
//  $x .= '<ul>';

//  $sql = "SELECT DTT_name, DTT_reg_limit, DTT_sold ";
//  $sql .= "FROM {$wpdb->prefix}esp_datetime ";
//  $sql .= "WHERE {$wpdb->prefix}esp_datetime.EVT_ID = %d";

//  $datetimes = $wpdb->get_results( $wpdb->prepare( $sql, $EVT_ID ));

//  foreach($datetimes as $datetime) {
//      $name = !empty($datetime->DTT_name) ? ($datetime->DTT_name) : 'this event';
//      $limit = $datetime->DTT_reg_limit;
//      $sold = $datetime->DTT_sold;
//      $remainderp = $limit - $sold;
//      $remain = $limit == -1 ? 'bucketloads of' : $remainderp;
//      if ( $limit == $sold ) :
//          $x .= $name . ' is <b>sold out</b>';
//      else :
//      $x .= sprintf( _nx(
//          '%1$sThere is one space left for %3$s</li>',
//          '%1$sThere are %2$s spaces left for %3$s</li>',
//          $remain, 'event ticket info', 'event_espresso' ),
//          '<li style="list-style-type:none;">', $remain, '<span>' . $name . '</span>'
//          );
//      endif;
//  }

//  $x .= '</ul>';

//  return $x;
// }
// add_shortcode( 'show_capacity', 'my_print_tickets_left_after_selector' );

// Désactivation du calendrier iCal
// https://eventespresso.com/wiki/useful-php-code-snippets/#disable-ical
add_action( 'template_redirect', 'my_remove_ical_link' );
function my_remove_ical_link() {
    remove_filter( 'FHEE__espresso_list_of_event_dates__datetime_html', array( 'EED_Ical', 'generate_add_to_iCal_button' ), 10 );
}

function title_format($content) {
return '%s';
}
add_filter('private_title_format', 'title_format');
add_filter('protected_title_format', 'title_format');
