<?php
/*
 * Template Name: Blog blog.php
 * Description: Modèle pour le blog
 *
 * Auteur: Sébastien Chevalley
 * Date: Février 2013
 */
get_header(); ?>

<div class="container">
	<div class="row">
		<div class="col20 sidebarLeft">
			<?php
			// fro: affiche le sous menu dans les pages. (voir code dans functions.php)
			wp_nav_menu( array(
				'menu'			=> '',
				'before'		=> '<div>',
				'after'			=> '</div>',
				'show_parent'	=> true,
				'sub_menu'		=> true
			) );
			?>
		</div>

		<div class="col80">
			<div id="page" class="blog normal ">
				<?php
				$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

				query_posts( array(
					'category_name'		=> 'blog',
					'posts_per_page'	=> 5,
					'paged'				=> $paged
				) );

				if( have_posts() ): while ( have_posts() ): the_post(); ?>

				<div class="content blogpost">
					<div class="col20">
						<?php if( has_post_thumbnail() ): ?>
						<div>
							<?php the_post_thumbnail( 'page-thumb', array( 'class' => 'image-effect' ) ); ?>
							<?php if( !empty( $customFields['legende-photo'][0] ) ): ?>
								<div class="blue-box blue-box-bottom-right legend">
									<?php echo $customFields['legende-photo'][0]; ?>
								</div>
							<?php endif; ?>
						</div>
						<?php endif; ?>
					</div><!-- .col20 -->

					<div class="article the_post col60">
						<?php the_title( '<h2 style="margin-top:0;">', '</h2>' ); ?>

						<div class="metadata">
							<p class="date">le <?php echo get_the_date(); ?></p>
						</div>

						<div class="contenu">
							<?php the_content(); ?>
						</div>
					</div><!-- .article -->

					<div class="clear"></div>
				</div><!-- .content -->
				
				<?php endwhile; 

				$pagination = '';
				ob_start();
				posts_nav_link( '<span></span>','< Précédent', 'Suivant >' );
				$pagination = ob_get_contents();
				ob_end_clean();

				if( !empty( $pagination ) ):
				echo '<div class="content pagination">', $pagination, '</div>';
				endif;
				
				else:
				endif;

				wp_reset_query();
				?>
			</div><!-- .blog -->
		</div><!-- .col20 -->
	</div><!-- .row -->
</div><!-- .container -->

<?php get_footer(); ?>