<?php
/**
 * Template Name: Auteurs felipe
 * Description: Modèle pour la page auteurs
 *
 *
 * Auteur: Sébastien Chevalley
 * Date: Janvier 2011
 */
get_header();

if( have_posts() ): while ( have_posts() ): the_post();
$customFields = array();
$customFields = get_post_custom();
$annee = date( 'Y' );
$exclude = '';

if( get_field( 'annee' ) )
$annee = get_field( 'annee' );
if( get_field( 'exclude_categorie_auteur' ) )
$exclude = get_field( 'exclude_categorie_auteur' );

if( !empty( $customFields['exergue'][0] ) ):
$phraseExergue = $customFields['exergue'][0];
endif;
?>

<div class="container">
    <div class="col20 sidebarLeft">
        <?php
        // fro: affiche le sous menu dans les pages. (voir code dans functions.php)
        wp_nav_menu( array(
            'menu'          => '',
            'before'        => '<div>',
            'after'         => '</div>',
            'show_parent'   => true,
            'sub_menu'      => true
        ) );
        ?>

        <?php
        $searchTxt = "";
        $selectedCategory = "-1";
        if( isset( $_POST['authorNameSearchTxt'] ) )
        $searchTxt = $_POST['authorNameSearchTxt'];
        if( isset( $_POST['authorCategory'] ) )
        $selectedCategory = $_POST['authorCategory'];
        ?>
    </div>

    <div class="col80">
        <div class="container">
            <h1><?php echo get_the_title( $ID ); ?></h1>

            <div class="blockSearch row">
                <p>Rechercher un·e auteur·trice</p>

                <form  name="searchForm" action="<?php the_permalink(); ?>" method="post">
                    <div class="row">
                        <input name="authorNameSearchTxt" type="text" placeholder="Rechercher un·e auteur·trice " value =<?php echo $searchTxt; ?>>
                        <input class="btn" type="submit" value="Rechercher"  />
                    </div>

                    <div class="row">
                    <p>Filtrer les auteurs·trices par&nbsp;:</p>
                        <select name="authorCategory" onchange="this.form.submit()">
                            <option value="-1">-- Recherche par catégorie --</option>
                            <?php
                            $excludeArray = array();
                            /**
                             * English speaking authors                     5
                             * Auteurs wallons                              64
                             * Traducteurs                                  68
                             * Auteurs Rhône-Alpes                          94
                             * Auteurs tessinois                            149
                             * Auteurs suisses                              197
                             * Auteurs francophones                         198
                             * Auteurs jeunesse                             296
                             * Auteurs jeunes adultes                       350
                             * Sélection prix des Libraires                 353
                             * Sélection prix du roman Jeunesse 24heures    354
                             * Auteurs scandinaves                          368
                             * Booktubeuses/Youtubeurs                      369
                             * Place du goût                                370
                             * Auteurs irlandais                            409
                             * Auteurs italiens                             428
                             * Auteurs espagnols                            468
                             * Auteurs néerlandophones                      563
                             * Slow Food                                    612
                             * Auteurs roumains·aines                       756
                             */
                            switch ( $annee ) {
                                case '2014':
                                $excludeArray = array( 'cat_ID' => '185' );
                                break;
                                case '2015':
                                $excludeArray = array( 'cat_ID' => '64' , '94', '149' );
                                break;
                                case '2016':
                                $excludeArray = array( 'cat_ID' => '64' , '94', '149' );
                                break;
                                case '2017':
                                $excludeArray = array( 'cat_ID' => '94' , '368' , '149' , '64' , '369' , '353' , '354' );
                                break;
                                case '2018':
                                $excludeArray = array( 'cat_ID' => '94' , '368' , '149' , '64' , '369' , '353' , '354', '370', '350', '409' );
                                break;
                                case '2019':
                                $excludeArray = array( 'cat_ID' => '64' , '94' , '149' , '353' , '354', '368' , '369' , '370' , '409' , '428' );
                                break;
                                case '2020':
                                $excludeArray = array( 'cat_ID' => '64', '94', '149', '350', '353', '354', '368', '369', '370', '409', '428', '468' );
                                case '2021':
                                $includeArray = array( 'cat_ID' => '198', '296', '197', '5', '68', '563', '612' );
                                case '2022':
                                $includeArray = array( 'cat_ID' => '198', '687', '296', '197', '5', '68' );
                                case '2023':
                                    $includeArray = array( 'cat_ID' => '198', '296', '756', '197', '5', '68' );
                                break;
                                default:;
                            }

                            if($includeArray) {
                                $categorieAuteur = get_terms( 'categories-auteurs', array(
                                    'include'       => $includeArray,
                                    'hide_empty'    => 0
                                ) );
                            }
                            else {
                                $categorieAuteur = get_terms( 'categories-auteurs', array(
                                    'exclude'       => $excludeArray,
                                    'hide_empty'    => 0
                                ) );
                            }
                            
                            if( isset( $categorieAuteur ) && is_array( $categorieAuteur ) ) {
                                for( $i = 0; $i < count( $categorieAuteur ); $i++ ) {
                                    $marginExtra = ( $i == count( $categorieAuteur ) - 1 ) ? ' margin-extra' : '';
                                    printf( '<option %s value="%s">%s</option>', ( $selectedCategory == $categorieAuteur[$i]->slug ? 'selected':'' ), $categorieAuteur[$i]->slug, $categorieAuteur[$i]->name );
                                }
                            }
                            ?>
                        </select>
                    </div>
                </form>
            </div>

            <div id="page" class="row authors_list" data-annee="<?php echo $annee; ?>" data-disable-link="<?php echo get_field( 'disable_link' ); ?>">
                <div>
                    <div><?php the_content(); ?></div>

                    <div class="article">
                        <?php
                        //$cpt=0;
                        //print_r($_POST);
                        if ( isset( $_POST['authorNameSearchTxt'] ) || isset( $_POST['authorCategory'] ) ) {
                            echo llq_auteurPreviewList( $annee, $_POST['authorNameSearchTxt'], $_POST['authorCategory'] );
                        }
                        else {
                            echo $cpt++;
                            echo llq_auteurLightList( $annee );
                        }
                        ?>
                    </div>

                    <div class="clear"></div>
                </div>

                <div class="clear"></div>
            </div>
        </div><!-- .container -->
    </div><!-- .col80 -->

    <?php
    endwhile; else:
    endif;
    ?>

</div><!-- .container -->

<?php get_footer(); ?>
