<?php
/**
 * ichier partiel pour afficher le contenu des pages
 *
 * @link	https://codex.wordpress.org/Template_Hierarchy
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base_Theme
 * @since	CDI_Base_Theme 2.0.4
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_front_page() ) :
			/* Si on est sur la page d'accueil on affiche un titre de niveau 2… */
			the_title( '<h2 class="entry-title">', '</h2>' );
		else :
			/* …sinon on affiche un titre de niveau 1 */
			the_title( '<h1 class="entry-title">', '</h1>' );
		endif;
		?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>

		<div class="home-blocks clearfix">
			<?php if( have_rows('blocks_home') ): ?>
				<?php while( have_rows('blocks_home') ): the_row(); 
					$home_title		= get_sub_field('blocks_home_title');
					$home_icon		= get_sub_field('blocks_home_icon');
					$home_text		= get_sub_field('blocks_home_text');
					$home_lien		= get_sub_field('blocks_home_lien');
					$home_button	= get_sub_field('blocks_home_button');
				?>

				<div class="home-blocks_item">
					<div class="home-blocks_icon">
						<img src="<?php echo $home_icon['url']; ?>" width="512" height="512" alt="" />
					</div>
					
					<div class="home-blocks_content">
						<h3><?php echo $home_title; ?></h3>

						<?php echo $home_text; ?>
						
						<a href="<?php echo $home_lien; ?>" class="button"><?php echo $home_button; ?></a>
					</div>
				</div>

				<?php endwhile; ?>

			<?php endif; ?>

		</div><!-- .home-blocks -->
	</div><!-- .entry-content -->
</article><!-- #post-## -->
