<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<?php wp_head(); ?>
<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<?php
if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}
?>

<div id="site-top" class="">
    <header class="header_top site-wrapper">
        <ul><?php pll_the_languages(['display_names_as' => 'slug']);?></ul>
    </header>

    <header id="site-header" class="site-header site-wrapper" role="banner">
        <div class="site-header_content">
            <?php
            /* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
            if ( is_front_page() ) : ?>
                <h1><?php echo bloginfo( 'name' );?> - <?php echo bloginfo( 'description' ); ?></h1>
                <div class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?= bloginfo('template_url'); ?>-child/images/logo_dls.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" /></a></div> 
            <?php
            /* …sinon on affiche un paragraphe */
            else : ?>
                <p class="site-header_title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?= bloginfo('template_url'); ?>-child/images/logo_dls.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" /></a></p>
            <?php
            endif;

            /*$description = get_bloginfo( 'description', 'display' );
            if ( $description || is_customize_preview() ) : ?>
                <p class="site-header_description"><?php echo $description; ?></p>
            <?php
            endif;*/ ?>

            <div class="nav_box">
                <div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
                <input type="checkbox" id="mobile_navigation" class="hidden" />
                <label for="mobile_navigation" class="menu_mobile hidden">
                    <i class="fas fa-bars" aria-hidden="true"></i>
                </label>
                <nav id="site-navigation" class="site-navigation" role="navigation">
                    <?php wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'menu_id' => 'primary-menu',
                        'container' => false
                    ) ); ?>
                </nav><!-- #site-navigation -->
            </div>
        </div>
    </header><!-- #site-header -->

    <!--<div id="site-search" class="site-search">
        <?php //get_search_form() ?>
    </div>-->

    <div id="site-content-wrapper" class="site-content-wrapper">
