<?php
/**
 * CDI Base Child : fonctions du thème.
 *
 * @link	https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions ACF
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles du thème
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
*/


/* == @section Fonctions ACF ==================== */
if( function_exists('acf_add_options_page') ) {
	acf_add_options_page();
	acf_add_options_sub_page('Footer');
	acf_add_options_sub_page('Header');
}


/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
	 */
	load_child_theme_textdomain( 'cdi-base-child', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
	// ) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On supprime le support des Images à la Une par défaut
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'post-thumbnails' );

	/* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On supprime le support les adresses de flux dans <head>
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
// function remove_cdiwpchild_widgets() {
// 	unregister_sidebar( 'sidebar-1' );
// }
// add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

 /**
 * Register footer widget area.
 *
 * @since Twenty Fifteen Child 1.0
 *
 * @link https://codex.wordpress.org/Function_Reference/register_sidebar
 */
function cdiwpchild_widgets_init() {
	register_sidebar( array(
	  'name'          => __( 'Footer Widget 1', 'cdi-base-child' ),
	  'id'            => 'footer-widget-1',
	  'description'   => __( 'Add widgets here to appear in your footer area.', 'cdi-base-child' ),
	  'before_widget' => '<div id="%1$s" class="widget %2$s">',
	  'after_widget'  => '</div>',
	  'before_title'  => '<h2 class="widget-title">',
	  'after_title'   => '</h2>',
	) );

	for ( $i = 1; $i < 4; $i ++ ) {
		register_sidebar(
			array(
				'id'            => 'footer-widget-' . $i,
				'name'          => sprintf( esc_html__( 'Footer Widget %s', 'cdi-base-child' ), $i ),
				'description'   => esc_html__( 'Add widgets here to appear in your footer area.', 'cdi-base-child' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="widget-title">',
				'after_title'   => '</div>',
			)
		);
	}
  }
  add_action( 'widgets_init', 'cdiwpchild_widgets_init' );

/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		wp_get_theme()->get('Version'),
		'all'
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	// require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	// require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}


/* Avoid useless <p> tags on contact form 7 plugin */
add_filter('wpcf7_autop_or_not', '__return_false');


/* Remove the "Howdy" from the header in the upper righthand corner and replace with "Welcome" */
add_filter('gettext', 'change_howdy', 10, 3);

function change_howdy($translated, $text, $domain) {

    if (!is_admin() || 'default' != $domain)
        return $translated;

    if (false !== strpos($translated, 'Howdy'))
        return str_replace('Howdy', 'Welcome', $translated);

    return $translated;
}


/* Make Preview visible again for pages including Advanced Custom Plugin https://support.advancedcustomfields.com/forums/topic/preview-solution/page/3/ */
function fix_post_id_on_preview($null, $post_id) {
    if (is_preview()) {
        return get_the_ID();
    }
    else {
        $acf_post_id = isset($post_id->ID) ? $post_id->ID : $post_id;

        if (!empty($acf_post_id)) {
            return $acf_post_id;
        }
        else {
            return $null;
        }
    }
}
add_filter( 'acf/pre_load_post_id', 'fix_post_id_on_preview', 10, 2 );