<?php
/**
 * Fichier pour afficher la page d'accueil
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.1
 */
$lang = get_locale();

get_header(); ?>

    <div id="site-content" class="site-content">
        <main id="main" class="site-main" role="main">
            <div class="entry-content">
            
                <section class="wp-block-wdp-section-block dark_section">
                    <div class="wp-block-columns">
                        <div class="wp-block-column">
                            <p class="small_title"><?php the_field('hp_s1_small_title_'.$lang); ?></p>
                            <h2 class="title_banner"><?php the_field('hp_s1_title_'.$lang); ?></h2>
                            <p><?php the_field('hp_s1_text_'.$lang); ?></p>
                        </div>
                        
                        <div class="wp-block-column">
                            <div class="wp-block-image appear-right blue-shadow">
                                <?php
                                $hp_s1_pic = get_field('hp_s1_pic');
                                if ($hp_s1_pic) {
                                    echo wp_get_attachment_image($hp_s1_pic['ID'], 'full');
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </section>
                
                <section class="wp-block-wdp-section-block light_section">
                    <h2 class="has-text-align-center main_section_title"><?php the_field('hp_s2_title_'.$lang); ?></h2>
                        <?php for ($i=1; $i <= 6; $i++) {
                            if ($i%2 == 1)
                                echo '<div class="wp-block-columns">';
                            $hp_s2_link = get_field('hp_s2_b'.$i.'_link_'.$lang); ?>
                            <div class="wp-block-column wp-block-group box">
                                <div class="wp-block-group__inner-container has-text-align-center">
                                    <div class="box_pic ratio_16-7">
                                        <a href="<?php echo $hp_s2_link['url']; ?>" target="<?php echo $hp_s2_link['target']; ?>">
                                            <?php
                                            $hp_s2_pic = get_field('hp_s2_b'.$i.'_pic');
                                            if ($hp_s2_pic) {
                                                echo wp_get_attachment_image($hp_s2_pic['ID'], 'full');
                                            }
                                            ?>
                                        </a>
                                    </div>

                                    <h3><?php the_field('hp_s2_b'.$i.'_title_'.$lang); ?></h3>
                                    
                                    <p class="big_text">
                                        <?php the_field('hp_s2_b'.$i.'_text_'.$lang); ?>
                                    </p>
                                    <a class="button" href="<?php echo $hp_s2_link['url']; ?>" target="<?php echo $hp_s2_link['target']; ?>">
                                        <?php echo $hp_s2_link['title']; ?>
                                    </a>
                                </div>
                            </div>
                        <?php 
                            if ($i%2 != 1)
                                echo '</div>';
                        
                            $next = $i+1;
                            if (!get_field('hp_s2_b'.$next.'_link_'.$lang)) {
                                if ($i%2 == 1)
                                    echo '</div>';
                                break;
                            }

                        } ?>
                </section>
            </div>

            <?php
            /* Début de la boucle 
            while ( have_posts() ) : the_post();

                get_template_part( 'template-parts/content', 'front' );

            endwhile;*/
            ?>

        </main><!-- #main -->
    </div><!-- #site-content -->

<?php
get_sidebar();
get_footer();
