<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */

 $lang = get_locale();
?>

    </div><!-- #site-content -->

    <footer id="site-footer" class="site-footer" role="contentinfo">
        <div class="site-footer_box site-wrapper">
            <div class="site-footer_content">

                <?php if ( is_active_sidebar( 'footer-widget-1' )  ) : ?>
                    <div class="widget-area col col1" role="complementary">
                        <?php dynamic_sidebar( 'footer-widget-1' ); ?>
                    </div>
                <?php endif;

                if ( is_active_sidebar( 'footer-widget-2' )  ) : ?>
                    <div class="widget-area col col2" role="complementary">
                        <?php dynamic_sidebar( 'footer-widget-2' ); ?>
                    </div>
                <?php endif;

                if ( is_active_sidebar( 'footer-widget-3' )  ) : ?>
                    <div class="widget-area col col3" role="complementary">
                        <?php dynamic_sidebar( 'footer-widget-3' ); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="site-footer_info">
            &copy; DLS <?php echo date( 'Y' ); ?>
            <span class="sep"> | </span>
            <?php printf( esc_html__( '%1$s %2$s', 'cdi-base' ), 'Créé par', '<a href="https://www2.cdi.ch" target="_blank">CDI SA</a>' ); ?>
        </div><!-- .site-footer_info -->
    </footer><!-- #site-footer -->
</div><!-- #site-top -->

<?php wp_footer(); ?>

</body>
</html>
