<?php
/**
 * Fichier pour afficher la page d'erreur 404 (page non trouvée)
 *
 * @link    https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
get_header(); ?>

    <div id="site-content" class="site-content">
        <main id="main" class="site-main" role="main">

            <section class="error-404 not-found">
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'cdi-base' ); ?></h1>
                </header><!-- .page-header -->

                <div class="page-content">
                    <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'cdi-base' ); ?></p>

                    <?php 
                        get_search_form();

                        wp_nav_menu( array(
                            'theme_location' => 'primary',
                            'menu_id' => 'primary-menu',
                            'container' => false
                        ) );

                    ?>
                </div><!-- .page-content -->
            </section><!-- .error-404 -->

        </main><!-- #main -->
    </div><!-- #site-content -->

<?php
get_footer();
