<?php
/**
 * Fonctions du thème
 *
 * @link	https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author	Luc Poupard
 *
 * @package	CDI_Base_Child 2.1.0
 * @since	CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
	== Fonctions WordPress
		-- Traductions
		-- Menus de navigation
		-- Images à la Une
		-- Flux RSS
	== Widgets
	== Ajout des styles du thème
	== Fonctions externalisées
		-- Global
		-- Front
		-- Administration
	== Shortcodes
		-- Home
		-- Comité de parrainage
		-- Paypal
*/


/* == @section Fonctions WordPress ==================== */
function cw4b_setup() {
	/* -- @subsection Traductions -------------------- */
	/**
	 * Préparer le thème pour traduction.
	 * Les traductions sont placées dans le répertoire /languages/
	 * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
	 */
	load_child_theme_textdomain( 'cw4b', get_stylesheet_directory() . '/languages' );


	/* -- @subsection Menus de navigation -------------------- */
	/**
	 * Déclaration du menu de navigation principal.
	 */
	// register_nav_menus( array(
	// 	'secondary' => esc_html__( 'Secondary menu', 'cdi-base-child' ),
	// ) );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'footer' => esc_html__( 'Footer Menu', 'cw4b' ),
	) );


	/* -- @subsection Images à la Une -------------------- */
	/**
	 * On supprime le support des Images à la Une par défaut
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'post-thumbnails' );

	/* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
	// set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


	/* -- @subsection Flux RSS -------------------- */
	/**
	 * On supprime le support les adresses de flux dans <head>
	 * Pour conserver le support, commenter la ligne suivante.
	 */
	remove_theme_support( 'automatic-feed-links' );	
}
add_action( 'after_setup_theme', 'cw4b_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
// function remove_cdiwpchild_widgets() {
// 	unregister_sidebar( 'sidebar-1' );
// }
// add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */


/* == @section Nettoyage de l'entête ==================== */

/* Suppression des styles de plugins */
add_filter( 'wpcf7_load_css', '__return_false' );


/* == @section Ajout des styles du thème ==================== */
add_action( 'wp_enqueue_scripts', 'cw4b_styles' );
if ( ! function_exists( 'cw4b_styles' ) ) {
function cw4b_styles() {
	wp_register_style(
		'all',
		get_stylesheet_directory_uri().'/css/styles.css',
		false,
		null,
		'all'
	);

	wp_register_script(
		'menu-mobile',
		get_stylesheet_directory_uri() . '/js/navigation.js',
		false,
		null,
		true
	);

	// On ajoute les fichiers à la queue
	wp_enqueue_style( 'all' );
	wp_enqueue_script( 'menu-mobile' );
	}
}


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */

/* -- @subsection Global -------------------- */
/* Grand ménage dans <head> */
// require get_stylesheet_directory() . '/functions/global_head-cleaning.php';

/* Cacher des items de la barre d'admin */
// require get_stylesheet_directory() . '/functions/global_admin-bar.php';


/* -- @subsection Front -------------------- */
/**
 * Fonctions pour personnaliser les pages publiques.
 */

/* Nettoyage des classes générées de la navigation */
// require get_stylesheet_directory() . '/functions/front_menu-classes.php';


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
	/* Notification de mises à jour du thème */
	require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

	/* Ajouter des droits à des utilisateurs */
	// require get_stylesheet_directory() . '/functions/admin_capabilities.php';

	/* Cacher des items du menu aux non administrateurs */
	require get_stylesheet_directory() . '/functions/admin_menu.php';

	/* Cacher les widgets du dashboard */
	// require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}


/* == @section Shortcodes ==================== */
/**
*  @author Luc Poupard
*  @see http://wp-themes-pro.com/shortcode-wordpress/
*/

/* On empêche l'insertion de <p> et <br> automatique dans les shortcodes
 * @see http://sww.co.nz/solution-to-wordpress-adding-br-and-p-tags-around-shortcodes/
 *
 * @note Pour que les balises <p> et <br /> soient gérées dans le shortcode,
 * ajoutez la ligne suivante dans la fonction du shortcode :
 * $content = wpautop( trim( $content ) );
 */
remove_filter( 'the_content', 'wpautop' );
add_filter( 'the_content', 'wpautop' , 99);


/* -- @subsection Home -------------------- */
// Ligne de blocs
function cw4b_widget_row( $atts, $content = null ) {
	// Attributes
	extract( shortcode_atts(
		array(
			'class' => '', /* Possibilité d'ajouter une class sur la ligne pour des besoin particuliers*/
		), $atts )
	);
	// Code
	return '<div class="cdi-widget-row ' . $class . '">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'row', 'cw4b_widget_row' );

// Bloc 100 % image/texte
function cw4b_widget_100_img_txt( $atts, $content = null ) {
  return '<div class="cdi-widget-100-img-txt">' . do_shortcode($content) . '</div>';
}
add_shortcode( '100_img_txt', 'cw4b_widget_100_img_txt' );

// Bloc 100 % texte/image
function cw4b_widget_100_txt_img( $atts, $content = null ) {
  return '<div class="cdi-widget-100-txt-img">' . do_shortcode($content) . '</div>';
}
add_shortcode( '100_txt_img', 'cw4b_widget_100_txt_img' );

// Bloc 70 % image/texte
function cw4b_widget_70_img_txt( $atts, $content = null ) {
  return '<div class="cdi-widget-70-img-txt">' . do_shortcode($content) . '</div>';
}
add_shortcode( '70_img_txt', 'cw4b_widget_70_img_txt' );

// Bloc 70 % texte/image
function cw4b_widget_70_txt_img( $atts, $content = null ) {
  return '<div class="cdi-widget-70-txt-img">' . do_shortcode($content) . '</div>';
}
add_shortcode( '70_txt_img', 'cw4b_widget_70_txt_img' );

// Bloc 15 % texte/image
function cw4b_widget_15( $atts, $content = null ) {
  return '<div class="cdi-widget-15">' . do_shortcode($content) . '</div>';
}
add_shortcode( '15', 'cw4b_widget_15' );

// Bloc image
function cw4b_widget_img( $atts, $content = null ) {
  return '<div class="cdi-widget-img">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'img', 'cw4b_widget_img' );

// Bloc texte
function cw4b_widget_txt( $atts, $content = null ) {
  $content = wpautop( trim( $content ) );
  return '<div class="cdi-widget-txt">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'txt', 'cw4b_widget_txt' );


/* -- @subsection Comité de parrainage -------------------- */
// Ligne
function cw4b_team_member( $atts, $content = null ) {
  return '<div class="team-member">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'member', 'cw4b_team_member' );

// Photo
function cw4b_team_photo( $atts, $content = null ) {
  return '<div class="team-pic">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'photo', 'cw4b_team_photo' );

// Bio
function cw4b_team_bio( $atts, $content = null ) {
  $content = wpautop( trim( $content ) );
  return '<div class="team-bio">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'bio', 'cw4b_team_bio' );


/* -- @subsection Paypal -------------------- */
// Euros FR
function cw4b_paypal_euro_fr() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="3PX55BJLCEFX4"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-fr-eur.png" border="0" name="submit" alt="PayPal, le réflexe sécurité pour payer en ligne"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_eur_fr', 'cw4b_paypal_euro_fr' );

// Dollars FR
function cw4b_paypal_dollars_fr() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="BR8QGXZRTDT8W"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-fr-usd.png" border="0" name="submit" alt="PayPal, le réflexe sécurité pour payer en ligne"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_usd_fr', 'cw4b_paypal_dollars_fr' );

// Francs suisses FR
function cw4b_paypal_chf_fr() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="GFU493XDJHXF2"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-fr-chf.png" border="0" name="submit" alt="PayPal, le réflexe sécurité pour payer en ligne"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_chf_fr', 'cw4b_paypal_chf_fr' );

// Euros EN
function cw4b_paypal_euro_en() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="MMJMXD5UPDG9Q"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-en-eur.png" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_eur_en', 'cw4b_paypal_euro_en' );

// Dollars EN
function cw4b_paypal_dollars_en() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="83VZ9ESLH43T6"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-en-usd.png" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_usd_en', 'cw4b_paypal_dollars_en' );

// Francs suisses EN
function cw4b_paypal_chf_en() {
	return '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top"><input type="hidden" name="cmd" value="_s-xclick"><input type="hidden" name="hosted_button_id" value="3DAGU9EZSDUEE"><input type="image" src="http://www.cleanwater4benin.org/wp-content/uploads/2015/12/paypal-en-chf.png" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!"><img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1"></form>';
}
add_shortcode( 'paypal_chf_en', 'cw4b_paypal_chf_en' );