<?php
/**
 * Entête de page
 *
 * C'est le template qui affiche la balise <head> et tout le contenu
 * jusqu'au contenu <div id="content">.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="format-detection" content="telephone=no">
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<?php wp_head(); ?>

<meta name="msapplication-TileColor" content="#da532c">
<meta name="msapplication-config" content="<?= get_stylesheet_directory_uri(); ?>/images/favicon/browserconfig.xml">
<meta name="theme-color" content="#ffffff">

<script>document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/,'js');</script>
</head>

<body <?php body_class(); ?> role="document">
<?php
if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}
?>
<div class="site-background"><?php /* Cette div sert à ajouter un fond qui aurait un positionnement particulier (fixé en bas de la fenêtre par exemple) */ ?></div>

<div id="site-top" class="site-wrapper">
    <a href="#site-menu" class="screen-reader-text"><span><?php esc_html_e( 'Skip to navigation', 'cdi-base' ); ?></span></a>
    <a href="#site-content" class="screen-reader-text"><span><?php esc_html_e( 'Skip to content', 'cdi-base' ); ?></span></a>
    <a href="#site-search" class="screen-reader-text"><span><?php esc_html_e( 'Skip to search', 'cdi-base' ); ?></span></a>

    <header id="site-header" class="site-header" role="banner">
        <?php
            $custom_logo_id = get_theme_mod( 'custom_logo' );
            $logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );

        /* Si on est sur la page d'accueil du site, on affiche un titre de niveau 1… */
        if ( is_front_page() ) { ?>
            <h1><?php echo bloginfo( 'name' );?> - <?php echo bloginfo( 'description' ); ?></h1>
            <div class="site-header_title">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <!--<img src="<?= get_stylesheet_directory_uri(); ?>/images/logo_crc.svg" alt="<?= bloginfo( 'name' ); ?>" title="<?= bloginfo( 'name' ); ?>" />-->
                    <?php
                        if ( has_custom_logo() ) {
                            echo '<img src="' . esc_url( $logo[0]) . '" alt="' . get_bloginfo( 'name' ) . '">';
                        } else {
                            echo '<h1>'. get_bloginfo( 'name' ) .'</h1>';
                        }
                    ?>
                </a>
            </div> 
        <?php }
        /* …sinon on affiche un paragraphe */
        else { ?>
            <p class="site-header_title">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php
                        if ( has_custom_logo() ) {
                                echo '<img src="' . esc_url( $logo[0]) . '" alt="' . get_bloginfo( 'name' ) . '">';
                        } else {
                                echo '<h1>'. get_bloginfo( 'name' ) .'</h1>';
                        }
                    ?>
                </a>
            </p>
        <?php }

        $description = get_bloginfo( 'description', 'display' );
        if ( $description || is_customize_preview() ) : ?>
            <p class="site-header_description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
        <?php
        endif; ?>

        <div id="site-menu"><?php /* Cette div sert pour le lien d'évitement vers la navigation. Ne rien mettre entre #site-menu et #site-navigation */ ?></div>
        <div class="menu_mobile hidden">
            <button class="menu-toggle" id="menu-toggle" aria-expanded="false"><span class="screen-reader-text">Menu</span>
                <svg class="icon icon-menu-toggle" aria-hidden="true" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100">
                    <g class="svg-menu-toggle">
                        <path class="line line-1" d="M5 13h90v14H5z"/>
                        <path class="line line-2" d="M5 43h90v14H5z"/>
                        <path class="line line-3" d="M5 73h90v14H5z"/>
                    </g>
                </svg>
            </button>
        </div>
        <nav id="site-navigation" class="site-navigation" role="navigation">
            <?php wp_nav_menu( array(
                'theme_location' => 'primary',
                'menu_id' => 'primary-menu',
                'container' => false
            ) ); ?>
        </nav><!-- #site-navigation -->
    </header><!-- #site-header -->

    

    <div id="site-search" class="site-search">
        <?php get_search_form() ?>
    </div>

    <div id="site-content-wrapper" class="site-content-wrapper">
