<?php
/**
 * CDI Base Child : fonctions du thème.
 *
 * @link    https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base_Child 2.1.0
 * @since   CDI_Base_Child 2.0.0
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Fonctions WordPress
        -- Traductions
        -- Images à la Une
        -- Flux RSS
    == Widgets
    == Ajout des styles du thème
    == Fonctions externalisées
        -- Global
        -- Front
        -- Administration
*/

/* == @section Fonctions ACF ==================== */
if( function_exists('acf_add_options_page') ) {
	acf_add_options_page();
	acf_add_options_sub_page('Footer');
	acf_add_options_sub_page('Header');
}

/* == @section Fonctions WordPress ==================== */
function cdiwpchild_setup() {
    /* -- @subsection Traductions -------------------- */
    /**
     * Préparer le thème pour traduction.
     * Les traductions sont placées dans le répertoire /languages/
     * Pour traduire un terme : esc_html__( 'Terme à traduire', 'cdi-base-child' )
     */
    load_child_theme_textdomain( 'cdi-base-child', get_stylesheet_directory() . '/languages' );


    /* -- @subsection Images à la Une -------------------- */
    /**
     * On supprime le support des Images à la Une par défaut
     * Pour conserver le support, commenter la ligne suivante.
     */
    remove_theme_support( 'post-thumbnails' );

    /* Si les Images à la Une sont utilisées, ajouter des tailles personnalisées ici */
    // set_post_thumbnail_size( 400, 9999 ); // (largeur, hauteur) ; 9999 = illimité


    /* -- @subsection Flux RSS -------------------- */
    /**
     * On supprime le support les adresses de flux dans <head>
     * Pour conserver le support, commenter la ligne suivante.
     */
    remove_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'cdiwpchild_setup' );


/* == @section Widgets ==================== */
/**
 * @note Fonction pour supprimer la sidebar du thème parent. À décommenter si besoin.
 */
function remove_cdiwpchild_widgets() {
    unregister_sidebar( 'sidebar-1' );
}
add_action( 'widgets_init', 'remove_cdiwpchild_widgets' );

/**
 * Pour ajouter des zone de widgets supplémentaires :
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */


/* == @section Ajout des styles du thème ==================== */
function cdiwpchild_styles() {
    $themeversion = wp_get_theme()->get('Version');
    wp_register_style(
        'all',
        get_stylesheet_directory_uri().'/css/styles.css',
        false,
        $themeversion,
        'all'
    );

    wp_register_script(
        'js',
        get_stylesheet_directory_uri() . '/js/global.js',
        false,
        $themeversion,
        false
    );

    // On ajoute les fichiers à la queue
    wp_enqueue_style( 'all' );
    wp_enqueue_script( 'js' );
}
add_action( 'wp_enqueue_scripts', 'cdiwpchild_styles' );


/* == @section Fonctions externalisées ==================== */
/**
 * @note Il s'agit de paramètres par défaut. Pour personnaliser ces fonctions, décommentez la ligne correspondante
 * et effectuez vos personnalisations dans le fichier.
 */


/* -- @subsection Administration -------------------- */
/**
 * Fonctions pour personnaliser l'administration.
 */
if ( is_admin() ) {
    /* Notification de mises à jour du thème */
    require get_stylesheet_directory() . '/functions/admin_update-notifier.php';

    /* Ajouter des droits à des utilisateurs */
    // require get_stylesheet_directory() . '/functions/admin_capabilities.php';

    /* Cacher des items du menu aux non administrateurs */
    // require get_stylesheet_directory() . '/functions/admin_menu.php';

    /* Cacher les widgets du dashboard */
    // require get_stylesheet_directory() . '/functions/admin_dashboard-widgets.php';
}

add_theme_support( 'align-wide' );

function theme_support_options() {
    $defaults = array(
        'height'      => 392,
        'width'       => 380,
        'flex-height' => true,
        'flex-width'  => true
    );
    add_theme_support( 'custom-logo', $defaults );
}
add_action( 'after_setup_theme', 'theme_support_options' );
