<?php
/**
 * Pied de page
 *
 * C'est le template qui affiche la fermeture du contenu <div id="content">
 * et tout ce qui suit.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.1
 * @since   CDI_Base 2.0.0
 */
?>
        <div class="buttons-group">
            <?php for ($i=1; $i <= 3; $i++) {
                $footer_buttons = get_field('access_button_'.$i, 'option'); ?>
                <a href="<?php echo $footer_buttons['url']; ?>" target="_blank" class="button button-access-<?= $i; ?>"><?php echo $footer_buttons['title']; ?></a>
            <?php } ?>
        </div>

    </div><!-- #site-content -->
</div><!-- #site-top -->
<footer id="site-footer" class="site-footer" role="contentinfo">
    <div class="site-footer_info">

        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="footer-logo">
            <img src="<?= the_field('footer_logo', 'option'); ?>" alt="">
        </a>

        <p class="copyright">&copy; <?php echo date( 'Y' ); ?> <?= the_field('footer_copyright', 'option'); ?> </p>
        <!-- <p class="created-by"><?php printf( esc_html__( 'Crée par %2$s', 'cdi-base' ), 'CDI Base', '<a href="https://www2.cdi.ch">CDI SA</a>' ); ?></p> -->
    </div><!-- .site-footer_info -->
</footer><!-- #site-footer -->

<?php wp_footer(); ?>

</body>
</html>
