<?php
/**
 * Fichier partiel pour afficher le contenu des articles
 *
 * C'est le template par défaut pour afficher les articles.
 * Il est utilisé par défaut si aucun template n'est trouvé pour le format d'article.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.0
 * @since   CDI_Base 2.0.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if ( is_home() || is_archive() ): ?>

        <header class="news-header">
            <?php the_title( '<h2 class="entry-title">', '</h2>' ); ?>
        </header><!-- .entry-header -->

    <?php else: ?>

        <header class="entry-header">
            <?php the_title( '<h1 class="entry-title">', '</h1>' );

            if ( function_exists('ffeeeedd__ariane') && !is_front_page() ):
                ffeeeedd__ariane();
            endif; ?>
        </header><!-- .entry-header -->
    <?php endif; ?>

    <div class="entry-content">
        <?php if ( 'post' === get_post_type() ) : ?>
            <div class="entry-meta">
                Publié le <time datetime="<?php echo get_the_date('c'); ?>" itemprop="datePublished"><?php echo get_the_date( 'j F Y' ); ?></time>
            </div><!-- .entry-meta -->
        <?php endif; ?>

        <?php
            the_content( sprintf(
                /* translators: %s: Name of current post. */
                wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'cdi-base' ), array( 'span' => array( 'class' => array() ) ) ),
                the_title( '<span class="screen-reader-text">"', '"</span>', false )
            ) );
        ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
