<?php
/*
Template Name: Accueil
*/
/**
 * The template for displaying the front page.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package     CIMV_1.0.0
 * @since       1.0.0
 */


get_header(); ?>

    <main id="main" class="site-main" role="main">

        <?php while ( have_posts() ) : the_post(); ?>

            <div class="carrousel photo-carrousel">
                <div class="carrousel__container"
                data-carrousel-btn-previous-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-previous.png' ?>"
                data-carrousel-btn-next-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-next.png' ?>"
                data-carrousel-btn-previous-text="Précédent"
                data-carrousel-btn-next-text="Suivant"
                data-carrousel-prefix-classes="photo"
                data-carrousel-transition="slide"
                data-carrousel-hx="h2">

                <?php if( have_rows('accueil_carrousel') ): ?>

                    <?php while( have_rows('accueil_carrousel') ): the_row();
                    // vars
                    $carrousel_item = get_sub_field('carrousel_image');
                    ?><!--
                    --><div class="carrousel__content"><img src="<?php echo $carrousel_item['url']; ?>" alt="" /></div><!--
                    --><?php endwhile; ?>

                <?php endif; ?>

                </div>
            </div>

            <?php
            global $post;

            $args_news = array(
                'post_type' => 'post',
                'nopaging' => false,
                'posts_per_page' => '3',
            );
            $loop_news = new WP_Query( $args_news );

            if( $loop_news->have_posts() ):
                // Pour usage futur si on masque après un certains temps
                // $count_posts = wp_count_posts( );
                // if( wp_count_posts()->publish === 1 ) :
                //     echo '1 seul post';
                // else:
                //     echo 'plus d'un;
                // endif;
            ?>

            <div class="news">

                <div class="carrousel news-carrousel">
                    <div class="carrousel__container"
                    data-carrousel-btn-previous-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-previous-news.png' ?>"
                    data-carrousel-btn-next-img="<?php echo get_stylesheet_directory_uri() . '/img/arrow-next-news.png' ?>"
                    data-carrousel-btn-previous-text="Précédent"
                    data-carrousel-btn-next-text="Suivant"
                    data-carrousel-prefix-classes="news"
                    data-carrousel-transition="fade"
                    data-carrousel-existing-hx="h3">

                        <?php while ( $loop_news->have_posts() ) : $loop_news->the_post(); ?>

                            <div class="carrousel__content<?php if (!has_post_thumbnail( $post->ID ) ) {echo ' no-image';}?>">
                                <?php if (has_post_thumbnail( $post->ID ) ): ?>
                                    <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                                    <div class="carousel-img" style="background-image: url('<?php echo $image[0]; ?>')"></div>
                                <?php endif; ?>
                                <div class="news-content">
                                <h2>News du CIMV</h2>
                                    <h3><?php the_title(); ?></h3>

                                    <div>
                                        <?php echo the_excerpt(); ?>

                                        <div class="news-button">
                                            <a href="<?php the_permalink(); ?>" class="button">En savoir plus</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php endwhile; ?>

                    </div>
                </div>
            </div><!-- .news -->

            <?php
            endif;
            wp_reset_postdata();
            ?>

            <div id="post-<?php the_ID(); ?>" class="home-content clearfix">
                <div class="home-bienvenue">
                    <?php
                    /*
                     * On récupère les données des champs ACF
                     * @note Utilisation de la fonction native get_post_meta plutôt que du the_field d'ACF
                     * @link https://www.gregoirenoyelle.com/wordpress-reduire-dependances-avanced-custom-fields/
                     *
                     * Ex ACF : <?php the_field( 'accueil_titre' ); ?>
                     *
                     * @note Shortcode
                     * @link http://www.billerickson.net/advanced-custom-fields-frontend-dependency/#comment-255652
                     */
                    $accueil_titre = esc_html( get_post_meta( get_the_ID(), 'accueil_titre', true ) );

                    /*
                     * @note Pour les champs contenant du formatage HTML
                     * @link https://www.gregoirenoyelle.com/wordpress-reduire-dependances-avanced-custom-fields/#comment-39475
                     */
                    $accueil_texte = apply_filters( 'the_content', get_post_meta( get_the_ID(), 'accueil_texte', true ) );
                    ?>

                    <h2><?php echo $accueil_titre ?></h2>
                    <div><?php echo $accueil_texte ?></div>
                </div>

                <div class="home-equipe">
                    <?php
                    /*
                     * @note On récupère l'ID puis ensuite le permalien
                     */
                    $equipe_lien = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_lien', true ) );
                    $equipe_lien = esc_url( get_permalink( $equipe_lien ) );

                    $equipe_texte = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_title_lien', true ) );

                    $equipe_image = esc_html( get_post_meta( get_the_ID(), 'bloc_equipe_image', true ) );
                    $equipe_image = wp_get_attachment_image( $equipe_image, 'full' );
                    ?>

                    <?php echo $equipe_image ?>

                    <a href="<?php echo $equipe_lien ?>" class="button"><?php echo $equipe_texte ?></a>
                </div>

                <div class="home-prestations">
                    <?php
                    /*
                     * @note On récupère l'ID puis ensuite le permalien
                     */
                    $prestation_lien = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_lien', true ) );
                    $prestation_lien = esc_url( get_permalink( $prestation_lien ) );

                    $prestation_texte = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_title_lien', true ) );

                    $prestation_image = esc_html( get_post_meta( get_the_ID(), 'bloc_prestation_image', true ) );
                    $prestation_image = wp_get_attachment_image( $prestation_image, 'full' );
                    ?>

                    <?php echo $prestation_image ?>

                    <a href="<?php echo $prestation_lien ?>" class="button"><?php echo $prestation_texte ?></a>
                </div>
            </div>

        <?php endwhile; // End of the loop. ?>

    </main>

<?php get_footer(); ?>
