<?php
/**
 * Fonction pour gérer des pages d'erreurs personnalisées
 *
 * @author  Luc Poupard
 *
 * @package CDI_Base 2.1.0
 * @since   CDI_Base 2.0.1
 */


/* ----------------------------- */
/* Sommaire */
/* ----------------------------- */
/*
    == Erreurs 403 et 401 personnalisées
    == Remplacer la page d'erreur WordPress
 */


/* == @section Erreurs 403 et 401 personnalisées ==================== */
/**
 * On redirige les erreurs 403 et 401 vers des templates personnalisés.
 * @see http://websistent.com/wordpress-custom-403-401-error-page/
 */
function cdiwp_error_pages() {
    global $wp_query;

    if( isset( $_REQUEST['status'] ) && $_REQUEST['status'] == 403 ) {
        $wp_query->is_404 = FALSE;
        $wp_query->is_page = TRUE;
        $wp_query->is_singular = TRUE;
        $wp_query->is_single = FALSE;
        $wp_query->is_home = FALSE;
        $wp_query->is_archive = FALSE;
        $wp_query->is_category = FALSE;
        add_filter( 'wp_title', 'cdiwp_error_title', 65000, 2 );
        add_filter( 'body_class', 'cdiwp_error_class' );
        status_header( 403 );
        get_template_part( '403' );
        exit;
    }

    if( isset( $_REQUEST ['status'] ) && $_REQUEST['status'] == 401 ) {
        $wp_query->is_404 = FALSE;
        $wp_query->is_page = TRUE;
        $wp_query->is_singular = TRUE;
        $wp_query->is_single = FALSE;
        $wp_query->is_home = FALSE;
        $wp_query->is_archive = FALSE;
        $wp_query->is_category = FALSE;
        add_filter( 'wp_title', 'cdiwp_error_title', 65000, 2 );
        add_filter( 'body_class', 'cdiwp_error_class' );
        status_header( 401 );
        get_template_part( '401' );
        exit;
    }
}

function cdiwp_error_title( $title = '', $sep = '' ) {
    if( isset( $_REQUEST['status'] ) && $_REQUEST['status'] == 403 )
        return "Forbidden " . $sep . " " . get_bloginfo( 'name' );

    if( isset( $_REQUEST['status'] ) && $_REQUEST['status'] == 401 )
        return "Unauthorized " . $sep . " " . get_bloginfo( 'name' );
}

function cdiwp_error_class( $classes ) {
    if( isset( $_REQUEST['status'] ) && $_REQUEST['status'] == 403 ) {
        $classes[] = 'error403';
        return $classes;
    }

    if( isset( $_REQUEST['status'] ) && $_REQUEST['status'] == 401 ) {
        $classes[] = 'error401';
        return $classes;
    }
}

add_action( 'wp', 'cdiwp_error_pages' );


/* == @section Remplacer la page d'erreur WordPress ==================== */
/**
 * On affiche la page d'erreur 404 au lieu de l'erreur par défaut.
 * @see http://www.binarynote.com/hide-wordpress-error-messages.html
 */

function cdiwp_die_handler() {
    global $wp;
    $wp->handle_404();
    load_template( get_404_template() );
    die();
}
add_filter( 'wp_die_handler', 'cdiwp_die_handler' );
