<?php
/**
 * Retrait des attributs titles inutiles
 *
 * En plus d'être inutiles, les attributs title sur les liens peuvent être fortement redondants
 * pour les utilisateurs de synthèse vocale. On les supprime donc.
 *
 * @author  Luc Poupard
 *
 * @link    https://github.com/ffoodd/ffeeeedd
 *
 * @package CDI_Base 2.1.0
 * @since   CDI_Base 2.0.0
 */


add_filter( 'wp_nav_menu', 'cdiwp_title_attr' );
add_filter( 'wp_list_pages', 'cdiwp_title_attr' );
add_filter( 'wp_list_categories', 'cdiwp_title_attr' );
add_filter( 'get_archives_link', 'cdiwp_title_attr' );
add_filter( 'wp_tag_cloud', 'cdiwp_title_attr' );
add_filter( 'the_category', 'cdiwp_title_attr' );
add_filter( 'edit_post_link', 'cdiwp_title_attr' );
add_filter( 'edit_comment_link', 'cdiwp_title_attr' );

function cdiwp_title_attr( $output ) {
    $output = preg_replace( '/\s*title\s*=\s*(["\']).*?\1/', '', $output );
    return $output;
}
